<?php declare(strict_types=1);
use PHPUnit\Framework\TestCase;
include "./BetterEmail.php";

final class BetterEmailTest extends TestCase
{
//    public function testCanBeCreatedFromEmailAddress(): void
    public function testCanBeCreatedFromVALIDEmailAddress(): void
    {
        $this->assertInstanceOf(
            BetterEmail::class,
            BetterEmail::fromString('user@example.com')
        );
    }

    public function testCannotBeCreatedFromInvalidEmailAddress(): void
    {
        $this->expectException(InvalidArgumentException::class);

        BetterEmail::fromString('emailsbagliata');
    }

    public function test_returns_the_correct_one(): void
    {
        $this->assertEquals(
            "user@example.com",
            BetterEmail::fromString('user@example.com')->__toString()
        );
    }
 
 /*    public function test_molto_significativo(): void {
            BetterEmail::fromString('user@example.com');
    }
*/

/**
 * @small 
 * */    
 
public function test_molto_significativo(): void
{
$this->assertEquals(
"user@example.com",
BetterEmail::fromString('user@example.com')->__toString()
);
        for ($i=0; $i<100000000; $i++) {
            $p=26543;
        }
}

} // end Test class
?>