<?php declare(strict_types=1);
use PHPUnit\Framework\TestCase;
include "./src/Conteggi.php";

final class ConteggiTest extends TestCase {

    public function testsomma(){
        $result = somma(1,12);
        $this->assertEquals(13, $result);
    }
    
    public function testsottrazione(){
        $result = sottrazione(1,1);
        $this->assertEquals(0, $result);
    }

	///////////////////////////////////////////////////////////////////////////
	// i primi due test funzionavano sempre
	// gli altri fallivano, evidenziando il problema sugli effetti collaterali
	// qui la funzione risultato e' ststa corretta e i test non falliscono piu'
	///////////////////////////////////////////////////////////////////////////

/**
 *  @group sideEffectsCreazioneMessaggio
 */
    public function testSideEffectForSotInCreazioneMessaggio(){
        $arg1 = array(
              "invio"=>"primo - secondo",
              "primoValore"=>6,
              "secondoValore"=>12,
        );
        $arg2=5; // $som
        $arg3=4; // $sot

        $result = creazioneMessaggioOutput($arg1, $arg2, $arg3); 
        $this->assertEquals(5, $arg3);
    }


/**
 *  @group sideEffectsCreazioneMessaggio
 */
    public function testSideEffectForSomInCreazioneMessaggio(){
        $arg1 = array(
              "invio"=>"primo + secondo",
              "primoValore"=>6,
              "secondoValore"=>12,
        );
        $arg2=5; // $som
        $arg3=4; // $sot

        $result = creazioneMessaggioOutput($arg1, $arg2, $arg3); 
        $this->assertEquals(6, $arg2);
     }




/**
 * @group sideEffectsRisultato
 */
public function testSideEffectForSomInRisultatoPerUnaSomma(){
    $arg4=5;   // $som in Conteggi
    $arg5=4;   // $sot in Conteggi

    $result = risultato("primo + secondo",13,10,$arg4,$arg5); 
    $this->assertEquals(6, $arg4);
}

/**
 * @group sideEffectsRisultato
 */
public function testNoSideEffectForSotInRisultatoPerUnaSomma(){
    $arg4=5;   // $som in Conteggi
    $arg5=4;   // $sot in Conteggi

    $result = risultato("primo + secondo",13,10,$arg4,$arg5); 
    $this->assertEquals(4, $arg5);
}

/**
 * @group sideEffectsRisultato
 */
public function testSideEffectForSotInRisultatoPerUnaSottrazione(){
    $arg4=5;   // $som in Conteggi
    $arg5=4;   // $sot in Conteggi

    $result = risultato("primo - secondo",13,10,$arg4,$arg5); 
    $this->assertEquals(5, $arg5);
}

/**
 * @group sideEffectsRisultato
 */
public function testNoSideEffectForSomInRisultatoPerUnaSottrazione(){
    $arg4=5;   // $som in Conteggi
    $arg5=4;   // $sot in Conteggi

    $result = risultato("primo - secondo",13,10,$arg4,$arg5); 
    $this->assertEquals(5, $arg4);
}

}
?>
