<?php declare(strict_types=1);
use PHPUnit\Framework\TestCase;
include "./src/Conteggi.php";

final class ConteggiTest extends TestCase {

    public function testsomma(){
        $result = somma(1,12);
        $this->assertEquals(13, $result);
    }
    
    public function testsottrazione(){
        $result = sottrazione(1,1);
        $this->assertEquals(0, $result);
    }


/**
 *  @group sideEffectsCreazioneMessaggio
 */
public function testSideEffectForSotInCreazioneMessaggio(){
    $arg1 = array(
          "invio"=>"primo - secondo",
          "primoValore"=>6,
          "secondoValore"=>12,
    );
    $arg2=5; // $som
    $arg3=4; // $sot

    $result = creazioneMessaggioOutput($arg1, $arg2, $arg3); 
    $this->assertEquals(5, $arg3);
}


/**
*  @group sideEffectsCreazioneMessaggio
*/
public function testSideEffectForSomInCreazioneMessaggio(){
    $arg1 = array(
          "invio"=>"primo + secondo",
          "primoValore"=>6,
          "secondoValore"=>12,
    );
    $arg2=5; // $som
    $arg3=4; // $sot

    $result = creazioneMessaggioOutput($arg1, $arg2, $arg3); 
    $this->assertEquals(6, $arg2);
 }


// in effetti non e'detto che creazioneMessaggio sia la funzione cattiva: lei chiama risultato ... 
// quindi serve uno unit test (o magari piu' di uno) su risultato
//  
/**
 * @group sideEffectsRisultato
 */
   public function testSideEffectForSomInRisultato(){
     $arg4=5;   // $som in Conteggi
     $arg5=4;   // $sot in Conteggi

     $result = risultato("primo + secondo",13,10,$arg4,$arg5); 
     $this->assertEquals(6, $arg4);
   }

}

?>
