<?php declare(strict_types=1);
use PHPUnit\Framework\TestCase;
include "./src/Conteggi.php";

final class ConteggiTest extends TestCase {

    public function testSomma(){
        $result = somma(1,12);
        $this->assertEquals(13, $result);
    }
    
    public function testSottrazione(){
        $result = sottrazione(1,1);
        $this->assertEquals(0, $result);
    }


/**
 *  @group sideEffectsCreazioneMessaggio
 */
    public function testSideEffectForSotInCreazioneMessaggio(){
        $arg1 = array(
              "invio"=>"primo - secondo",
              "primoValore"=>6,
              "secondoValore"=>12,
        );
        $arg2=5; // $som
        $arg3=4; // $sot

        $result = creazioneMessaggioOutput($arg1, $arg2, $arg3); 
        $this->assertEquals(5, $arg3);
    }


/**
 *  @group sideEffectsCreazioneMessaggio
 */
    public function testSideEffectForSomInCreazioneMessaggio(){
        $arg1 = array(
              "invio"=>"primo + secondo",
              "primoValore"=>6,
              "secondoValore"=>12,
        );
        $arg2=5; // $som
        $arg3=4; // $sot

        $result = creazioneMessaggioOutput($arg1, $arg2, $arg3); 
        $this->assertEquals(6, $arg2);
     }

}

?>
