<?php declare(strict_types=1);
use PHPUnit\Framework\TestCase;
include "./src/Conteggi.php";

final class ConteggiTest extends TestCase {


    //usare data provider
    
    //data provider
    public function datiSperimentali() {
        $dati = [
            [31, 30, 1],
            [-16,-7,-9],
            [2,11,-9],
            [15.93,7.93,8],
            [-1.01,7.93,-8.94]
        ];
    return $dati;
    }

    //funzione che esegue i test, basati sui dati del data provideer

    /**
     * @dataProvider datiSperimentali
     */
    public function testSommaInteriConDataProvider($ris, $add1, $add2) {
        $this->assertEquals($ris, somma($add1, $add2));
    }

    public function testSommaInteriPositivi(){
        $result = somma(1,129);
        $this->assertEquals(130, $result);
    }
    
    public function testSommaInteriNegativi(){
        $result = somma(-1,-129);
        $this->assertEquals(-130, $result);
    }
    
    public function testSommaInteriPosNeg(){
        $result = somma(1,-129);
        $this->assertEquals(-128, $result);
    }
    
    public function testSommaRealeIntero(){
        $result = somma(1.123,29);
        $this->assertEquals(30.123, $result);
    }
    
    public function testSommaRealiPosNeg(){
        $result = somma(1.123,-4.123);
        $this->assertEquals(-3, $result);
    }
    
    public function testSottrazioneMoltoGenerico(){
        $result = sottrazione(1961,1961);
        $this->assertEquals(0, $result);
    }


    // lasciamoli ...
    public function testSommaInteriTuttiInUnaVolta(){
        $dati = [
            [10, 6, 4],
            [-10,-6,-4],
            [80,91,-11],
            [-100,-80,-20]
        ];

        $this->assertEquals($dati[0][0], somma($dati[0][1], $dati[0][2]));
        $this->assertEquals($dati[1][0], somma($dati[1][1], $dati[1][2]));
        $this->assertEquals($dati[2][0], somma($dati[2][1], $dati[2][2]));
        $this->assertEquals($dati[3][0], somma($dati[3][1], $dati[3][2]));
    }

    public function testSommaInteriTuttiInUnaVoltaMeglio(){
        $dati = [
            [10, 6, 4],
            [-10,-6,-4],
            [80,91,-11],
            [-100,-80,-20]
        ];

        foreach($dati as $val)
           $this->assertEquals($val[0], somma($val[1], $val[2]), "$val[0] non e' $val[1]+$val[2]");
    }

    
}
?>