<?php declare(strict_types=1);
use PHPUnit\Framework\TestCase;
include "./src/Conteggi.php";

final class ConteggiTest extends TestCase {

    // stato finale, piu' o meno, di exp12
    public function experimentalValues(){
        $dati = [
           [13, 1, 12],
           [-24, -12,-12],
           [24.43, -12.1, 36.53],
           [0.12, 12.12,-12]        
        ];
    return $dati;    
    }

    /**
     * @dataProvider experimentalValues
     */
    public function testsommaTuttiInsiemeConDataprovider($arg1, $arg2, $arg3){
       $this->assertEquals($arg1, somma($arg2, $arg3)); 
    } 

    public function testsommaInteriPositivi(){
        $result = somma(1,12);
        $this->assertEquals(13, $result);
    }
    
    public function testsommaInteriNegativi(){
        $result = somma(-1,-12);
        $this->assertEquals(-13, $result);
    }
    
    public function testsommaRealiNegativoPositivo(){
        $result = somma(-12.6,13.8);
        $this->assertEquals(1.2, $result);
    }
    
    public function testsommaRealeIntero(){
        $result = somma(12.6,13);
        $this->assertEquals(25.6, $result);
    }
    
    public function testsottrazioneMoltoGenerico(){
        $result = sottrazione(1,1);
        $this->assertEquals(0, $result);
    }

}

?>
