<?php declare(strict_types=1);
use PHPUnit\Framework\TestCase;
include "./src/Email.php";

final class EmailTest extends TestCase
{
    public function testCanBeCreatedFromValidEmailAddress(): void
    {
        $this->assertInstanceOf(
            Email::class,
            Email::fromString('user@example.com')
        );
    }

    public function testCannotBeCreatedFromInvalidEmailAddress(): void
    {
        $this->expectException(InvalidArgumentException::class);

        Email::fromString('emailsbagliata');
    }

    public function test_Returns_The_Correct_One(): void
    {
        $emailItem = new Email("user@example.com");
        $this->assertEquals(
            "user@example.com", $emailItem->__toString()
        );
    }
    
	
} // end Test class
?>
