<?php declare(strict_types=1);
use PHPUnit\Framework\TestCase;
include "./Email.php";

final class EmailTest extends TestCase
{
    public function testCanBeCreatedFromEmailAddress(): void
    {
        $this->assertInstanceOf(
            Email::class,
            Email::fromString('user@example....com')
        );
    }

    public function testCannotBeCreatedFromInvalidEmailAddress(): void
    {
        $emailSbagliata = 'user@example.....com'; 
        $this->assertNotEquals(
            $emailSbagliata,
            Email::fromString($emailSbagliata)->__toString(), 
            "Tsk ... abbiamo usato una email irregolare e invece ..."
        );
    }

    public function test_returns_the_correct_one(): void
    {
        $this->assertEquals(
            "user@example.com",
            Email::fromString('user@example.com')->__toString()
        );
    }

	
} // end Test class
?>
