<?php declare(strict_types=1);
use PHPUnit\Framework\TestCase;
include "./Email.php";

final class EmailTest extends TestCase
{
    public function testCanBeCreatedFromEmailAddress(): void
    {
        $this->assertInstanceOf(
            Email::class,
            Email::fromString('user@example.com')
        );
    }

    public function test_returns_the_correct_one(): void
    {
        $this->assertEquals(
            "user@example.com",
            Email::fromString('user@example.com')->__toString()
        );
    }

} // end EmailTest
?>