<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
    <head>
        <title>libri con XML e DOM</title>
        <style>
           *.centrat {
              text-align: center;
           }
           *.bordoRosa {
              border: solid pink thick;
           }
           *.bordoBlu {
              width: 90%; margin-left: 5%; padding: 1ex; 
			  border: solid blue thin;
           }
        </style>
    </head>
    <body>
<?php
$xmlString = "";
$nomeFile = "libri.6.xml";


foreach ( file($nomeFile) as $node ) {
	$xmlString .= trim($node);
}

$doc = new DOMDocument();
$doc->loadXML($xmlString);

/* validazione del documento: schemaValidate() e' una funzione del domdocument che valida il documento rispetto allo schema passato */
if ($doc->schemaValidate("libri.6.xsd")) {
  echo "<p>This document is valid</p>\n";
} else  {
  echo "<p>This document is not valid</p>\n";
}

$root = $doc->documentElement;
$elementi = $root->childNodes;

echo "<div class = \"bordoRosa\">\n";
for ($i=0; $i<$elementi->length; $i++) {

    $elemento = $elementi->item($i);

    $isbn = $elemento->getAttribute("isbn");

	$listaAutori = $elemento->getElementsByTagName("author");
    $numAutori = $listaAutori->length;

	$elemTitolo = $elemento->getElementsByTagName("title");

	$elemAnno = $elemento->getElementsByTagName("year");
	$elemEditore = $elemento->getElementsByTagName("publisher");
//
//	$titolo = $elemTitolo->get_content();
//	$anno = $elemAnno->textContent;
//	$editore = $elemEditore->textContent;

    $autori="";
	for ($j=0; $j<$numAutori; $j++) {
	  $autori .= $listaAutori->item($j)->firstChild->textContent;
	  $autori .= " ";
	  $autori .= $listaAutori->item($j)->lastChild->textContent;
	  if ($j+1==$numAutori) {
	    $autori .= ": ";
	  } else $autori .= ", ";


	}

    echo "<p class=\"bordoBlu\">\n   " . $autori . $elemTitolo->item(0)->textContent . ". " . $elemEditore->item(0)->textContent . " (" . $elemAnno->item(0)->textContent . ") -- ISBN " . $isbn ."</p>\n";
} // end for
echo "</div>\n";
?>
</body>
</html>