<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
    <head>
        <title>elenco di temperature con XML e DOM in PHP</title>
		<style>
  		  *.centrat {text-align: center;}
		</style>
    </head>
<body>

<table border="1" 
       cellspacing="3" 
	   cellpadding="5"
       summary="una collezione di rilievi metereologici: per diverse citta' del mondo, viene mostrata la temperatura e il grado di unidita', rilevati oggi, qualunque sia oggi ...">
<caption style="color: olive; font-style: oblique; font-weight: bold">Temperature registrate qui e l&igrave; in giro per il mondo</caption>

<thead>
 <tr>
  <th style="width: 20%;">citt&agrave;</th>
  <th>temperatura registrata</th>
  <th>umidit&agrave; media relativa</th>
 </tr>
</thead>

<tbody>
<?php
//
// numero di elementi da stampare per pagina
							$pageLength = 7;
//
//

$xmlString = "";
foreach ( file("temperature.xml") as $node ) {
	$xmlString .= trim($node);
}

$doc = new DOMDocument();
if (!$doc->loadXML($xmlString)) {
  die ("Error mentre si andava parsando il documento\n");
}

$records = $doc->documentElement->childNodes;

// se questa pagina e' stata chiamata con "next=qualchecosa" nella
// uri di chiamata, vuol dire che avevamo gia' stampato qualcosa;
//
if ( isset($_GET['next']) ) {
	$first = $_GET['next'];
} else {
	$first = 0;
}
//
// next, se c'e', ci dice da quale record 
// 		(individuato da un indice che va da first a last) 
// bisogna ripartire nella stampa
//
if ( $records->length - $first < $pageLength ) {
	$last = $records->length;
} else {
	$last = $first + $pageLength;
}

for ($i=$first; $i<$last; $i++) {
    $record = $records->item($i);

	$town = $record->firstChild;
	$townName = $town->textContent;

	$temp = $town->nextSibling;
	$tempValue = $temp->textContent;;

	$humid = $record->lastChild;
	$humidValue = $humid->textContent;;
	print "<tr><td>$townName</td><td>$tempValue</td><td>$humidValue</td></tr>\n";
}
?>
<!--
// chiusura tabella
-->
</tbody>
</table>

<?php
// ora si forma la linea finale della pagina;
// questa linea contiene un riferimento alla prossima pagina, se
// i record da stampare non sono finiti,
// oppure un'indicazione che la stampa e' terminata
//
// il link alla prossima pagina, se presente, deve essere del tipo
// PHP_SELF?next=$last (dove $last = indice ultimo record stampato
//
if ( $last < $records->length - 1 ) {
     echo '<p><a href="temperature.2.php?next='
     . $last
     . '">prossimo gruppo di stampe &gt;&gt;&gt;</a></p>';
} else {
	print '<p>** Fin **</p>';
}
?>
</body></html>