<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html   PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
  <title>esperimenti con la gestione dei file XML usando il binding DOM di PHP</title>
</head>

<body>
<h2>esperimenti con la gestione dei file XML usando il binding DOM di PHP</h2>
<p style="color:red; font-weight: 75%">funziona anche sotto linux ...</p>
<p style="color:red; font-weight: 75%">va visto attentamente il codice di questo script</p>

<p>qui carichiamo il documento xml con le temperature e, usando dom:</p>
<ol>
<li>visitiamo il primo, il secondo e l'ultimo elemento del documento</li>
<li>ne stampiamo le citta'</li>
<li>creiamo un nuovo record e lo inseriamo in testa al documento</li>
<li>cloniamo due volte il nuovo record e inseriamo i cloni uno prima del vecchio-secondo-nodo e l'altro in fondo al documento</li>
<li>eliminiamo quello che era il secondo nodo (alicante)</li>
<li>e poi salviamo il documento in un nuovo file xml</li>
<li>anzi in quattro: verificare le differenze - il primo e il secondo non vengono creati perche' per scriverne il nome abbiamo usato dirname() e quindi non siamo riusciti a scrivere path assoluti; il terzo e il quarto hanno path assoluti perche' siamo partiti dalla stringa ottenuta con realpath()</li>
</ol>

<?php
echo '<h4> --- $_SERVER[PHP_SELF] =======';
echo $_SERVER['PHP_SELF'];
echo "------------------------</h4>";

echo '<h4> --- __FILE__ =======';
echo __FILE__;
echo "------------------------</h4>";

echo '<h3> --- dirname($_SERVER[PHP_SELF]) =======';
echo dirname($_SERVER['PHP_SELF']);
echo "------------------------</h3>";

echo '<h3> --- dirname(__FILE__) =========';
echo dirname(__FILE__);
echo "------------------------</h3>";

echo '<h3> --- realpath($_SERVER[PHP_SELF]) ========';
echo realpath($_SERVER['PHP_SELF']);
echo "------------------------</h3>";

echo '<h3> --- realpath(__FILE__) =========';
echo realpath(__FILE__);
echo "------------------------</h3>";


// modifiche nel documento xml
$xmlString = "";
foreach ( file("temperature.xml") as $node ) {
	$xmlString .= trim($node);
}

$doc = new DOMDocument();
if (!$doc->loadXML($xmlString)) {
  die ("Error mentre si andava parsando il documento\n");
}


$root = $doc->documentElement;

$records = $doc->documentElement->childNodes;

// il primo, il secondo e l'ultimo nodo del file
$primo = $records->item(0);
$secondo = $records->item(1);
$ultimo= $root->lastChild;
echo '<p style="color: blue; font-size: 125%">';
echo "\n--- la variabile ". '$primo' . "contiene il primo record del file xml";
echo "\n<br />--- la variabile ". '$secondo' . "contiene il secondo record del file xml";
echo "\n<br />--- la variabile ". '$ultimo' . "contiene il record di fine file xml";


// stampa di allenamento; il primo figlio del primo record
$primaTown = $records->item(0)->firstChild->textContent;
echo "\n<br />--- il firstChild->textContent del primo record e' la prima citta'";

// altre stampe varie
$secondaTown = $records->item(1)->firstChild->textContent;
echo "\n<br />--- il firstChild->textContent del secondo record e' la seconda citta'";

echo "\n<br />--- il firstChild->textContent dell'ultomo record e' l'ultima citta'";
/* si puo' scrivere come segue in questo commento, oppure come dopo il commento ...:
     $ultimaTown = $root->lastChild->firstChild->textContent;
*/
$ultimaTown = $records->item($records->length-1)->firstChild->textContent;
echo "</p>";

echo '<p style="color: blue; font-size: 125%">';
echo "\n<br />--- prima: $primaTown ---";
echo "\n<br />--- seconda: " . $records->item(1)->firstChild->textContent . "---";
echo "\n<br />--- ultima citta': $ultimaTown ---";
echo "</p>";


echo '<p style="color: blue; font-size: 125%">';
echo "\n--- ora viene creato un nuovo record ...";
// creazione di un nuovo <record>
$newRecord = $doc->createElement("record");
$newTown = $doc->createElement("town", "NUOVATOWN");
$newTemperature = $doc->createElement("temperature", "80");
$newHumidity = $doc->createElement("humidity", "8");
$newRecord->appendChild($newTown);
$newRecord->appendChild($newTemperature);
$newRecord->appendChild($newHumidity);
echo "\n<br />--- ... ecco fatto ";
echo "\n<br />--- il nuovo record: " . $newRecord->firstChild->textContent;
echo "\n<br />--- " . $newRecord->childNodes->item(1)->textContent;
echo "\n<br />--- " . $newRecord->lastChild->textContent . " ---";
echo "\n</p>";

/*
inserimento
	- prima del primo nodo,
	- poi prima del(l'ex) secondo
	- e poi in fondo
il secondo e il terzo nodo inseriti devono essere cloni del primo altrimenti in ogni nuovo inserimento viene usato ancora il primo nodo (provare ...)
*/
echo '<p style="color: blue; font-size: 125%">';
echo "\n--- ora viene inserito il nuovo record ...";

$root->insertBefore($newRecord, $primo);
echo "\n<br />--- prima del primo ...";

$newRecord2=$newRecord->cloneNode(TRUE);
$root->insertBefore($newRecord2, $secondo);
echo "\n<br />--- prima del secondo ... si tratta di un clone del record precedente ...";

$newRecord3=$newRecord->cloneNode(TRUE);
$root->appendChild($newRecord3);
echo "\n<br />--- e dopo l'ultimo ...";

// eliminazione del record che all'inizio era il secondo
$root->removeChild($secondo);
echo "\n<br />--- e poi per soprammercato eliminamo il nodo che, prima degli inserimenti, era il secondo ...";
echo "\n</p>";



// salvataggio del documento modificato
$path1=dirname($_SERVER['PHP_SELF']) . "/pippo1.xml";
$path2=dirname(__FILE__) . "/pippo2.xml";

/* qui sfruttiamo la stringa prodotta per il php_self, nei due modi,
   per produrre la stringa con il nome del nuovo file (quello in cui
   effettuiamo il salvataggio
*/
$path3=str_replace('dom-experiments.php', 'pippo3.xml', $_SERVER['PHP_SELF']);
$path4=str_replace('dom-experiments.php', 'pippo4.xml', realpath(__FILE__));

echo "\n creati 4 path per i file pippiN.xml in cui salvare il documento manipolato in memoria:";
echo "\n<h4>path1 - $path1</h3>";
echo "\n<h4>path2 - $path2</h3>";
echo "\n<h4>path3 - $path3</h3>";
echo "\n<h4>path4 - $path4</h3>";
echo "\n (vedi il codice di questo script per come ...)";

echo "<h3>-------------------------------------------------</h3>";
echo "<p style=\"color: red; font-size: 125%; margin-bottom: 0\">";
echo "\nSeguono quattro operazioni di salvataggio, fatte usando quattro stringhe \"nomefile\" prodotte in quattro modi diversi; il risultato e' che solo due di questi salvataggi - quelli in cui e' fornito un path assoluto - vanno a buon fine (per cui i due file prodotti dovrebbero trovarsi nella directory in cui questo script ha girato, con i cambiamenti prodotti (aggiunta di tre nodi ed eliminazione di uno). Gli altri due \"pippoN.xml\" non vengono prodotti";
echo "\n</p>";

echo "<p style=\"color: red; font-size: 125%; margin-bottom: 0\">salvataggio in path1 = $path1</p>";
$doc->save($path1);

echo "<p style=\"color: blue; font-size: 125%; margin-bottom: 0\">salvataggio in path2 = $path2</p>";
$doc->save($path2);

echo "<p style=\"color: red; font-size: 125%; margin-bottom: 0\">salvataggio in path3 = $path3</p>";
$doc->save($path3);

echo "<p style=\"color: blue; font-size: 125%; margin-bottom: 0\">salvataggio in path4 = $path4</p>";
$doc->save($path4);
?>

</body>
</html>