<?php
/* questo e` lo script che permette di scegliere lo stile di visualizzazione del "sito web".
Viene presentata una form;
quando la form e` inviata si esegue una processazione, e poi si mostra di nuovo la form.
La pagina prodotta, e` stilizzata 
- la prima volta con lo stile di default, dato che la form non e` stata inviata, ne' cookie di presentazione sono stati settati;
- la seconda volta, proveniendo dall'invio della form presentata la prima volta, con lo stile definito in base al contenuo di $_POST; qui i cookie sono stati settati, ma ancora non inviati; verrranno inviati dal client con la prossima richiesta;
- le volte successive con lo stile costruito usando i cookie esistenti.
*/

define(
"DEFAULT_STYLE", 
"<style type=\"text/css\">\n
    body {\n
	  \t font-family: Courier New; \n
	  \t font-weight: bold;\n
	  \t font-size: 140%;\n
	  \t background: white;\n
	  \t color: black;\n
	}\n
</style>\n"
);

ini_set('display_errors', 1);
error_reporting(E_ALL & ~E_NOTICE);

$stileProvvisorio = DEFAULT_STYLE;

 if (isset($_POST['invio']))          // proveniamo dalla form e non da altrove ... 
  									  // cioe' abbiamo appena dato (inviato) dati
    if ($_POST['coloreSfondo'] && $_POST['coloreFont']) {
       setcookie('coloreSfondo', $_POST['coloreSfondo']);
       setcookie('coloreFont', $_POST['coloreFont']);
       $cookieSent=1;
	     /* per far colorare la pagina di risposta secondo le scelte 
		    (che ancora non sono memorizzate nei cookies sul cliente, 
			 dato che abbiamo appena mandato i cookies) */
       $stileProvvisorio = "<style type=\"text/css\">\nbody {\n\t background: ".$_POST['coloreSfondo'].";\n\t color: ".$_POST['coloreFont'].";\n}\n</style>\n";
    }
    else {
      $cookieSent="no perch&eacute; dati mancanti";      // non sono partiti nuovi cookie, errore dati
      echo "dati mancanti!<br />";
    }
 else $cookieSent="no perch&eacute; lo script non &egrave; stato chiamato come action ma tramite link";     
      /* non sono partiti nuovi cookie e non si proviene dalla form */



/* e questa pagina con quali stili viene visualizzata??
	- se stiamo rispondendo alla form che permette di definire i colori, 
	  usiamo lo stile provvisorio 
	  (che e` stato calcolato sopra proprio nel caso "$_POST esiste");
	- se sono settati entrambi i cookie di visualizzazione li usiamo ...
	- senno` usereme o lo stile di default (svedese)
*/
 if (isset($_POST['invio']))
    $stileInterno=$stileProvvisorio;
 elseif (isset($_COOKIE['coloreSfondo']) && isset($_COOKIE['coloreFont']))
    $stileInterno="<style type=\"text/css\">\nbody {\n\t background: ".$_COOKIE['coloreSfondo'].";\n\t color: ".$_COOKIE['coloreFont'].";\n}\n</style>\n";
 else
    $stileInterno = DEFAULT_STYLE;
/* dopo qyuesto codice $stileInterno esiste ed e` settata come si deve ... */

 echo '<?xml version="1.0" encoding="ISO-8859-1"?>';
?>
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
  <title>personalizzazione con cookies</title>
  <?php if (isset($stileInterno)) echo $stileInterno; 
        // mettiamo nella head lo stile per la pagina 
  ?>
</head>

<body>
<h3>
<?php
/* NB 
qui usiamo esclusivamente i cookie per costruire lo stile di visualizzazione;
in questo modo si produce lo sfalsamento tra il momento in cui i cookie sono stati settati (dal server sul browser) ma ancora mai ricevuti dal server (perche' il browser non ha ancora fatto una richiesta con cui inviare anche i cookie ...
la soluzione migliore per evitare questo sfalsamento e` utilizzare, in questo breve intervallo, i valori che sono in $_POST: la fase in cui il server setta i cookie e` proprio quella in cui sta elaborando i dati arrivato dalla form di cambio stile, quindi quei dati sono in POST e quindi possono essere usati per costruire provvisoriamente lo stile, in attesa che poi si possano usare i cookie.
*/

 if ($cookieSent==1)
    echo "Abbiamo preso nota delle tue assegnazioni (sfondo "
         ."=".$_POST['coloreSfondo']." e colore font "."=".$_POST['coloreFont'].").
         Torna alla <a href=\"principio.php\" alt=\"aa\">pagina principale</a>, oppure ";
    echo "scegli come ti pare colore di sfondo e colore della font ...\n"
?>
</h3>

<hr />
<form action="<?php $_SERVER['PHP_SELF']?>" method="post">
 <select name="coloreSfondo">
  <option value="">colore di sfondo</option>
  <option value="green">green</option>
  <option value="red">red</option>
  <option value="indianred">indian red</option>
  <option value="purple">purple</option>
  <option value="maroon">maroon</option>
  <option value="Ivory">Ivory</option>
  <option value="Cornsilk">Cornsilk</option>
  <option value="DarkBlue">DarkBlue</option>
  <option value="black">black</option>
  <option value="white">white</option>
 </select>

 <select name="coloreFont">
  <option value="">colore del carattere</option>
  <option value="green">green</option>
  <option value="red">red</option>
  <option value="indianred">indian red</option>
  <option value="purple">purple</option>
  <option value="maroon">maroon</option>
  <option value="Cornsilk">Cornsilk</option>
  <option value="DarkBlue">DarkBlue</option>
  <option value="Ivory">Ivory</option>
  <option value="black">black</option>
  <option value="white">white</option>
 </select>

<input type="submit" name="invio" value="si', cosi'">
<input type="reset" name="reset" value="reset">

</form>
<hr />
<?php
 echo "<p>\$_COOKIE: (quelli noti al server mentre produceva questa pagina)</p>\n";
 echo "\n<pre>";
      print_r ($_COOKIE);
 echo "</pre>\n";

 if (isset($_POST['invio']) && ($cookieSent!="no perch&eacute; dati mancanti"))
    echo "<p style=\"background: blue; color: white; font-weight: 76%;\">MA ... mentre il server produceva la pagina settava i cookie, cosi` ora il client li ha in store e li mandera` ogni volta che manda una richiesta\n<br />(Leggi i commenti in questo script ...)\n</p>\n<hr />\n";
	
 echo "<p>\$_POST: (quelli arrivati dalla form ... se sono arrivati)</p>\n";
 echo "\n<pre>";
      print_r ($_POST);
 echo "</pre>\n";

 echo "<p>\$cookieSent=$cookieSent</p>\n";
?>

<hr style="margin-top: 2ex;" />
<p><a href="principio.php">pagina principale</a></p>
<hr />
<p><a href="altra.pagina.php">l'altra pagina del sito</a></p>
<hr />

</body>
</html>
