<?php
/* funzione per stampare una form, definita in base ai parametri.
   I primi 2 parametri sono definiti con valori di default (action e method;
   possono essere riassegnati dai parametri attuali in sede di chiamata.
   
   I successivi parametri sono coppie <nomecampo,lunghezza> che dicono quali campi testuali vogliamo siano inseriti nella form: possiamo indicare,nella chiamata, qualsiasi numero di campi, e relative lunghezze.
   Yes, si tratta di tutti campi di input testo

   Usando func_num_args() si ottiene il numero di argomenti che sono stati effettivamente passati.

   Con func_get_arg(i) si ha lo i-esimo argomento.
*/
function stampaForm($action="", $method="POST") {
   $numeroArg=func_num_args();

   $ris="<form action='".func_get_arg(0)."' method='".func_get_arg(1)."'>\n";

   for($i=2; $i<$numeroArg; $i+=2) {
     $ris.="<p>".func_get_arg($i).":
     <input type='text' name='".func_get_arg($i)."'
     size='".func_get_arg($i+1)."'></p>\n";
   }

   $ris.="\n<p><input type=\"submit\" name=\"invio\" value=\"submit\"></p>
<p><input type=\"reset\" value=\"Annulla le scelte\"></p>\n";

   $ris.="</form>\n";
echo $ris;
return $ris;
}
?>



<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
 <title>esempi funzioni - 3</title>
</head>

<body>
<hr />
stampaForm("funzioni3.php", "post", primoCampo, 112, secondoCampo, 30, terzoCampo, 20);
<?php
stampaForm("funzioni3.php", "post", "primoCampo", 112, "secondoCampo", 30, "terzoCampo", 20);
// provare con 4 campi (cio&egrave; due parametri in pi&ugrave; ...
//
/* comunque questo &egrave; un esempio di una cosa che si puo' fare, ma che va fatta solo se
proprio risulta indispensabile ...
infatti c'&egrave; una cattiva interazione tra default value per gli argomenti e possibili argomenti addizionali

ad esempio,
- la prossima chiamata non va bene (mancano i due parametri definiti)
	stampaForm();

- nella prossima chiamata non ci si accorge (ovviamente) del fatto che i primi due arg sono omessi
e quindi i primi due arg opzionali passati vengono interpretati come action e method
	stampaForm(primoCampo, 12, secondoCampo, 30, terzoCampo, 20);

(in altre parole l'uso dei valori di default per i primi due argomenti in questo esercizio &egrave;
solo a scopo esemplificativo e non &egrave; da replicare necessariamnete come abitudine ...
*/
?>
<hr />


<p>...vedi il codice dello script che ha prodotto questa pagina ...</p>
</body>
</html>