// Import the net libraries
import processing.net.*;

// Declare a server
Server server;

// Used to indicate a new message has arrived
float newMessageColor = 255;

String incomingMessage = "" ;

void setup() {
 size(400,200); 
 server = new Server(this, 5204); // Create the Server on port 5204
}

void draw() {
 background(newMessageColor);
 
 // newMessageColor fades to white over time
 newMessageColor += 0.3;
 newMessageColor = constrain(newMessageColor,0,255);

 textAlign(CENTER);
 fill(255);
 
 text(incomingMessage,width/2,height/2);

 // If a client is available, we will find out
 // If there is no client, it will be " null "
 Client client = server.available();
 
 // We should only proceed if the client is not null
 if (client != null) {
   
   // Receive the message
   incomingMessage = client.readString();
   incomingMessage = incomingMessage.trim();
   
   // Print to Processing message window
   println( " Client says: " + incomingMessage);
  
  if(incomingMessage.equalsIgnoreCase("hello") || incomingMessage.equalsIgnoreCase("hi")) {
    server.write( "Hello my friend!\n" );
    println("ECCOLO");
    }
  else if(incomingMessage.equalsIgnoreCase("how are you")) {
    server.write("Fine, thanks!\n");
    println("ECCOLO2");
    }
  else if(incomingMessage.equalsIgnoreCase("i am tired")) {
    server.write("Well, you can drink coffeee!\n");
    println("ECCOLO3");
    }
  else {
    server.write("I am sorry, but my vocabulary is very limited...\n");
    println("ECCOLO4");
    }
  
  // Reset newMessageColor to black
  newMessageColor = 0;
}
}

// The serverEvent function is called whenever a new client connects.
void serverEvent(Server server, Client client) {
 incomingMessage = " A new client has connected: " + client.ip();
 println(incomingMessage);
 // Reset newMessageColor to black
 newMessageColor = 0;
}