// chat configuration
String chatbot = "Hendrik";
String channel = "andersen";

// images for icons of user and hendrik bot
PImage userIcon, hendrikIcon;

// variables that have colors
color gray = color(199);
color red = color(255, 0, 0);
color green = color(0, 255, 0);
color blue = color(0, 0, 255);
color yellow = color(255, 204, 0);
color white = color(255);
color lightblue = color(0, 102, 153);
color currentColor = gray;

// variable that holds the current scene
int scene = 1;

// initialization first message 
String initialMessage = "Hi, is anybody home?";

void setup() {
  // initialize screen size and colors
  size(640, 480);
  // initialize the background to gray
  background(gray);
  // initialize the color of drawn objects to white
  fill(lightblue);
  // intialize the font to be use for the displayed text messages
  PFont myfont = loadFont("AgencyFB-Bold-48.vlw");
  textFont(myfont);
  textSize(48);
  // initialize the chat connection of the Processing chatbot
  initializeChat();
  // initialize the image of the flower
  userIcon = loadImage("flower.png");
  hendrikIcon = loadImage("flower.png");
  // initialize the hendrik bot responses to the database
  initializeResponses();
}

void draw() {
  // check for new messages in the chatboard and
  // call the handleMessage block for reacting to them
  checkMessages();
  
}

void initializeResponses() {
  StringList responses; 

  // add responses for the keyword "hungry"
  responses = new StringList();
  responses.append("Why don't you get a sandwitch?");
  responses.append("There is pizza in the fridge");
  responseTable.put("hungry", responses);

  // add responses for the keyword "thirsty"
  responses = new StringList();
  responses.append("Why don't you get a spritz?");
  responses.append("There is cold water the fridge");
  responses.append("When I am thirsty I drink a martini. Shaken, not stirred.");
  responseTable.put("thirsty", responses);

  // add responses for the keyword "hi, hello, etc"
  responses = new StringList();
  responses.append("Hi there");
  responses.append("Hi, my name is Bond. James Bond.");
  responses.append("Hello. Do you come here often?");
  responseTable.put("Hi|hi|Buongiorno|buongiorno|Hello|hello|Ola|ola", responses);

  // add responses for the keyword "how are you"
  responses = new StringList();
  responses.append("I'm fine thanks");
  responseTable.put("how", responses);
}