// imports needed for sending receiving HTTP messages
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.lang.reflect.Type;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
//import org.apache.log4j.Logger;
import com.google.gson.JsonObject;

String chatroom = "imd2016";

// helper variables to keep track of initialization and last message id
boolean initialized = false;
String lastMessage = "";
int timestamp = 2000;

// data structure for responses
HashMap<String, StringList> responseTable;

// helper function for building a Json object from a string
StringEntity buildEntityFromJsonData( String jsonData ) throws Exception {
  StringEntity result = null;
  try {
    result = new StringEntity( jsonData );
  } 
  catch( Throwable t ) {
    String msg = "unable to create entity from data; data was: " + jsonData;
    //LOGGER.error( msg );
    throw new Exception( msg, t );
  }
  return result;
}

// helper function for making an HTTP request
HttpResponse makeRequest( HttpRequestBase request ) throws Exception {
  HttpResponse response = null;

  // sanity-check
  if ( request == null ) {
    String msg = "request cannot be null";
    //LOGGER.error( msg );
    throw new Exception( msg );
  }
  try {
    HttpClient client = new DefaultHttpClient();
    response = client.execute( request );
  } 
  catch( Throwable t ) {
    String msg = "unable to receive response from request(" + request.getMethod() +  ") @ " + request.getURI();
    //LOGGER.error( msg );
    throw new Exception( msg, t );
  }
  return response;
}

// initialization function that posts a welcome message 
// and keeps the id for updating newer messages
void initializeChat() {
  // Post a welcome message on the board
  String response = postMessage(initialMessage);

  // Get the response and get the name (ID) of the message 
  // so that later we can take only messages after that
  JsonObject jobj = new Gson().fromJson(response, JsonObject.class);
  lastMessage = jobj.get("name").getAsString();
      // debug
      // println("Last message ID: " + lastMessage);
      // initialize data structure for responses
  responseTable = new HashMap<String, StringList>();
  // add responses to the chatbot
  initializeResponses();
  // set the flag to true
  initialized = true;
}

String getResponse(String message) {
  // iterate over the responses data structure
  for (Map.Entry me : responseTable.entrySet()) {
    // if the message matches the regular expression  
    // then pick a response from the list
    if (match(message, (String)me.getKey())!=null) {
      StringList responses = (StringList)me.getValue();
      // pick a random index
      int i = int(random(responses.size()));
      return responses.get(i);
    }
  }
  // if there is not matched response then return null
  return null;
}

void handleMessage(String msg) {
  if (!msg.equals("")) {
    // get a random position on the screen 
    float xpos= random(100, width-150);
    float ypos = random(100, height-100);
    image(userIcon, xpos-80, ypos-70, 100, 100);
    text(msg, xpos, ypos);
    String response;
    response=getResponse(msg);
    if (response!=null) {
      postMessage(response);
      image(hendrikIcon, xpos-80, ypos-70+50, 100, 100);
      text(response, xpos, ypos+50);
    }
  }
}


// main function that posts a message on the chatboard
String postMessage(String message) {
  // initialize the url and data to be sent as an HTTP POST request to Firebase
  String url = "https://arch-iot.firebaseio.com/"+chatroom +"/"+channel+".json";
  String jsonData = "{ \"name\": \"" + chatbot  + "\", \"text\": \"" + message + "\" }";

  //debug
  //println("Message details:"); println(chatbot); println(text); println(jsonData);

  String response = "";
  try {
    // make a new request object
    HttpPost request = new HttpPost( url );
    // build a Json object for the data of the request
    request.setEntity( this.buildEntityFromJsonData( jsonData ) );
    // make the request and get the response of the server
    HttpResponse httpResponse = this.makeRequest( request );

    // transform the Json response to String
    HttpEntity entity = httpResponse.getEntity();
    if (null != entity) {
      response = EntityUtils.toString(entity, "UTF-8");
    }
    //debug
    //println("HTTP POST response:" + response);

    //*** if response ok then 
    println("Message sent from Processing chatbot " + chatbot + ": " + message);
  } 
  catch( Throwable t ) {
    String msg = "Unable to post data; data was: " + jsonData;
    println(msg);
  }
  // return the Json response
  return response;
} 

void readMessages() {
  // initialize url for HTTP request to look for newer messages
  String url = "https://arch-iot.firebaseio.com/"+chatroom +"/"+channel+".json?orderBy=\"$key\"&startAt=\"" + lastMessage + "\"";

  //debug
  //println(url);

  // *** check error for get request missing
  // easy HTTP GET request with loadStrings function from Processing
  String lines[] = loadStrings(url);
  if (lines.length > 0) {
    // parse the json response into a map of json objects. 
    // key is the id and value is the string of the json object.
    JsonParser parser = new JsonParser();
    JsonElement element = parser.parse(lines[0]);
    JsonObject obj = element.getAsJsonObject(); //since you know it's a JsonObject
    Set<Map.Entry<String, JsonElement>> entries = obj.entrySet();//will return members of your object

    // remove the last message from the list of returned results
    // this is because this is the last message we processed here
    Map.Entry<String, JsonElement> entryForLastMessage = null;
    for (Map.Entry<String, JsonElement> entry : entries) {
      String message = entry.getKey();
      if (message.equals(lastMessage))
        entryForLastMessage = entry;
    }
    if (entryForLastMessage != null)
      entries.remove(entryForLastMessage);

    if (entries.size()>0) {
      //println("There are " + (entries.size()) + " new messages:");
      for (Map.Entry<String, JsonElement> entry : entries) {
        //debug
        //System.out.println(entry);
        String message = entry.getKey();
        String name = ((JsonObject)(entry.getValue())).get("name").getAsString();
        String text = ((JsonObject)(entry.getValue())).get("text").getAsString();
        if (!name.equals(chatbot)) { 
          System.out.println("Message received from Processing chatbot " + name + ": " + text);
          handleMessage(text);
        }
        //replace the last message id if the new message is later
        if (message.compareTo(lastMessage) > 0)
          lastMessage = message;
      }
    }
  }
}

void checkMessages() {
  if (millis() > timestamp) {
    timestamp = millis() + 3000;
    if (initialized)
      this.readMessages();
  }
}