/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.util;

import com.google.gson.util.BufferedReader;
import com.google.gson.util.BufferedWriter;
import com.google.gson.util.N;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectFactory {
    static final int POOLABLE_SIZE = 8192;
    private static final int MAX_POOL_SIZE = 1024;
    private static final int MAX_ARRAY_POOL_SIZE = 320000;
    private static final Queue<List<?>> listPool = N.newArrayBlockingQueue(1024);
    private static final Queue<Set<?>> setPool = N.newArrayBlockingQueue(1024);
    private static final Queue<Map<?, ?>> mapPool = N.newArrayBlockingQueue(1024);
    private static final Queue<LinkedHashMap<?, ?>> linkedHashMapPool = N.newArrayBlockingQueue(1024);
    private static final Map<Integer, Queue<Object[]>> objectArrayPool = N.asConcurrentHashMap(new Object[0]);
    private static final Queue<char[]> charArrayBufferPool = N.newArrayBlockingQueue(1024);
    private static final Queue<byte[]> byteArrayBufferPool = N.newArrayBlockingQueue(1024);
    private static final Queue<StringBuilder> stringBuilderPool = N.newArrayBlockingQueue(1024);
    private static final Queue<ByteArrayOutputStream> byteArrayOutputStreamPool = N.newArrayBlockingQueue(1024);
    private static final Queue<BufferedWriter> bufferedWriterPool = N.newArrayBlockingQueue(1024);
    private static final Queue<BufferedReader> bufferedReaderPool = N.newArrayBlockingQueue(1024);

    public static <T> List<T> createList() {
        ArrayList list = listPool.poll();
        return list == null ? new ArrayList() : list;
    }

    public static <T> List<T> createList(int initCapacity) {
        ArrayList list = listPool.poll();
        return list == null ? new ArrayList(initCapacity) : list;
    }

    public static <T> Set<T> createSet() {
        HashSet set = setPool.poll();
        return set == null ? new HashSet() : set;
    }

    public static <K, V> Map<K, V> createMap() {
        HashMap map = mapPool.poll();
        return map == null ? new HashMap() : map;
    }

    public static <K, V> Map<K, V> createMap(Object ... a) {
        if (a.length % 2 != 0) {
            throw new IllegalArgumentException("the parameter must be the pairs of property name and value, or an entity class with get/set methods.");
        }
        Map<Object, Object> map = ObjectFactory.createMap();
        for (int i = 0; i < a.length; ++i) {
            map.put(a[i], a[++i]);
        }
        return map;
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap() {
        LinkedHashMap linkedHashMap = linkedHashMapPool.poll();
        return linkedHashMap == null ? new LinkedHashMap() : linkedHashMap;
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap(Object ... a) {
        if (a.length % 2 != 0) {
            throw new IllegalArgumentException("the parameter must be the pairs of property name and value, or an entity class with get/set methods.");
        }
        LinkedHashMap<Object, Object> map = ObjectFactory.createLinkedHashMap();
        for (int i = 0; i < a.length; ++i) {
            map.put(a[i], a[++i]);
        }
        return map;
    }

    public static Object[] createObjectArray() {
        return ObjectFactory.createObjectArray(8192);
    }

    public static Object[] createObjectArray(int size) {
        Object[] objArray = null;
        Queue<Object[]> arrayQueue = objectArrayPool.get(size);
        if (N.notNullOrEmpty(arrayQueue)) {
            objArray = arrayQueue.poll();
        }
        return objArray == null ? new Object[size] : objArray;
    }

    public static char[] createCharArrayBuffer() {
        return ObjectFactory.createCharArrayBuffer(8192);
    }

    public static char[] createCharArrayBuffer(int capacity) {
        if (capacity > 8192) {
            return new char[capacity];
        }
        char[] cbuf = charArrayBufferPool.poll();
        return cbuf == null ? new char[8192] : cbuf;
    }

    public static byte[] createByteArrayBuffer() {
        return ObjectFactory.createByteArrayBuffer(8192);
    }

    public static byte[] createByteArrayBuffer(int capacity) {
        if (capacity > 8192) {
            return new byte[capacity];
        }
        byte[] bbuf = byteArrayBufferPool.poll();
        return bbuf == null ? new byte[8192] : bbuf;
    }

    public static StringBuilder createStringBuilder() {
        return ObjectFactory.createStringBuilder(8192);
    }

    public static StringBuilder createStringBuilder(int initCapacity) {
        if (initCapacity > 8192) {
            return new StringBuilder(initCapacity);
        }
        StringBuilder sb = stringBuilderPool.poll();
        return sb == null ? new StringBuilder(8192) : sb;
    }

    public static ByteArrayOutputStream createByteArrayOutputStream() {
        return ObjectFactory.createByteArrayOutputStream(8192);
    }

    public static ByteArrayOutputStream createByteArrayOutputStream(int initCapacity) {
        if (initCapacity > 8192) {
            return new ByteArrayOutputStream(initCapacity);
        }
        ByteArrayOutputStream os = byteArrayOutputStreamPool.poll();
        return os == null ? new ByteArrayOutputStream(8192) : os;
    }

    public static BufferedWriter createBufferedWriter() {
        BufferedWriter bufWriter = bufferedWriterPool.poll();
        if (bufWriter == null) {
            bufWriter = new BufferedWriter(ObjectFactory.createStringBuilder());
        } else if (bufWriter.getStringBuilder() == null) {
            bufWriter.setStringBuilder(ObjectFactory.createStringBuilder());
        }
        bufWriter.setStringBuilderRecycable(true);
        return bufWriter;
    }

    public static BufferedWriter createBufferedWriter(StringBuilder sb) {
        BufferedWriter bufWriter = bufferedWriterPool.poll();
        if (bufWriter == null) {
            bufWriter = new BufferedWriter(sb);
        } else {
            if (bufWriter.isStringBuilderRecycable()) {
                ObjectFactory.recycle(bufWriter.getStringBuilder());
            }
            bufWriter.setStringBuilder(sb);
        }
        bufWriter.setStringBuilderRecycable(false);
        return bufWriter;
    }

    public static BufferedWriter createBufferedWriter(OutputStream os) {
        BufferedWriter bufWriter = bufferedWriterPool.poll();
        if (bufWriter == null) {
            bufWriter = new BufferedWriter(os);
        } else {
            if (bufWriter.isStringBuilderRecycable()) {
                ObjectFactory.recycle(bufWriter.getStringBuilder());
            }
            bufWriter.setWriter(os);
        }
        bufWriter.setStringBuilderRecycable(false);
        return bufWriter;
    }

    public static BufferedWriter createBufferedWriter(Writer writer) {
        if (writer instanceof BufferedWriter) {
            return (BufferedWriter)writer;
        }
        BufferedWriter bufWriter = bufferedWriterPool.poll();
        if (bufWriter == null) {
            bufWriter = new BufferedWriter(writer);
        } else {
            if (bufWriter.isStringBuilderRecycable()) {
                ObjectFactory.recycle(bufWriter.getStringBuilder());
            }
            bufWriter.setWriter(writer);
        }
        bufWriter.setStringBuilderRecycable(false);
        return bufWriter;
    }

    public static BufferedReader createBufferedReader(String st) {
        BufferedReader bufReader = bufferedReaderPool.poll();
        if (bufReader == null) {
            return new BufferedReader(st);
        }
        bufReader.setReader(new StringReader(st));
        return bufReader;
    }

    public static BufferedReader createBufferedReader(InputStream is) {
        BufferedReader bufReader = bufferedReaderPool.poll();
        if (bufReader == null) {
            return new BufferedReader(is);
        }
        bufReader.setReader(new InputStreamReader(is));
        return bufReader;
    }

    public static BufferedReader createBufferedReader(Reader reader) {
        if (reader instanceof BufferedReader) {
            return (BufferedReader)reader;
        }
        BufferedReader bufReader = bufferedReaderPool.poll();
        if (bufReader == null) {
            return new BufferedReader(reader);
        }
        bufReader.setReader(reader);
        return bufReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(List<?> list) {
        if (list == null || list.size() > 8192) {
            return;
        }
        Queue<List<?>> queue = listPool;
        synchronized (queue) {
            if (listPool.size() < 1024) {
                list.clear();
                listPool.add(list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(Set<?> set) {
        if (set == null || set.size() > 8192) {
            return;
        }
        Queue<Set<?>> queue = setPool;
        synchronized (queue) {
            if (setPool.size() < 1024) {
                set.clear();
                setPool.add(set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(Map<?, ?> map) {
        if (map == null || map.size() > 8192) {
            return;
        }
        if (map instanceof LinkedHashMap) {
            Queue<LinkedHashMap<?, ?>> queue = linkedHashMapPool;
            synchronized (queue) {
                if (linkedHashMapPool.size() < 1024) {
                    map.clear();
                    linkedHashMapPool.add((LinkedHashMap)map);
                }
            }
        }
        Queue<Map<?, ?>> queue = mapPool;
        synchronized (queue) {
            if (mapPool.size() < 1024) {
                map.clear();
                mapPool.add(map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(Object[] objArray) {
        if (objArray == null || objArray.length > 8192) {
            return;
        }
        Map<Integer, Queue<Object[]>> map = objectArrayPool;
        synchronized (map) {
            Queue<Object[]> arrayQueue = objectArrayPool.get(objArray.length);
            int poolSize = 320000 / objArray.length;
            if (arrayQueue == null) {
                arrayQueue = N.newArrayBlockingQueue(poolSize);
                objectArrayPool.put(objArray.length, arrayQueue);
            }
            if (arrayQueue.size() < poolSize) {
                Arrays.fill(objArray, null);
                arrayQueue.add(objArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(char[] cbuf) {
        if (cbuf == null || cbuf.length > 8192) {
            return;
        }
        Queue<char[]> queue = charArrayBufferPool;
        synchronized (queue) {
            if (charArrayBufferPool.size() < 1024) {
                charArrayBufferPool.add(cbuf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(byte[] bbuf) {
        if (bbuf == null || bbuf.length > 8192) {
            return;
        }
        Queue<byte[]> queue = byteArrayBufferPool;
        synchronized (queue) {
            if (byteArrayBufferPool.size() < 1024) {
                byteArrayBufferPool.add(bbuf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(StringBuilder sb) {
        if (sb == null || sb.capacity() > 8192) {
            return;
        }
        Queue<StringBuilder> queue = stringBuilderPool;
        synchronized (queue) {
            if (stringBuilderPool.size() < 1024) {
                sb.setLength(0);
                stringBuilderPool.add(sb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(ByteArrayOutputStream os) {
        if (os == null || os.size() > 8192) {
            return;
        }
        Queue<ByteArrayOutputStream> queue = byteArrayOutputStreamPool;
        synchronized (queue) {
            if (byteArrayOutputStreamPool.size() < 1024) {
                os.reset();
                byteArrayOutputStreamPool.add(os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(BufferedWriter writer) {
        if (writer == null) {
            return;
        }
        Queue<BufferedWriter> queue = bufferedWriterPool;
        synchronized (queue) {
            if (writer.isStringBuilderRecycable()) {
                ObjectFactory.recycle(writer.getStringBuilder());
            }
            writer._reset();
            if (bufferedWriterPool.size() < 1024) {
                bufferedWriterPool.add(writer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recycle(BufferedReader reader) {
        if (reader == null) {
            return;
        }
        Queue<BufferedWriter> queue = bufferedWriterPool;
        synchronized (queue) {
            reader._reset();
            if (bufferedReaderPool.size() < 1024) {
                bufferedReaderPool.add(reader);
            }
        }
    }
}

