/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.util;

import com.google.gson.util.BufferedWriter;
import com.google.gson.util.CalendarUnit;
import com.google.gson.util.ObjectFactory;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.rmi.server.UID;
import java.security.SecureRandom;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class N {
    static final Logger logger = Logger.getLogger(N.class.getCanonicalName());
    public static final String HOST_NAME;
    public static final String JAVA_HOME;
    public static final String JAVA_VERSION;
    public static final String USER_DIR;
    public static final String PATH_SEPARATOR;
    public static final String FILE_SEPARATOR;
    public static final String LINE_SEPARATOR;
    public static final Charset UTF_8;
    public static final Charset ASCII;
    public static final Charset ISO_8859_1;
    public static final String NULL_STRING = "null";
    public static final char[] NULL_CHAR_ARRAY;
    public static final String EMPTY_STRING = "";
    public static final String TRUE;
    public static final String FALSE;
    public static final char[] TRUE_CHAR_ARRAY;
    public static final char[] FALSE_CHAR_ARRAY;
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String IS = "is";
    public static final String HAS = "has";
    private static final int SMALL_POOL_SIZE = 1000;
    private static final int BIG_POOL_SIZE = 3000;
    private static final SecureRandom numberGenerator;
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String LOCAL_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final Map<String, Queue<SimpleDateFormat>> SDF_POOL;
    private static final Map<TimeZone, Queue<Calendar>> calendarPool;
    private static final Queue<Calendar> utcCalendarPool;
    private static final TimeZone UTC_TIME_ZONE;
    private static final TimeZone LOCAL_TIME_ZONE;
    private static final DatatypeFactory dataTypeFactory;
    private static final char[][][] cbufOfSTDInt;
    private static final Set<Class<?>> PRIMARY_TYPE;
    private static final Map<Class<?>, Object> DEFAULT_VALUE_FOR_PRIMARY_TYPE;
    private static final Map<Class<?>, Integer> CLASS_ENUM_ORDER;
    static final Set<Class<?>> abstractPropClass;
    private static final Map<Class<?>, Boolean> registeredXMLBindingClassList;
    private static final Map<Class<?>, Map<String, Method>> entityDeclaredPropGetMethodList;
    private static final Map<Class<?>, Map<String, Method>> entityDeclaredPropSetMethodList;
    private static final Map<Class<?>, Map<String, Method>> entityPropGetMethodPool;
    private static final Map<Class<?>, Map<String, Method>> entityPropSetMethodPool;
    private static final Map<Method, String> methodPropNamePool;
    private static final Map<Method, Class<?>[]> methodTypeArgumentsPool;
    public static final Method DUMMY_METHOD;
    public static final Class<?> DUMMY_CLASS;
    public static final Class<?>[] DUMMY_CLASSES;
    private static final Map<String, String> keyWords;
    private static final Map<String, String> formalizedPropNamePool;
    private static final Map<String, Class<?>> BUILT_IN_TYPE;
    private static Map<String, String> SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME;
    private static final Map<Class<?>, ClazzParserType> clsParserTypePool;
    private static final Map<String, Class<?>> clsNamePool;
    private static final Map<Class<?>, String> simpleNameClassPool;
    private static final Map<Class<?>, String> nameClassPool;
    private static final Map<Class<?>, String> canonicalNameClassPool;
    private static final Map<Class<?>, Class<?>> enclosingClassPool;
    private static final ExecutorService executorService;

    private N() {
    }

    public static Class<?> forClass(String clsName) {
        return N.forClass(clsName, true);
    }

    public static Class<?> forClass(String clsName, boolean cacheResult) {
        Class<?> cls = clsNamePool.get(clsName);
        if (cls == null) {
            block15: {
                cls = BUILT_IN_TYPE.get(clsName);
                if (cls == null) {
                    try {
                        cls = Class.forName(clsName);
                    }
                    catch (ClassNotFoundException e) {
                        String temp;
                        String componentTypeName;
                        int index;
                        String newClassName = clsName;
                        if (newClassName.indexOf(46) < 0 && ((index = newClassName.indexOf("[]")) < 0 && !SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.containsKey(newClassName) || index > 0 && !SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.containsKey(newClassName.substring(0, index)))) {
                            newClassName = "java.lang." + newClassName;
                            try {
                                cls = Class.forName(newClassName);
                                BUILT_IN_TYPE.put(clsName, cls);
                            }
                            catch (ClassNotFoundException e1) {
                                // empty catch block
                            }
                        }
                        if (cls != null || (index = newClassName.indexOf("[]")) <= 0 || !(componentTypeName = newClassName.substring(0, index)).equals(temp = newClassName.replaceAll("\\[\\]", EMPTY_STRING))) break block15;
                        String symbolOfPrimaryArraryClassName = SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.get(componentTypeName);
                        int dimensions = (newClassName.length() - temp.length()) / 2;
                        String prefixOfArray = EMPTY_STRING;
                        while (dimensions-- > 0) {
                            prefixOfArray = prefixOfArray + "[";
                        }
                        if (symbolOfPrimaryArraryClassName != null) {
                            try {
                                cls = Class.forName(prefixOfArray + symbolOfPrimaryArraryClassName);
                                BUILT_IN_TYPE.put(clsName, cls);
                            }
                            catch (ClassNotFoundException e2) {}
                        }
                        try {
                            cls = Class.forName(prefixOfArray + "L" + componentTypeName + ";");
                        }
                        catch (ClassNotFoundException e3) {
                            // empty catch block
                        }
                    }
                }
            }
            if (cls == null) {
                throw new RuntimeException("No class found by name: " + clsName);
            }
            if (cacheResult) {
                clsNamePool.put(clsName, cls);
            }
        }
        return cls;
    }

    public static String getClassName(Class<?> cls) {
        String clsName = nameClassPool.get(cls);
        if (clsName == null) {
            clsName = cls.getName();
            nameClassPool.put(cls, clsName);
        }
        return clsName;
    }

    public static String getClassSimpleName(Class<?> cls) {
        String clsName = simpleNameClassPool.get(cls);
        if (clsName == null) {
            clsName = cls.getSimpleName();
            simpleNameClassPool.put(cls, clsName);
        }
        return clsName;
    }

    public static String getClassCanonicalName(Class<?> cls) {
        String clsName = canonicalNameClassPool.get(cls);
        if (clsName == null) {
            clsName = cls.getCanonicalName();
            canonicalNameClassPool.put(cls, clsName);
        }
        return clsName;
    }

    public static Class<?> getEnclosingClass(Class<?> cls) {
        Class<?> enclosingClass = enclosingClassPool.get(cls);
        if (enclosingClass == null) {
            enclosingClass = cls.getEnclosingClass();
            if (enclosingClass == null) {
                enclosingClass = DUMMY_CLASS;
            }
            enclosingClassPool.put(cls, enclosingClass);
        }
        return enclosingClass == DUMMY_CLASS ? null : enclosingClass;
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> cls, Class<?> ... parameterType) {
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(parameterType);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getDeclaredMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = cls.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method == null) {
            Method[] methods;
            for (Method m : methods = cls.getDeclaredMethods()) {
                if (!m.getName().equalsIgnoreCase(methodName) || !N.equals(parameterTypes, m.getParameterTypes())) continue;
                method = m;
                break;
            }
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static Method findMethodByName(Class<?> cls, String methodName) {
        Method[] methods;
        Method method = null;
        for (Method m : methods = cls.getDeclaredMethods()) {
            if (!m.getName().equalsIgnoreCase(methodName)) continue;
            if (method == null || Modifier.isPublic(m.getModifiers()) || Modifier.isProtected(m.getModifiers()) && Modifier.isPrivate(method.getModifiers())) {
                method = m;
            }
            if (Modifier.isPublic(method.getModifiers())) break;
        }
        if (method != null) {
            method.setAccessible(true);
        }
        return method;
    }

    public static <T> T invokeConstructor(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T invokeMethod(Object instance, Method method, Object ... args) {
        try {
            return (T)method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPropNameByMethod(Method getSetMethod) {
        String propName = methodPropNamePool.get(getSetMethod);
        if (propName == null) {
            String methodName = getSetMethod.getName();
            propName = N.formalizePropName(methodName.startsWith(IS) ? methodName.substring(2) : methodName.substring(3));
            methodPropNamePool.put(getSetMethod, propName);
        }
        return propName;
    }

    public static String formalizePropName(String propName) {
        String newPropName = formalizedPropNamePool.get(propName);
        if (newPropName == null) {
            newPropName = propName;
            for (int i = 0; i < newPropName.length(); ++i) {
                if (Character.isLowerCase(newPropName.charAt(i))) {
                    if (i == 1) {
                        newPropName = N.lowCaseFirstChar(newPropName);
                        break;
                    }
                    if (i <= 1) break;
                    newPropName = newPropName.substring(0, i - 1).toLowerCase() + newPropName.substring(i - 1);
                    break;
                }
                if (i + 1 != newPropName.length()) continue;
                newPropName = newPropName.toLowerCase();
            }
            for (String keyWord : keyWords.keySet()) {
                if (!keyWord.equalsIgnoreCase(newPropName)) continue;
                newPropName = keyWords.get(keyWord);
                break;
            }
            formalizedPropNamePool.put(propName, newPropName);
        }
        return newPropName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerXMLBindingClassForPropGetSetMethod(Class<?> cls) {
        if (registeredXMLBindingClassList.containsKey(cls)) {
            return;
        }
        Map<Class<?>, Map<String, Method>> map = entityDeclaredPropGetMethodList;
        synchronized (map) {
            registeredXMLBindingClassList.put(cls, false);
            if (entityDeclaredPropGetMethodList.containsKey(cls)) {
                entityDeclaredPropGetMethodList.remove(cls);
                entityDeclaredPropSetMethodList.remove(cls);
                N.loadPropGetSetMethodList(cls);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPropGetSetMethod(String propName, Method method) {
        Map<Class<?>, Map<String, Method>> map = entityDeclaredPropGetMethodList;
        synchronized (map) {
            Class<?> cls = method.getDeclaringClass();
            if (N.isGetMethod(cls, method)) {
                Map<String, Method> propMethodMap = entityPropGetMethodPool.get(cls);
                if (propMethodMap == null) {
                    N.loadPropGetSetMethodList(cls);
                    propMethodMap = entityPropGetMethodPool.get(cls);
                }
                if (propMethodMap.containsKey(propName)) {
                    return;
                }
                propMethodMap.put(propName, method);
            } else if (method.getName().startsWith(SET)) {
                Map<String, Method> propMethodMap = entityPropSetMethodPool.get(cls);
                if (propMethodMap == null) {
                    N.loadPropGetSetMethodList(cls);
                    propMethodMap = entityPropSetMethodPool.get(cls);
                }
                if (propMethodMap.containsKey(propName)) {
                    return;
                }
                if (method.getParameterTypes().length != 1) {
                    throw new RuntimeException("Invalid set method: " + method.getName());
                }
                propMethodMap.put(propName, method);
            } else {
                throw new RuntimeException("The name of property getter/setter method must start with 'get' or 'set': " + method.getName());
            }
        }
    }

    public static Map<String, Method> getPropGetMethodList(Class<?> cls) {
        Map<String, Method> getterMethodList = entityDeclaredPropGetMethodList.get(cls);
        if (getterMethodList == null) {
            N.loadPropGetSetMethodList(cls);
            getterMethodList = entityDeclaredPropGetMethodList.get(cls);
        }
        return getterMethodList;
    }

    public static Map<String, Method> getPropSetMethodList(Class<?> cls) {
        Map<String, Method> setterMethodList = entityDeclaredPropSetMethodList.get(cls);
        if (setterMethodList == null) {
            N.loadPropGetSetMethodList(cls);
            setterMethodList = entityDeclaredPropSetMethodList.get(cls);
        }
        return setterMethodList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getPropGetMethod(Class<?> cls, String propName) {
        Method method;
        Map<String, Method> propGetMethodMap = entityPropGetMethodPool.get(cls);
        if (propGetMethodMap == null) {
            N.loadPropGetSetMethodList(cls);
            propGetMethodMap = entityPropGetMethodPool.get(cls);
        }
        if ((method = propGetMethodMap.get(propName)) == null) {
            Map<Class<?>, Map<String, Method>> map = entityDeclaredPropGetMethodList;
            synchronized (map) {
                Map<String, Method> declaredpropGetMethodMap = N.getPropGetMethodList(cls);
                for (String key : declaredpropGetMethodMap.keySet()) {
                    if (!N.isPropName(cls, propName, key)) continue;
                    method = declaredpropGetMethodMap.get(key);
                    break;
                }
                if (method == null && !propName.equalsIgnoreCase(N.formalizePropName(propName))) {
                    method = N.getPropGetMethod(cls, N.formalizePropName(propName));
                }
                if (method == null) {
                    method = DUMMY_METHOD;
                }
                propGetMethodMap.put(propName, method);
            }
        }
        return method == DUMMY_METHOD ? null : method;
    }

    private static boolean isPropName(Class<?> cls, String inputPropName, String propName) {
        return inputPropName.equalsIgnoreCase(propName) || inputPropName.replace("_", EMPTY_STRING).equalsIgnoreCase(propName) || inputPropName.equalsIgnoreCase(N.getClassSimpleName(cls) + '.' + propName.toLowerCase()) || inputPropName.equalsIgnoreCase(N.getClassSimpleName(cls) + ':' + propName.toLowerCase()) || inputPropName.startsWith(GET) && inputPropName.substring(3).equalsIgnoreCase(propName) || inputPropName.startsWith(SET) && inputPropName.substring(3).equalsIgnoreCase(propName) || inputPropName.startsWith(IS) && inputPropName.substring(2).equalsIgnoreCase(propName) || inputPropName.startsWith(HAS) && inputPropName.substring(2).equalsIgnoreCase(propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Method getPropSetMethod(Class<?> cls, String propName) {
        Method method;
        Map<String, Method> propSetMethodMap = entityPropSetMethodPool.get(cls);
        if (propSetMethodMap == null) {
            N.loadPropGetSetMethodList(cls);
            propSetMethodMap = entityPropSetMethodPool.get(cls);
        }
        if ((method = propSetMethodMap.get(propName)) == null) {
            Map<Class<?>, Map<String, Method>> map = entityDeclaredPropGetMethodList;
            synchronized (map) {
                Map<String, Method> declaredpropSetMethodMap = N.getPropSetMethodList(cls);
                for (String key : declaredpropSetMethodMap.keySet()) {
                    if (!N.isPropName(cls, propName, key)) continue;
                    method = propSetMethodMap.get(key);
                    break;
                }
                if (method == null && !propName.equalsIgnoreCase(N.formalizePropName(propName))) {
                    method = N.getPropSetMethod(cls, N.formalizePropName(propName));
                }
                if (method == null) {
                    method = DUMMY_METHOD;
                }
                propSetMethodMap.put(propName, method);
            }
        }
        return method == DUMMY_METHOD ? null : method;
    }

    public static Object setPropValue(Object entity, Method propSetMethod, Object propValue) {
        try {
            propSetMethod.invoke(entity, propValue);
        }
        catch (Exception e) {
            Class<?> propClass = propSetMethod.getParameterTypes()[0];
            if (propValue == null) {
                propValue = N.getDefaultValue(propClass);
            }
            try {
                propSetMethod.invoke(entity, propValue);
            }
            catch (Exception e1) {
                throw new RuntimeException("Failed to set property value by method '" + propSetMethod.getName() + "'", e);
            }
        }
        return propValue;
    }

    public static Object setPropValueByGet(Object entity, Method propGetMethod, Object propValue) {
        Object rt = N.invokeMethod(entity, propGetMethod, new Object[0]);
        if (propValue == null) {
            return rt;
        }
        if (rt instanceof Collection) {
            Collection c = (Collection)rt;
            c.addAll((Collection)propValue);
        } else if (rt instanceof Map) {
            Map m = (Map)rt;
            m.putAll((Map)propValue);
        } else {
            throw new RuntimeException("Failed to set property value by method '" + propGetMethod.getName() + "'");
        }
        return rt;
    }

    public static <T> T getPropValue(Object entity, Method propGetMethod) {
        try {
            return (T)propGetMethod.invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object setPropValue(Object entity, String propName, Object propValue) {
        Method propSetMethod = N.getPropSetMethod(entity.getClass(), propName);
        if (propSetMethod == null) {
            Method propGetMethod = N.getPropGetMethod(entity.getClass(), propName);
            if (propGetMethod == null) {
                throw new IllegalArgumentException("no setter method found in target class(" + N.getClassCanonicalName(entity.getClass()) + ") for property: " + propName);
            }
            return N.setPropValueByGet(entity, propGetMethod, propValue);
        }
        return N.setPropValue(entity, propSetMethod, propValue);
    }

    public static <T> T getPropValue(Object entity, String propName) {
        return N.getPropValue(entity, N.getPropGetMethod(entity.getClass(), propName));
    }

    public static <T> T getDefaultValue(Class<T> cls) {
        return (T)DEFAULT_VALUE_FOR_PRIMARY_TYPE.get(cls);
    }

    public static boolean isDigit(String st) {
        try {
            Double.valueOf(st);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    public static boolean isNullOrEmpty(Map<?, ?> m) {
        return m == null || m.size() == 0;
    }

    public static boolean isNullOrEmpty(boolean[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(char[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(byte[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(short[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(int[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(long[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(float[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(double[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(Object[] a) {
        return a == null || a.length == 0;
    }

    public static boolean isNullOrEmpty(NodeList nodeList) {
        return nodeList == null || nodeList.getLength() == 0;
    }

    public static boolean notNullOrEmpty(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean notNullOrEmpty(Collection<?> c) {
        return c != null && c.size() > 0;
    }

    public static boolean notNullOrEmpty(Map<?, ?> m) {
        return m != null && m.size() > 0;
    }

    public static boolean notNullOrEmpty(boolean[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(char[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(byte[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(short[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(int[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(long[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(float[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(double[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(Object[] a) {
        return a != null && a.length > 0;
    }

    public static boolean notNullOrEmpty(NodeList nodeList) {
        return nodeList != null && nodeList.getLength() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadPropGetSetMethodList(Class<?> cls) {
        Map<Class<?>, Map<String, Method>> map = entityDeclaredPropGetMethodList;
        synchronized (map) {
            if (entityDeclaredPropGetMethodList.containsKey(cls)) {
                return;
            }
            Object instance = null;
            if (registeredXMLBindingClassList.containsKey(cls)) {
                try {
                    instance = cls.newInstance();
                }
                catch (Exception e) {
                    logger.warning("Failed to new instance of class: " + cls.getCanonicalName() + " to check setter method by getter method");
                }
                registeredXMLBindingClassList.put(cls, true);
            }
            LinkedHashMap<String, AccessibleObject> propGetMethodMap = N.asLinkedHashMap(new Object[0]);
            LinkedHashMap<String, Method> propSetMethodMap = N.asLinkedHashMap(new Object[0]);
            List<Object> allClasses = N.asList(new Object[0]);
            allClasses.add(cls);
            while (((Class)allClasses.get(allClasses.size() - 1)).getSuperclass() != null) {
                allClasses.add(((Class)allClasses.get(allClasses.size() - 1)).getSuperclass());
            }
            Class clazz = null;
            Method setMethod = null;
            block6: for (int i = allClasses.size() - 1; i >= 0; --i) {
                clazz = (Class)allClasses.get(i);
                if (Date.class.isAssignableFrom(clazz) || Calendar.class.equals((Object)clazz)) continue;
                Map<String, String> statisFinalFields = N.getPublicStaticStringFields(clazz);
                String propName = null;
                String fieldName = null;
                block7: for (Field field : clazz.getDeclaredFields()) {
                    fieldName = field.getName();
                    for (Method method : clazz.getMethods()) {
                        if (!N.isFieldGetMethod(clazz, method, fieldName)) continue;
                        propName = N.getPropNameByMethod(method);
                        String string = propName = statisFinalFields.get(propName) != null ? statisFinalFields.get(propName) : propName;
                        if (propGetMethodMap.containsKey(propName)) continue block7;
                        setMethod = N.getSetMethod(clazz, propName, method);
                        if (setMethod != null) {
                            propGetMethodMap.put(propName, method);
                            propSetMethodMap.put(propName, setMethod);
                            continue block7;
                        }
                        if (!N.isJAXBGetMethod(instance, method)) continue;
                        propGetMethodMap.put(propName, method);
                        continue block7;
                    }
                }
                for (AccessibleObject accessibleObject : clazz.getMethods()) {
                    if (!N.isGetMethod(clazz, (Method)accessibleObject)) continue;
                    propName = N.getPropNameByMethod((Method)accessibleObject);
                    String string = propName = statisFinalFields.get(propName) != null ? statisFinalFields.get(propName) : propName;
                    if (propGetMethodMap.containsKey(propName)) continue block6;
                    setMethod = N.getSetMethod(clazz, propName, (Method)accessibleObject);
                    if (setMethod != null) {
                        propGetMethodMap.put(propName, accessibleObject);
                        propSetMethodMap.put(propName, setMethod);
                        continue block6;
                    }
                    if (!N.isJAXBGetMethod(instance, (Method)accessibleObject)) continue;
                    propGetMethodMap.put(propName, accessibleObject);
                    continue block6;
                }
            }
            Map temp = Collections.unmodifiableMap(propGetMethodMap);
            temp.keySet();
            entityDeclaredPropGetMethodList.put(cls, temp);
            if (entityPropGetMethodPool.get(cls) == null) {
                entityPropGetMethodPool.put(cls, N.asConcurrentHashMap(propGetMethodMap));
            } else {
                entityPropGetMethodPool.get(cls).putAll(propGetMethodMap);
            }
            temp = Collections.unmodifiableMap(propSetMethodMap);
            temp.keySet();
            entityDeclaredPropSetMethodList.put(cls, temp);
            if (entityPropSetMethodPool.get(cls) == null) {
                entityPropSetMethodPool.put(cls, N.asConcurrentHashMap(propSetMethodMap));
            } else {
                entityPropSetMethodPool.get(cls).putAll(propSetMethodMap);
            }
        }
    }

    private static boolean isGetMethod(Class<?> clazz, Method method) {
        return (method.getName().startsWith(GET) || method.getName().startsWith(IS) || method.getName().startsWith(HAS)) && method.getParameterTypes().length == 0 && !Void.TYPE.equals(method.getReturnType());
    }

    private static boolean isFieldGetMethod(Class<?> clazz, Method method, String fieldName) {
        return N.isGetMethod(clazz, method) && (method.getName().equalsIgnoreCase(GET + fieldName) || method.getName().equalsIgnoreCase(IS + fieldName) || method.getName().equalsIgnoreCase(HAS + fieldName));
    }

    private static boolean isJAXBGetMethod(Object instance, Method method) {
        try {
            return instance != null && (Collection.class.isAssignableFrom(method.getReturnType()) || Map.class.isAssignableFrom(method.getReturnType())) && N.invokeMethod(instance, method, new Object[0]) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Method getSetMethod(Class<?> clazz, String propName, Method getMethod) {
        Method setMethod = N.getDeclaredMethod(clazz, SET + propName, getMethod.getReturnType());
        return setMethod == null || !Void.TYPE.equals(setMethod.getReturnType()) ? null : setMethod;
    }

    private static <T> Map<String, String> getPublicStaticStringFields(Class<T> cls) {
        Map<String, String> statisFinalFields = N.asMap(new Object[0]);
        for (Field field : cls.getFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !String.class.equals(field.getType())) continue;
            try {
                String value = (String)field.get(null);
                statisFinalFields.put(value, value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return statisFinalFields;
    }

    public static void erase(Object entity) {
        if (entity == null) {
            return;
        }
        Class<?> cls = entity.getClass();
        Map<String, Method> setterMethodList = N.getPropSetMethodList(cls);
        if (setterMethodList.size() == 0) {
            throw new IllegalArgumentException("no property getXXX/setXXX method found in the specified entity: " + N.getClassCanonicalName(cls));
        }
        for (Method propSetMethod : setterMethodList.values()) {
            N.setPropValue(entity, propSetMethod, null);
        }
    }

    public static void merge(Object sourceEntity, Object targetEntity) {
        Class<?> sourceEntityClass = sourceEntity.getClass();
        Class<?> targetEntityClass = targetEntity.getClass();
        Map<String, Method> getterMethodList = N.getPropGetMethodList(sourceEntityClass);
        if (getterMethodList.size() == 0) {
            throw new IllegalArgumentException("no property getXXX/setXXX method found in the specified entity: " + sourceEntityClass.getCanonicalName());
        }
        Method propSetMethod = null;
        Method propGetMethod = null;
        String propName = null;
        Object propValue = null;
        try {
            for (Method srcPropGetMethod : getterMethodList.values()) {
                propName = N.getPropNameByMethod(srcPropGetMethod);
                propValue = srcPropGetMethod.invoke(sourceEntity, new Object[0]);
                propSetMethod = N.getPropSetMethod(targetEntityClass, propName);
                if (propSetMethod == null) {
                    propGetMethod = N.getPropGetMethod(targetEntityClass, propName);
                    if (propGetMethod == null) {
                        throw new IllegalArgumentException("no setter method found in target class(" + N.getClassCanonicalName(targetEntityClass) + ") for property: " + propName);
                    }
                    if (propValue == null) continue;
                    N.setPropValueByGet(targetEntity, propGetMethod, propValue);
                    continue;
                }
                if (propValue == null) continue;
                N.setPropValue(targetEntity, propSetMethod, propValue);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T copy(T entity) {
        return (T)N.copy(entity.getClass(), entity);
    }

    public static <T> T copy(Class<T> cls, Object entity) {
        Class<?> srcCls = entity.getClass();
        T copy = N.newInstance(cls);
        Map<String, Method> srcGetterMethodList = N.getPropGetMethodList(srcCls);
        if (srcGetterMethodList.size() == 0) {
            throw new IllegalArgumentException("no property getXXX/setXXX method found in the specified entity: " + entity.getClass().getCanonicalName());
        }
        try {
            Method propGetMethod = null;
            Method propSetMethod = null;
            String propName = null;
            for (Method srcPropGetMethod : srcGetterMethodList.values()) {
                propName = N.getPropNameByMethod(srcPropGetMethod);
                propSetMethod = N.getPropSetMethod(cls, propName);
                if (propSetMethod == null) {
                    propGetMethod = N.getPropGetMethod(cls, propName);
                    if (propGetMethod == null) {
                        throw new IllegalArgumentException("no setter method found in target class(" + N.getClassCanonicalName(cls) + ") for property: " + propName);
                    }
                    N.setPropValueByGet(copy, propGetMethod, srcPropGetMethod.invoke(entity, new Object[0]));
                    continue;
                }
                N.setPropValue(copy, propSetMethod, srcPropGetMethod.invoke(entity, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return copy;
    }

    public static <T> T map2Entity(Class<T> cls, Map<String, Object> m) {
        return N.map2Entity(cls, m, true, true);
    }

    public static <T> T map2Entity(Class<T> cls, Map<String, Object> m, boolean ignoreUnknownProperty, boolean ignoreNullProperty) {
        N.checkEntityClass(cls);
        T entity = N.newInstance(cls);
        Method propGetMethod = null;
        Method propSetMethod = null;
        Object propValue = null;
        for (String propName : m.keySet()) {
            propValue = m.get(propName);
            propSetMethod = N.getPropSetMethod(cls, propName);
            if (propSetMethod == null) {
                propGetMethod = N.getPropGetMethod(cls, propName);
            }
            if (propSetMethod == null && propGetMethod == null) {
                if (ignoreUnknownProperty) continue;
                throw new RuntimeException("unknown proprety: " + propName);
            }
            if (propValue == null && ignoreNullProperty) continue;
            if (propSetMethod == null) {
                propGetMethod = N.getPropGetMethod(cls, propName);
                if (propGetMethod == null) continue;
                N.setPropValueByGet(entity, propGetMethod, propValue);
                continue;
            }
            if (propValue != null && N.getClazzParserType(propValue.getClass()) == ClazzParserType.MAP && N.getClazzParserType(propSetMethod.getParameterTypes()[0]) != ClazzParserType.MAP) {
                N.setPropValue(entity, propSetMethod, N.map2Entity(propSetMethod.getParameterTypes()[0], (Map)propValue, ignoreUnknownProperty, ignoreNullProperty));
                continue;
            }
            N.setPropValue(entity, propSetMethod, propValue);
        }
        return entity;
    }

    public static <T> List<T> map2Entity(Class<T> cls, List<Map<String, Object>> mList) {
        return N.map2Entity(cls, mList, true, true);
    }

    public static <T> List<T> map2Entity(Class<T> cls, List<Map<String, Object>> mList, boolean ignoreUnknownProperty, boolean igoreNullProperty) {
        N.checkEntityClass(cls);
        ArrayList<T> entityList = N.newArrayList(mList.size());
        for (Map<String, Object> m : mList) {
            entityList.add(N.map2Entity(cls, m, ignoreUnknownProperty, igoreNullProperty));
        }
        return entityList;
    }

    public static Map<String, Object> entity2Map(Object entity) {
        return N.entity2Map(entity, true);
    }

    public static Map<String, Object> entity2Map(Object entity, boolean ignoreNullProperty) {
        Map<String, Object> resultMap = N.asMap(new Object[0]);
        N.entity2Map(entity, resultMap, ignoreNullProperty);
        return resultMap;
    }

    public static void entity2Map(Object entity, Map<String, Object> resultMap) {
        N.entity2Map(entity, resultMap, true);
    }

    public static void entity2Map(Object entity, Map<String, Object> resultMap, boolean ignoreNullProperty) {
        Map<String, Method> getterMethodList = N.getPropGetMethodList(entity.getClass());
        if (getterMethodList.size() == 0) {
            throw new IllegalArgumentException("no property getXXX/setXXX method found in the specified entity: " + entity.getClass().getCanonicalName());
        }
        try {
            Method propGetMethod = null;
            Object propValue = null;
            for (String propName : getterMethodList.keySet()) {
                propGetMethod = getterMethodList.get(propName);
                propValue = propGetMethod.invoke(entity, new Object[0]);
                if (propValue == null && ignoreNullProperty) continue;
                resultMap.put(N.getPropNameByMethod(propGetMethod), propValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map<String, Object>> entity2Map(List<?> entityList) {
        return N.entity2Map(entityList, true);
    }

    public static List<Map<String, Object>> entity2Map(List<?> entityList, boolean ignoreNullProperty) {
        ArrayList<Map<String, Object>> mList = N.newArrayList(entityList.size());
        for (Object entity : entityList) {
            mList.add(N.entity2Map(entity, ignoreNullProperty));
        }
        return mList;
    }

    public static Map<String, Object> deepEntity2Map(Object entity) {
        return N.deepEntity2Map(entity, true);
    }

    public static Map<String, Object> deepEntity2Map(Object entity, boolean ignoreNullProperty) {
        Map<String, Object> resultMap = N.asMap(new Object[0]);
        N.deepEntity2Map(entity, resultMap, ignoreNullProperty);
        return resultMap;
    }

    public static void deepEntity2Map(Object entity, Map<String, Object> resultMap) {
        N.deepEntity2Map(entity, resultMap, true);
    }

    public static void deepEntity2Map(Object entity, Map<String, Object> resultMap, boolean ignoreNullProperty) {
        Map<String, Method> getterMethodList = N.getPropGetMethodList(entity.getClass());
        if (getterMethodList.size() == 0) {
            throw new IllegalArgumentException("no property getXXX/setXXX method found in the specified entity: " + entity.getClass().getCanonicalName());
        }
        try {
            Method propGetMethod = null;
            Object propValue = null;
            for (String propName : getterMethodList.keySet()) {
                propGetMethod = getterMethodList.get(propName);
                propValue = propGetMethod.invoke(entity, new Object[0]);
                if (propValue == null && ignoreNullProperty) continue;
                if (propValue == null || N.getPropGetMethodList(propValue.getClass()).size() == 0) {
                    resultMap.put(propName, propValue);
                    continue;
                }
                resultMap.put(propName, N.deepEntity2Map(propValue, ignoreNullProperty));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map<String, Object>> deepEntity2Map(List<?> entityList) {
        return N.deepEntity2Map(entityList, true);
    }

    public static List<Map<String, Object>> deepEntity2Map(List<?> entityList, boolean ignoreNullProperty) {
        ArrayList<Map<String, Object>> mList = N.newArrayList(entityList.size());
        for (Object entity : entityList) {
            mList.add(N.deepEntity2Map(entity, ignoreNullProperty));
        }
        return mList;
    }

    public static Map<String, Object> entity2FlatMap(Object entity) {
        return N.entity2FlatMap(entity, true);
    }

    public static Map<String, Object> entity2FlatMap(Object entity, boolean ignoreNullProperty) {
        Map<String, Object> resultMap = N.asMap(new Object[0]);
        N.entity2FlatMap(entity, resultMap, ignoreNullProperty);
        return resultMap;
    }

    public static void entity2FlatMap(Object entity, Map<String, Object> resultMap) {
        N.entity2Map(entity, resultMap, true);
    }

    public static void entity2FlatMap(Object entity, Map<String, Object> resultMap, boolean ignoreNullProperty) {
        Map<String, Method> getterMethodList = N.getPropGetMethodList(entity.getClass());
        if (getterMethodList.size() == 0) {
            throw new IllegalArgumentException("no property getXXX/setXXX method found in the specified entity: " + entity.getClass().getCanonicalName());
        }
        try {
            Method propGetMethod = null;
            Object propValue = null;
            for (String propName : getterMethodList.keySet()) {
                propGetMethod = getterMethodList.get(propName);
                propValue = propGetMethod.invoke(entity, new Object[0]);
                N.prop2FlatMap(propName, propValue, resultMap, ignoreNullProperty);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Map<String, Object>> entity2FlatMap(List<?> entityList) {
        return N.entity2FlatMap(entityList, true);
    }

    public static List<Map<String, Object>> entity2FlatMap(List<?> entityList, boolean ignoreNullProperty) {
        ArrayList<Map<String, Object>> mList = N.newArrayList(entityList.size());
        for (Object entity : entityList) {
            mList.add(N.entity2FlatMap(entity, ignoreNullProperty));
        }
        return mList;
    }

    private static void prop2FlatMap(String propName, Object propValue, Map<String, Object> resultMap, boolean ignoreNullProperty) {
        if (propValue == null) {
            if (!ignoreNullProperty) {
                resultMap.put(propName, propValue);
            }
            return;
        }
        Class<?> cls = propValue.getClass();
        ClazzParserType clsParserType = N.getClazzParserType(cls);
        switch (clsParserType) {
            case SINGLE_VALUE: {
                resultMap.put(propName, propValue);
                break;
            }
            case ARRAY: {
                Object[] a = (Object[])propValue;
                for (int i = 0; i < a.length; ++i) {
                    N.prop2FlatMap(propName + "[" + i + "]", a[i], resultMap, ignoreNullProperty);
                }
                break;
            }
            case COLLECTION: {
                Collection c = (Collection)propValue;
                int i = 0;
                for (Object e : c) {
                    N.prop2FlatMap(propName + "[" + i++ + "]", e, resultMap, ignoreNullProperty);
                }
                break;
            }
            case MAP: {
                Map map = (Map)propValue;
                for (Object k : map.keySet()) {
                    N.prop2FlatMap(propName + "." + N.toString(k), map.get(k), resultMap, ignoreNullProperty);
                }
                break;
            }
            case ENTITY: {
                Map<String, Method> getterMethodList = N.getPropGetMethodList(cls);
                try {
                    Method propGetMethod = null;
                    Object subPropValue = null;
                    for (String subPropName : getterMethodList.keySet()) {
                        propGetMethod = getterMethodList.get(subPropName);
                        subPropValue = propGetMethod.invoke(propValue, new Object[0]);
                        N.prop2FlatMap(propName + "." + subPropName, subPropValue, resultMap, ignoreNullProperty);
                    }
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                resultMap.put(propName, propValue);
            }
        }
    }

    public static boolean[] copy(boolean[] a, int from, int to) {
        return Arrays.copyOfRange(a, from, to);
    }

    public static char[] copy(char[] a, int from, int to) {
        return Arrays.copyOfRange(a, from, to);
    }

    public static byte[] copy(byte[] a, int from, int to) {
        return Arrays.copyOfRange(a, from, to);
    }

    public static short[] copy(short[] a, int from, int to) {
        return Arrays.copyOfRange(a, from, to);
    }

    public static int[] copy(int[] a, int from, int to) {
        return Arrays.copyOfRange(a, from, to);
    }

    public static long[] copy(long[] a, int from, int to) {
        return Arrays.copyOfRange(a, from, to);
    }

    public static float[] copy(float[] a, int from, int to) {
        return Arrays.copyOfRange(a, from, to);
    }

    public static double[] copy(double[] a, int from, int to) {
        return Arrays.copyOfRange(a, from, to);
    }

    public static <T> T[] copy(T[] a, int from, int to) {
        return Arrays.copyOfRange(a, from, to);
    }

    public static <T> T[] copy(T[] src, int srcPos, T[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static boolean[] combine(boolean[] a, boolean[] b) {
        boolean[] c = new boolean[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static char[] combine(char[] a, char[] b) {
        char[] c = new char[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static byte[] combine(byte[] a, byte[] b) {
        byte[] c = new byte[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static short[] combine(short[] a, short[] b) {
        short[] c = new short[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static int[] combine(int[] a, int[] b) {
        int[] c = new int[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static long[] combine(long[] a, long[] b) {
        long[] c = new long[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static float[] combine(float[] a, float[] b) {
        float[] c = new float[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static double[] combine(double[] a, double[] b) {
        double[] c = new double[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static <T> T[] combine(T[] a, T[] b) {
        Object[] c = (Object[])N.newArray(a.getClass().getComponentType(), a.length + b.length);
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static <T extends Comparable<T>> void sort(T[] a) {
        Arrays.sort(a);
    }

    public static <T> void sort(T[] a, Comparator<? super T> c) {
        Arrays.sort(a, c);
    }

    public static <T extends Comparable<T>> void sort(List<T> list) {
        Collections.sort(list);
    }

    public static <T> void sort(List<T> list, Comparator<? super T> c) {
        Collections.sort(list, c);
    }

    public static int indexOf(boolean e, boolean[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(char e, char[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(byte e, byte[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(short e, short[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int e, int[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(long e, long[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != e) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float e, float[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (Float.compare(a[i], e) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double e, double[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (Double.compare(a[i], e) != 0) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object e, Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (!N.equals(a[i], e)) continue;
            return i;
        }
        return -1;
    }

    public static boolean equals(boolean a, boolean b) {
        return a == b;
    }

    public static boolean equals(char a, char b) {
        return a == b;
    }

    public static boolean equals(byte a, byte b) {
        return a == b;
    }

    public static boolean equals(short a, short b) {
        return a == b;
    }

    public static boolean equals(int a, int b) {
        return a == b;
    }

    public static boolean equals(long a, long b) {
        return a == b;
    }

    public static boolean equals(float a, float b) {
        return Float.compare(a, b) == 0;
    }

    public static boolean equals(double a, double b) {
        return Double.compare(a, b) == 0;
    }

    public static boolean equals(String a, String b) {
        return a == null && b == null || a != null && a.equals(b);
    }

    public static boolean equals(Object a, Object b) {
        if (a != null && b != null && a.getClass().isArray() && a.getClass().equals(b.getClass())) {
            int order = N.getClazzEnumOrder(a.getClass());
            switch (order) {
                case 1: {
                    return N.equals((boolean[])a, (boolean[])b);
                }
                case 2: {
                    return N.equals((char[])a, (char[])b);
                }
                case 3: {
                    return N.equals((byte[])a, (byte[])b);
                }
                case 4: {
                    return N.equals((short[])a, (short[])b);
                }
                case 5: {
                    return N.equals((int[])a, (int[])b);
                }
                case 6: {
                    return N.equals((long[])a, (long[])b);
                }
                case 7: {
                    return N.equals((float[])a, (float[])b);
                }
                case 8: {
                    return N.equals((double[])a, (double[])b);
                }
            }
            return N.equals((Object[])a, (Object[])b);
        }
        return a == null ? b == null : a.equals(b);
    }

    public static boolean deepEquals(Object a, Object b) {
        if (a != null && b != null && a.getClass().isArray() && a.getClass().equals(b.getClass())) {
            int order = N.getClazzEnumOrder(a.getClass());
            switch (order) {
                case 1: {
                    return N.equals((boolean[])a, (boolean[])b);
                }
                case 2: {
                    return N.equals((char[])a, (char[])b);
                }
                case 3: {
                    return N.equals((byte[])a, (byte[])b);
                }
                case 4: {
                    return N.equals((short[])a, (short[])b);
                }
                case 5: {
                    return N.equals((int[])a, (int[])b);
                }
                case 6: {
                    return N.equals((long[])a, (long[])b);
                }
                case 7: {
                    return N.equals((float[])a, (float[])b);
                }
                case 8: {
                    return N.equals((double[])a, (double[])b);
                }
            }
            return N.deepEquals((Object[])a, (Object[])b);
        }
        return a == null ? b == null : a.equals(b);
    }

    public static boolean equals(boolean[] a, boolean[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equals(char[] a, char[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equals(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equals(short[] a, short[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equals(int[] a, int[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equals(long[] a, long[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equals(float[] a, float[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equals(double[] a, double[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean equals(Object[] a, Object[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean deepEquals(Object[] a, Object[] b) {
        return Arrays.deepEquals(a, b);
    }

    public static int hashCode(boolean value) {
        return value ? 1231 : 1237;
    }

    public static int hashCode(char value) {
        return value;
    }

    public static int hashCode(byte value) {
        return value;
    }

    public static int hashCode(short value) {
        return value;
    }

    public static int hashCode(int value) {
        return value;
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public static int hashCode(float value) {
        return Float.floatToIntBits(value);
    }

    public static int hashCode(double value) {
        long bits = Double.doubleToLongBits(value);
        return (int)(bits ^ bits >>> 32);
    }

    public static int hashCode(Object value) {
        if (value == null) {
            return 0;
        }
        if (value.getClass().isArray()) {
            int order = N.getClazzEnumOrder(value.getClass());
            switch (order) {
                case 1: {
                    return N.hashCode((boolean[])value);
                }
                case 2: {
                    return N.hashCode((char[])value);
                }
                case 3: {
                    return N.hashCode((byte[])value);
                }
                case 4: {
                    return N.hashCode((short[])value);
                }
                case 5: {
                    return N.hashCode((int[])value);
                }
                case 6: {
                    return N.hashCode((long[])value);
                }
                case 7: {
                    return N.hashCode((float[])value);
                }
                case 8: {
                    return N.hashCode((double[])value);
                }
            }
            return N.hashCode((Object[])value);
        }
        return value.hashCode();
    }

    public static int deepHashCode(Object value) {
        if (value == null) {
            return 0;
        }
        if (value.getClass().isArray()) {
            int order = N.getClazzEnumOrder(value.getClass());
            switch (order) {
                case 1: {
                    return N.hashCode((boolean[])value);
                }
                case 2: {
                    return N.hashCode((char[])value);
                }
                case 3: {
                    return N.hashCode((byte[])value);
                }
                case 4: {
                    return N.hashCode((short[])value);
                }
                case 5: {
                    return N.hashCode((int[])value);
                }
                case 6: {
                    return N.hashCode((long[])value);
                }
                case 7: {
                    return N.hashCode((float[])value);
                }
                case 8: {
                    return N.hashCode((double[])value);
                }
            }
            return N.deepHashCode((Object[])value);
        }
        return value.hashCode();
    }

    public static int hashCode(boolean[] a) {
        return Arrays.hashCode(a);
    }

    public static int hashCode(char[] a) {
        return Arrays.hashCode(a);
    }

    public static int hashCode(byte[] a) {
        return Arrays.hashCode(a);
    }

    public static int hashCode(short[] a) {
        return Arrays.hashCode(a);
    }

    public static int hashCode(int[] a) {
        return Arrays.hashCode(a);
    }

    public static int hashCode(long[] a) {
        return Arrays.hashCode(a);
    }

    public static int hashCode(float[] a) {
        return Arrays.hashCode(a);
    }

    public static int hashCode(double[] a) {
        return Arrays.hashCode(a);
    }

    public static int hashCode(Object[] a) {
        return Arrays.hashCode(a);
    }

    public static int deepHashCode(Object[] a) {
        return Arrays.deepHashCode(a);
    }

    public static String toString(boolean value) {
        return String.valueOf(value);
    }

    public static String toString(char value) {
        return String.valueOf(value);
    }

    public static String toString(byte value) {
        return String.valueOf(value);
    }

    public static String toString(short value) {
        return String.valueOf(value);
    }

    public static String toString(int value) {
        return String.valueOf(value);
    }

    public static String toString(long value) {
        return String.valueOf(value);
    }

    public static String toString(float value) {
        return String.valueOf(value);
    }

    public static String toString(double value) {
        return String.valueOf(value);
    }

    public static String toString(Object value) {
        if (value == null) {
            return NULL_STRING;
        }
        if (value.getClass().isArray()) {
            int order = N.getClazzEnumOrder(value.getClass());
            switch (order) {
                case 1: {
                    return N.toString((boolean[])value);
                }
                case 2: {
                    return N.toString((char[])value);
                }
                case 3: {
                    return N.toString((byte[])value);
                }
                case 4: {
                    return N.toString((short[])value);
                }
                case 5: {
                    return N.toString((int[])value);
                }
                case 6: {
                    return N.toString((long[])value);
                }
                case 7: {
                    return N.toString((float[])value);
                }
                case 8: {
                    return N.toString((double[])value);
                }
            }
            return N.toString((Object[])value);
        }
        return value.toString();
    }

    public static String deepToString(Object value) {
        if (value == null) {
            return NULL_STRING;
        }
        if (value.getClass().isArray()) {
            int order = N.getClazzEnumOrder(value.getClass());
            switch (order) {
                case 1: {
                    return N.toString((boolean[])value);
                }
                case 2: {
                    return N.toString((char[])value);
                }
                case 3: {
                    return N.toString((byte[])value);
                }
                case 4: {
                    return N.toString((short[])value);
                }
                case 5: {
                    return N.toString((int[])value);
                }
                case 6: {
                    return N.toString((long[])value);
                }
                case 7: {
                    return N.toString((float[])value);
                }
                case 8: {
                    return N.toString((double[])value);
                }
            }
            return N.deepToString((Object[])value);
        }
        return value.toString();
    }

    public static String toString(boolean[] a) {
        return Arrays.toString(a);
    }

    public static String toString(char[] a) {
        return Arrays.toString(a);
    }

    public static String toString(byte[] a) {
        return Arrays.toString(a);
    }

    public static String toString(short[] a) {
        return Arrays.toString(a);
    }

    public static String toString(int[] a) {
        return Arrays.toString(a);
    }

    public static String toString(long[] a) {
        return Arrays.toString(a);
    }

    public static String toString(float[] a) {
        return Arrays.toString(a);
    }

    public static String toString(double[] a) {
        return Arrays.toString(a);
    }

    public static String toString(Object[] a) {
        return Arrays.toString(a);
    }

    public static String deepToString(Object[] a) {
        return Arrays.deepToString(a);
    }

    public static <T> T newInstance(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newProxyInstance(Class<T> interfaceClass, InvocationHandler h) {
        return (T)N.newProxyInstance(N.asArray(interfaceClass), h);
    }

    public static Object newProxyInstance(Class<?>[] interfaces, InvocationHandler h) {
        return Proxy.newProxyInstance(N.class.getClassLoader(), interfaces, h);
    }

    public static <T> T newArray(Class<?> cls, int length) {
        return (T)Array.newInstance(cls, length);
    }

    public static <T> ArrayList<T> newArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <T> LinkedList<T> newLinkedList() {
        return new LinkedList();
    }

    public static <T> HashSet<T> newHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(int initialCapacity) {
        return new LinkedHashSet(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap(int initialCapacity) {
        return new IdentityHashMap(initialCapacity);
    }

    public static <T> ArrayBlockingQueue<T> newArrayBlockingQueue(int capacity) {
        return new ArrayBlockingQueue(capacity);
    }

    public static <T> LinkedBlockingQueue<T> newLinkedBlockingQueue(int capacity) {
        return new LinkedBlockingQueue(capacity);
    }

    public static <T> ArrayDeque newArrayDeque(int initialCapacity) {
        return new ArrayDeque(initialCapacity);
    }

    public static <T> LinkedBlockingDeque newLinkedBlockingDeque(int capacity) {
        return new LinkedBlockingDeque(capacity);
    }

    public static <T> T newEntity(Class<T> cls, String entityName) {
        try {
            if (N.getEnclosingClass(cls) == null || Modifier.isStatic(cls.getModifiers())) {
                return N.newInstance(cls);
            }
            Object object = N.getEnclosingClass(cls).newInstance();
            return cls.getConstructor(N.getEnclosingClass(cls)).newInstance(object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> asProps(Object ... a) {
        Map<String, Object> props = N.asMap(a);
        return props;
    }

    public static Map<String, Object> asProps(Map<String, Object> m) {
        Map<String, Object> props = N.asMap(m);
        return props;
    }

    public static <K, V> Map<K, V> asMap(Object ... a) {
        return N.newMap(new HashMap(), a);
    }

    public static <K, V> Map<K, V> asMap(Map<? extends K, ? extends V> m) {
        HashMap<? extends K, ? extends V> result = new HashMap<K, V>(m);
        if (N.notNullOrEmpty(m)) {
            result.putAll(m);
        }
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> asLinkedHashMap(Object ... a) {
        return (LinkedHashMap)N.newMap(new LinkedHashMap(), a);
    }

    public static <K, V> LinkedHashMap<K, V> asLinkedHashMap(Map<? extends K, ? extends V> m) {
        return new LinkedHashMap<K, V>(m);
    }

    public static <K, V> ConcurrentHashMap<K, V> asConcurrentHashMap(Object ... a) {
        return (ConcurrentHashMap)N.newMap(new ConcurrentHashMap(), a);
    }

    public static <K, V> ConcurrentHashMap<K, V> asConcurrentHashMap(Map<? extends K, ? extends V> m) {
        return new ConcurrentHashMap<K, V>(m);
    }

    public static <K, V> IdentityHashMap<K, V> asIdentityHashMap(Object ... a) {
        return (IdentityHashMap)N.newMap(new IdentityHashMap(), a);
    }

    public static <K, V> IdentityHashMap<K, V> asIdentityHashMap(Map<? extends K, ? extends V> m) {
        return new IdentityHashMap<K, V>(m);
    }

    public static <K, V> SortedMap<K, V> asSortedMap(Object ... a) {
        return (SortedMap)N.newMap(new TreeMap(), a);
    }

    public static <K, V> SortedMap<K, V> asSortedMap(Map<? extends K, ? extends V> m) {
        if (m instanceof SortedMap) {
            return new TreeMap((SortedMap)m);
        }
        return new TreeMap<K, V>(m);
    }

    public static <K, V> SortedMap<K, V> asSortedMap(Comparator<? super K> comparator, Object ... a) {
        TreeMap sortedMap = new TreeMap(comparator);
        return (SortedMap)N.newMap(sortedMap, a);
    }

    public static <K, V> SortedMap<K, V> asSortedMap(Comparator<? super K> comparator, Map<? extends K, ? extends V> m) {
        TreeMap<? extends K, ? extends V> sortedMap = new TreeMap<K, V>(comparator);
        sortedMap.putAll(m);
        return sortedMap;
    }

    private static <K, V> Map<K, V> newMap(Map<K, V> m, Object ... a) {
        if (N.isNullOrEmpty(a)) {
            return m;
        }
        if (a.length == 1) {
            if (a[0] instanceof Map) {
                m.putAll((Map)a[0]);
                return m;
            }
            Object entity = a[0];
            Map<String, Method> getterMethodList = N.getPropGetMethodList(a[0].getClass());
            if (getterMethodList.size() == 0) {
                throw new IllegalArgumentException("The parameter must be the pairs of property name and value, or an entity class with get/set methods.");
            }
            try {
                for (String propName : getterMethodList.keySet()) {
                    m.put(propName, getterMethodList.get(propName).invoke(entity, new Object[0]));
                }
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return m;
        }
        if (0 != a.length % 2) {
            throw new IllegalArgumentException("the parameter must be the pairs of property name and value, or an entity class with get/set methods.");
        }
        for (int i = 0; i < a.length; ++i) {
            m.put((String)a[i], a[++i]);
        }
        return m;
    }

    public static <T> List<T> asList(T ... a) {
        ArrayList<T> list = a.length > 0 ? new ArrayList<T>(a.length) : new ArrayList();
        for (T e : a) {
            list.add(e);
        }
        return list;
    }

    public static <T> List<T> asList(Collection<T> c) {
        return new ArrayList<T>(c);
    }

    public static <T> LinkedList<T> asLinkedList(T ... a) {
        LinkedList<T> list = new LinkedList<T>();
        for (T e : a) {
            list.add(e);
        }
        return list;
    }

    public static <T> LinkedList<T> asLinkedList(Collection<T> c) {
        return new LinkedList<T>(c);
    }

    public static <T> Set<T> asSet(T ... a) {
        HashSet<T> set = new HashSet<T>();
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    public static <T> Set<T> asSet(Collection<T> c) {
        return new HashSet<T>(c);
    }

    public static <T> LinkedHashSet<T> asLinkedHashSet(T ... a) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    public static <T> LinkedHashSet<T> asLinkedHashSet(Collection<T> c) {
        return new LinkedHashSet<T>(c);
    }

    public static <T> SortedSet<T> asSortedSet(T ... a) {
        TreeSet<T> set = new TreeSet<T>();
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    public static <T> SortedSet<T> asSortedSet(Collection<T> c) {
        if (c instanceof SortedSet) {
            return new TreeSet((SortedSet)c);
        }
        return new TreeSet<T>(c);
    }

    public static <T> SortedSet<T> asSortedSet(Comparator<T> comparator, T ... a) {
        TreeSet<T> set = new TreeSet<T>(comparator);
        for (T e : a) {
            set.add(e);
        }
        return set;
    }

    public static <T> SortedSet<T> asSortedSet(Comparator<T> comparator, Collection<T> c) {
        TreeSet<T> set = new TreeSet<T>(comparator);
        set.addAll(c);
        return set;
    }

    public static <T> Queue<T> asQueue(T ... a) {
        ArrayDeque<T> queue = new ArrayDeque<T>();
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    public static <T> Queue<T> asQueue(Collection<T> c) {
        return new ArrayDeque<T>(c);
    }

    public static <T> ArrayBlockingQueue<T> asArrayBlockingQueue(int capacity, T ... a) {
        ArrayBlockingQueue<T> queue = new ArrayBlockingQueue<T>(capacity);
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    public static <T> ArrayBlockingQueue<T> asArrayBlockingQueue(int capacity, Collection<T> c) {
        return new ArrayBlockingQueue<T>(capacity, false, c);
    }

    public static <T> LinkedBlockingQueue<T> asLinkedBlockingQueue(T ... a) {
        LinkedBlockingQueue<T> queue = new LinkedBlockingQueue<T>();
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    public static <T> LinkedBlockingQueue<T> asLinkedBlockingQueue(Collection<T> c) {
        return new LinkedBlockingQueue<T>(c);
    }

    public static <T> ConcurrentLinkedQueue<T> asConcurrentLinkedQueue(T ... a) {
        ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue<T>();
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    public static <T> ConcurrentLinkedQueue<T> asConcurrentLinkedQueue(Collection<T> c) {
        return new ConcurrentLinkedQueue<T>(c);
    }

    public static <T extends Delayed> DelayQueue<T> asDelayQueue(T ... a) {
        DelayQueue<T> queue = new DelayQueue<T>();
        for (T e : a) {
            queue.add(e);
        }
        return queue;
    }

    public static <T extends Delayed> DelayQueue<T> asDelayQueue(Collection<T> c) {
        return new DelayQueue<T>(c);
    }

    public static <T> Deque<T> asDeque(T ... a) {
        ArrayDeque<T> deque = new ArrayDeque<T>();
        for (T e : a) {
            deque.add(e);
        }
        return deque;
    }

    public static <T> Deque<T> asDeque(Collection<T> c) {
        return new ArrayDeque<T>(c);
    }

    public static <T> LinkedBlockingDeque<T> asLinkedBlockingDeque(T ... a) {
        LinkedBlockingDeque<T> deque = new LinkedBlockingDeque<T>();
        for (T e : a) {
            deque.add(e);
        }
        return deque;
    }

    public static <T> LinkedBlockingDeque<T> asLinkedBlockingDeque(Collection<T> c) {
        return new LinkedBlockingDeque<T>(c);
    }

    public static <T> T[] asArray(T ... a) {
        return a;
    }

    public static <T> T[] asArray(Collection<T> c) {
        if (c != null && c.size() > 0) {
            return c.toArray((Object[])Array.newInstance(c.iterator().next().getClass(), c.size()));
        }
        return new Object[0];
    }

    private static <T> boolean isArray(Class<T> cls) {
        return cls.isArray();
    }

    public static boolean asBoolean(String st) {
        return Boolean.valueOf(st);
    }

    public static byte asByte(String st) {
        return N.isNullOrEmpty(st) ? (byte)0 : Byte.parseByte(st);
    }

    public static int asShort(String st) {
        return N.isNullOrEmpty(st) ? (short)0 : Short.parseShort(st);
    }

    public static int asInt(String st) {
        return N.isNullOrEmpty(st) ? 0 : Integer.parseInt(st);
    }

    public static long asLong(String st) {
        return N.isNullOrEmpty(st) ? 0L : Long.parseLong(st);
    }

    public static float asFloat(String st) {
        return N.isNullOrEmpty(st) ? 0.0f : Float.parseFloat(st);
    }

    public static double asDouble(String st) {
        return N.isNullOrEmpty(st) ? 0.0 : Double.parseDouble(st);
    }

    public static Date asJUDate(Calendar c) {
        return c == null ? null : N.asJUDate(c.getTimeInMillis());
    }

    public static Date asJUDate(Date date) {
        return date == null ? null : N.asJUDate(date.getTime());
    }

    public static Date asJUDate(long timeInMillis) {
        return timeInMillis == 0L ? null : new Date(timeInMillis);
    }

    public static Date asJUDate(String date) {
        return N.asJUDate(date, null);
    }

    public static Date asJUDate(String date, String format) {
        return N.asJUDate(date, format, null);
    }

    public static Date asJUDate(String date, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(date)) {
            return null;
        }
        long timeInMillis = N.fastDateParse(date, format = N.checkDateFormat(date, format), timeZone = N.checkTimeZone(format, timeZone));
        if (timeInMillis > 0L) {
            return new java.sql.Date(timeInMillis);
        }
        SimpleDateFormat sdf = N.getSDF(format, timeZone);
        try {
            Date date2 = sdf.parse(date);
            return date2;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        finally {
            SDF_POOL.get(format).add(sdf);
        }
    }

    private static long parse(String date, String format, TimeZone timeZone) {
        long timeInMillis = N.fastDateParse(date, format = N.checkDateFormat(date, format), timeZone = N.checkTimeZone(format, timeZone));
        if (timeInMillis > 0L) {
            return timeInMillis;
        }
        SimpleDateFormat sdf = N.getSDF(format, timeZone);
        try {
            long l = sdf.parse(date).getTime();
            return l;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        finally {
            SDF_POOL.get(format).add(sdf);
        }
    }

    private static String checkDateFormat(String st, String format) {
        if (format == null) {
            String string = st.length() == 20 ? DEFAULT_DATETIME_FORMAT : (st.length() == 24 ? DEFAULT_TIMESTAMP_FORMAT : (format = st.length() == 19 ? LOCAL_DATETIME_FORMAT : null));
        }
        if (format == null) {
            throw new RuntimeException("No valid date format found for: " + st);
        }
        return format;
    }

    private static TimeZone checkTimeZone(String format, TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = format.charAt(format.length() - 2) == 'Z' && format.endsWith("'Z'") ? UTC_TIME_ZONE : LOCAL_TIME_ZONE;
        }
        return timeZone;
    }

    private static final long fastDateParse(String st, String format, TimeZone timeZone) {
        if (!(format.equals(DEFAULT_DATETIME_FORMAT) || format.equals(DEFAULT_TIMESTAMP_FORMAT) || format.equals(LOCAL_DATETIME_FORMAT))) {
            return 0L;
        }
        if (st.length() != 20 && st.length() != 24 && st.length() != 19) {
            return 0L;
        }
        int year = N.digit(st, 0, 4);
        int month = N.digit(st, 5, 7) - 1;
        int date = N.digit(st, 8, 10);
        int hourOfDay = N.digit(st, 11, 13);
        int minute = N.digit(st, 14, 16);
        int second = N.digit(st, 17, 19);
        int milliSecond = st.length() == 24 ? N.digit(st, 20, 23) : 0;
        Calendar c = null;
        Queue<Calendar> timeZoneCalendarQueue = null;
        if (timeZone == UTC_TIME_ZONE) {
            c = utcCalendarPool.poll();
        } else {
            timeZoneCalendarQueue = calendarPool.get(timeZone);
            if (timeZoneCalendarQueue == null) {
                timeZoneCalendarQueue = N.newArrayBlockingQueue(1000);
                calendarPool.put(timeZone, timeZoneCalendarQueue);
            } else {
                c = timeZoneCalendarQueue.poll();
            }
        }
        if (c == null) {
            c = Calendar.getInstance(timeZone);
        }
        c.set(year, month, date, hourOfDay, minute, second);
        c.set(14, milliSecond);
        long timeInMillis = c.getTimeInMillis();
        if (timeZone == UTC_TIME_ZONE) {
            utcCalendarPool.add(c);
        } else {
            timeZoneCalendarQueue.add(c);
        }
        return timeInMillis;
    }

    private static int digit(String st, int from, int to) {
        int result = 0;
        while (from < to) {
            result = result * 10 + (st.charAt(from++) - 48);
        }
        return result;
    }

    public static Timestamp asTimestamp(Calendar c) {
        return c == null ? null : N.asTimestamp(c.getTimeInMillis());
    }

    public static Timestamp asTimestamp(Date date) {
        return date == null ? null : N.asTimestamp(date.getTime());
    }

    public static Timestamp asTimestamp(long timeInMillis) {
        return timeInMillis == 0L ? null : new Timestamp(timeInMillis);
    }

    public static Timestamp asTimestamp(String date) {
        return N.asTimestamp(date, null);
    }

    public static Timestamp asTimestamp(String date, String format) {
        return N.asTimestamp(date, format, null);
    }

    public static Timestamp asTimestamp(String date, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(date)) {
            return null;
        }
        return N.asTimestamp(N.parse(date, format, timeZone));
    }

    public static java.sql.Date asDate(Calendar c) {
        return c == null ? null : N.asDate(c.getTimeInMillis());
    }

    public static java.sql.Date asDate(Date date) {
        return date == null ? null : N.asDate(date.getTime());
    }

    public static java.sql.Date asDate(long timeInMillis) {
        return timeInMillis == 0L ? null : new java.sql.Date(timeInMillis);
    }

    public static java.sql.Date asDate(String date) {
        return N.asDate(date, null);
    }

    public static java.sql.Date asDate(String date, String format) {
        return N.asDate(date, format, null);
    }

    public static java.sql.Date asDate(String date, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(date)) {
            return null;
        }
        return N.asDate(N.parse(date, format, timeZone));
    }

    public static Time asTime(Calendar c) {
        return c == null ? null : N.asTime(c.getTimeInMillis());
    }

    public static Time asTime(Date date) {
        return date == null ? null : N.asTime(date.getTime());
    }

    public static Time asTime(long timeInMillis) {
        return timeInMillis == 0L ? null : new Time(timeInMillis);
    }

    public static Time asTime(String date) {
        return N.asTime(date, null);
    }

    public static Time asTime(String date, String format) {
        return N.asTime(date, format, null);
    }

    public static Time asTime(String date, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(date)) {
            return null;
        }
        return N.asTime(N.parse(date, format, timeZone));
    }

    public static Calendar asCalendar(Calendar c) {
        return c == null ? null : N.asCalendar(c.getTimeInMillis());
    }

    public static Calendar asCalendar(Date date) {
        return date == null ? null : N.asCalendar(date.getTime());
    }

    public static Calendar asCalendar(long timeInMillis) {
        if (timeInMillis == 0L) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeInMillis);
        return c;
    }

    public static Calendar asCalendar(String calendar) {
        return N.asCalendar(calendar, null);
    }

    public static Calendar asCalendar(String calendar, String format) {
        return N.asCalendar(calendar, format, null);
    }

    public static Calendar asCalendar(String calendar, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(calendar)) {
            return null;
        }
        return N.asCalendar(N.parse(calendar, format, timeZone));
    }

    public static GregorianCalendar asGregorianCalendar(Calendar c) {
        return c == null ? null : N.asGregorianCalendar(c.getTimeInMillis());
    }

    public static GregorianCalendar asGregorianCalendar(Date date) {
        return date == null ? null : N.asGregorianCalendar(date.getTime());
    }

    public static GregorianCalendar asGregorianCalendar(long timeInMillis) {
        if (timeInMillis == 0L) {
            return null;
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(timeInMillis);
        return c;
    }

    public static GregorianCalendar asGregorianCalendar(String calendar) {
        return N.asGregorianCalendar(calendar, null);
    }

    public static GregorianCalendar asGregorianCalendar(String calendar, String format) {
        return N.asGregorianCalendar(calendar, format, null);
    }

    public static GregorianCalendar asGregorianCalendar(String calendar, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(calendar)) {
            return null;
        }
        return N.asGregorianCalendar(N.parse(calendar, format, timeZone));
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(Calendar c) {
        return c == null ? null : N.asXMLGregorianCalendar(c.getTimeInMillis());
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(Date date) {
        return date == null ? null : N.asXMLGregorianCalendar(date.getTime());
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(long timeInMillis) {
        if (timeInMillis == 0L) {
            return null;
        }
        XMLGregorianCalendar c = dataTypeFactory.newXMLGregorianCalendar(N.asGregorianCalendar(timeInMillis));
        return c;
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(String calendar) {
        return N.asXMLGregorianCalendar(calendar, null);
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(String calendar, String format) {
        return N.asXMLGregorianCalendar(calendar, format, null);
    }

    public static XMLGregorianCalendar asXMLGregorianCalendar(String calendar, String format, TimeZone timeZone) {
        if (N.isNullOrEmpty(calendar)) {
            return null;
        }
        return N.asXMLGregorianCalendar(N.parse(calendar, format, timeZone));
    }

    public static long currentMillis() {
        return System.currentTimeMillis();
    }

    public static Time currentTime() {
        return new Time(System.currentTimeMillis());
    }

    public static java.sql.Date currentDate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Timestamp currentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static Date currentJUDate() {
        return new Date();
    }

    public static Calendar currentCalendar() {
        return Calendar.getInstance();
    }

    public static GregorianCalendar currentGregorianCalendar() {
        return new GregorianCalendar();
    }

    public static XMLGregorianCalendar currentXMLGregorianCalendar() {
        return dataTypeFactory.newXMLGregorianCalendar(N.currentGregorianCalendar());
    }

    private static SimpleDateFormat getSDF(String format, TimeZone timeZone) {
        SimpleDateFormat sdf;
        Queue<SimpleDateFormat> queue = SDF_POOL.get(format);
        if (queue == null) {
            queue = N.newArrayBlockingQueue(1000);
            SDF_POOL.put(format, queue);
        }
        if ((sdf = queue.poll()) == null) {
            sdf = new SimpleDateFormat(format);
        }
        sdf.setTimeZone(timeZone);
        return sdf;
    }

    public static <T extends Date> T roll(T date, long amount, TimeUnit unit) {
        date.setTime(date.getTime() + unit.toMillis(amount));
        return date;
    }

    public static <T extends Date> T roll(T date, int amount, CalendarUnit unit) {
        switch (unit) {
            case MONTH: 
            case YEAR: {
                Calendar c = N.asCalendar(date);
                c.add(unit.intValue(), amount);
                date.setTime(c.getTimeInMillis());
                break;
            }
            default: {
                date.setTime(date.getTime() + unit.toMillis(amount));
            }
        }
        return date;
    }

    public static void roll(Calendar c, long amount, TimeUnit unit) {
        c.setTimeInMillis(c.getTimeInMillis() + unit.toMillis(amount));
    }

    public static Calendar roll(Calendar c, int amount, CalendarUnit unit) {
        c.add(unit.intValue(), amount);
        return c;
    }

    public static String base64Encode(byte[] binaryData) {
        return Base64.encode(binaryData);
    }

    public static byte[] base64Decode(String encoded) {
        return Base64.decode(encoded);
    }

    public static String uuid() {
        SecureRandom ng = numberGenerator;
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long mostSigBits = 0L;
        for (int i = 0; i < 8; ++i) {
            mostSigBits = mostSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        long leastSigBits = 0L;
        for (int i = 8; i < 16; ++i) {
            leastSigBits = leastSigBits << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return N.digits(mostSigBits >> 32, 8) + N.digits(mostSigBits >> 16, 4) + N.digits(mostSigBits, 4) + N.digits(leastSigBits >> 48, 4) + N.digits(leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static String vuid() {
        return Base64.encode(new UID().toString().getBytes());
    }

    public static String upCaseFirstChar(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return N.toString(Character.toUpperCase(str.charAt(0)));
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String lowCaseFirstChar(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        if (str.length() == 1) {
            return N.toString(Character.toLowerCase(str.charAt(0)));
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    public static <T> Future<T> asynExecute(final Method method, final Object instance, final Object ... args) {
        FutureTask future = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return method.invoke(instance, args);
            }
        });
        executorService.execute(future);
        return future;
    }

    public static void asynExecute(Runnable command) {
        executorService.execute(command);
    }

    public static void println(Object obj) {
        System.out.println(N.toString(obj));
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            logger.warning("failed to sleep: " + millis + " due to: " + e.getMessage());
        }
    }

    static Class<?>[] getTypeArgumentsBySetMethod(Method propSetMethod) {
        if (propSetMethod == null) {
            return null;
        }
        Class<?>[] typeParameterClasses = methodTypeArgumentsPool.get(propSetMethod);
        if (typeParameterClasses == null) {
            Type genericParameterType = propSetMethod.getGenericParameterTypes()[0];
            if (genericParameterType instanceof ParameterizedType) {
                ParameterizedType aType = (ParameterizedType)genericParameterType;
                Type[] parameterArgTypes = aType.getActualTypeArguments();
                typeParameterClasses = new Class[parameterArgTypes.length];
                for (int i = 0; i < parameterArgTypes.length; ++i) {
                    typeParameterClasses[i] = (Class)parameterArgTypes[i];
                }
            } else {
                typeParameterClasses = DUMMY_CLASSES;
            }
            methodTypeArgumentsPool.put(propSetMethod, typeParameterClasses);
        }
        return typeParameterClasses == DUMMY_CLASSES ? null : typeParameterClasses;
    }

    private static <T> void checkEntityClass(Class<T> cls) {
        if (N.getPropGetMethodList(cls).size() == 0) {
            throw new IllegalArgumentException("No property getXXX/setXXX method is found in the specified class: " + N.getClassCanonicalName(cls));
        }
    }

    public static String list2String(List<?> list) {
        return N.collection2String(list, ", ", false);
    }

    public static String list2String(List<?> list, String separator) {
        return N.collection2String(list, separator, false);
    }

    public static String list2String(List<?> list, String separator, boolean trim) {
        return N.collection2String(list, separator, trim);
    }

    public static String set2String(Set<?> set) {
        return N.collection2String(set, ", ", false);
    }

    public static String set2String(Set<?> set, String separator) {
        return N.collection2String(set, separator, false);
    }

    public static String set2String(Set<?> set, String separator, boolean trim) {
        return N.collection2String(set, separator, trim);
    }

    public static String queue2String(Queue<?> queue) {
        return N.collection2String(queue, ", ", false);
    }

    public static String queue2String(Queue<?> queue, String separator) {
        return N.collection2String(queue, separator, false);
    }

    public static String queue2String(Queue<?> queue, String separator, boolean trim) {
        return N.collection2String(queue, separator, trim);
    }

    private static String collection2String(Collection<?> c, String separator, boolean trim) {
        if (c == null) {
            return null;
        }
        Iterator<?> it = c.iterator();
        if (trim) {
            if (c.size() == 1) {
                return N.toString(it.next()).trim();
            }
            if (c.size() == 2) {
                return N.toString(it.next()).trim() + separator + N.toString(it.next()).trim();
            }
            if (c.size() == 3) {
                return N.toString(it.next()).trim() + separator + N.toString(it.next()).trim() + separator + N.toString(it.next()).trim();
            }
            StringBuilder sb = ObjectFactory.createStringBuilder();
            int size = c.size();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    sb.append(separator);
                }
                sb.append(N.toString(it.next()).trim());
            }
            String st = sb.toString();
            ObjectFactory.recycle(sb);
            return st;
        }
        if (c.size() == 1) {
            return N.toString(it.next());
        }
        if (c.size() == 2) {
            return N.toString(it.next()) + separator + N.toString(it.next());
        }
        if (c.size() == 3) {
            return N.toString(it.next()) + separator + N.toString(it.next()) + separator + N.toString(it.next());
        }
        StringBuilder sb = ObjectFactory.createStringBuilder();
        int size = c.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(N.toString(it.next()));
        }
        String st = sb.toString();
        ObjectFactory.recycle(sb);
        return st;
    }

    public static String array2String(boolean[] a, String separator) {
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        if (a.length == 2) {
            return a[0] + separator + a[1];
        }
        if (a.length == 3) {
            return a[0] + separator + a[1] + separator + a[2];
        }
        StringBuilder sb = new StringBuilder();
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String array2String(char[] a, String separator) {
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        if (a.length == 2) {
            return a[0] + separator + a[1];
        }
        if (a.length == 3) {
            return a[0] + separator + a[1] + separator + a[2];
        }
        StringBuilder sb = new StringBuilder();
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String array2String(byte[] a, String separator) {
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        if (a.length == 2) {
            return a[0] + separator + a[1];
        }
        if (a.length == 3) {
            return a[0] + separator + a[1] + separator + a[2];
        }
        StringBuilder sb = new StringBuilder();
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String array2String(short[] a, String separator) {
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        if (a.length == 2) {
            return a[0] + separator + a[1];
        }
        if (a.length == 3) {
            return a[0] + separator + a[1] + separator + a[2];
        }
        StringBuilder sb = new StringBuilder();
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String array2String(int[] a, String separator) {
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        if (a.length == 2) {
            return a[0] + separator + a[1];
        }
        if (a.length == 3) {
            return a[0] + separator + a[1] + separator + a[2];
        }
        StringBuilder sb = new StringBuilder();
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String array2String(long[] a, String separator) {
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        if (a.length == 2) {
            return a[0] + separator + a[1];
        }
        if (a.length == 3) {
            return a[0] + separator + a[1] + separator + a[2];
        }
        StringBuilder sb = new StringBuilder();
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String array2String(float[] a, String separator) {
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        if (a.length == 2) {
            return a[0] + separator + a[1];
        }
        if (a.length == 3) {
            return a[0] + separator + a[1] + separator + a[2];
        }
        StringBuilder sb = new StringBuilder();
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String array2String(double[] a, String separator) {
        if (a.length == 1) {
            return String.valueOf(a[0]);
        }
        if (a.length == 2) {
            return a[0] + separator + a[1];
        }
        if (a.length == 3) {
            return a[0] + separator + a[1] + separator + a[2];
        }
        StringBuilder sb = new StringBuilder();
        int length = a.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(a[i]);
        }
        return sb.toString();
    }

    public static String array2String(Object a) {
        return N.array2String(a, ", ", false);
    }

    public static String array2String(Object a, String separator) {
        return N.array2String(a, separator, false);
    }

    public static String array2String(Object a, String separator, boolean trim) {
        if (a == null) {
            return null;
        }
        if (!a.getClass().isArray()) {
            throw new IllegalArgumentException(a.getClass() + " is not an array type");
        }
        int order = N.getClazzEnumOrder(a.getClass());
        switch (order) {
            case 1: {
                boolean[] booleans = (boolean[])a;
                return N.array2String(booleans, separator);
            }
            case 2: {
                char[] chars = (char[])a;
                return N.array2String(chars, separator);
            }
            case 3: {
                byte[] bytes = (byte[])a;
                return N.array2String(bytes, separator);
            }
            case 4: {
                short[] shorts = (short[])a;
                return N.array2String(shorts, separator);
            }
            case 5: {
                int[] ints = (int[])a;
                return N.array2String(ints, separator);
            }
            case 6: {
                long[] longs = (long[])a;
                return N.array2String(longs, separator);
            }
            case 7: {
                float[] floats = (float[])a;
                return N.array2String(floats, separator);
            }
            case 8: {
                double[] doubles = (double[])a;
                return N.array2String(doubles, separator);
            }
        }
        Object[] objects = (Object[])a;
        if (trim) {
            if (objects.length == 1) {
                return N.toString(objects[0]).trim();
            }
            if (objects.length == 2) {
                return N.toString(objects[0]).trim() + separator + N.toString(objects[1]).trim();
            }
            if (objects.length == 3) {
                return N.toString(objects[0]).trim() + separator + N.toString(objects[1]).trim() + separator + N.toString(objects[2]).trim();
            }
            StringBuilder sb = ObjectFactory.createStringBuilder();
            for (int i = 0; i < objects.length; ++i) {
                if (i > 0) {
                    sb.append(separator);
                }
                sb.append(N.toString(objects[i]).trim());
            }
            String st = sb.toString();
            ObjectFactory.recycle(sb);
            return st;
        }
        if (objects.length == 1) {
            return N.toString(objects[0]);
        }
        if (objects.length == 2) {
            return N.toString(objects[0]) + separator + N.toString(objects[1]);
        }
        if (objects.length == 3) {
            return N.toString(objects[0]) + separator + N.toString(objects[1]) + separator + N.toString(objects[2]);
        }
        StringBuilder sb = ObjectFactory.createStringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(N.toString(objects[i]));
        }
        String st = sb.toString();
        ObjectFactory.recycle(sb);
        return st;
    }

    public static String format(Date date) {
        return N.format(date, null, null);
    }

    public static String format(Date date, String format) {
        return N.format(date, format, null);
    }

    public static String format(Date date, String format, TimeZone timeZone) {
        return N.formatDate(date, format, timeZone, null);
    }

    public static void format(Date date, String format, TimeZone timeZone, Writer writer) {
        N.formatDate(date, format, timeZone, writer);
    }

    private static String formatDate(Date date, String format, TimeZone timeZone, Writer writer) {
        boolean isTimestamp = date instanceof Timestamp;
        if (format == null && timeZone == null) {
            if (writer == null) {
                BufferedWriter cbuff = ObjectFactory.createBufferedWriter();
                N.fastDateFormat(date.getTime(), isTimestamp, cbuff);
                String st = cbuff.toString();
                ObjectFactory.recycle(cbuff);
                return st;
            }
            N.fastDateFormat(date.getTime(), isTimestamp, writer);
            return null;
        }
        if (format == null) {
            format = isTimestamp ? DEFAULT_TIMESTAMP_FORMAT : DEFAULT_DATETIME_FORMAT;
        }
        timeZone = N.checkTimeZone(format, timeZone);
        SimpleDateFormat sdf = N.getSDF(format, timeZone);
        String st = sdf.format(date);
        if (writer == null) {
            SDF_POOL.get(format).add(sdf);
            return st;
        }
        try {
            writer.write(st);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        finally {
            SDF_POOL.get(format).add(sdf);
        }
        return null;
    }

    public static String format(Calendar c) {
        return N.format(c, null, null);
    }

    public static String format(Calendar c, String format) {
        return N.format(c, format, null);
    }

    public static String format(Calendar c, String format, TimeZone timeZone) {
        if (format == null && timeZone == null) {
            BufferedWriter cbuff = ObjectFactory.createBufferedWriter();
            N.fastDateFormat(c.getTimeInMillis(), false, cbuff);
            String st = cbuff.toString();
            ObjectFactory.recycle(cbuff);
            return st;
        }
        return N.format(N.asJUDate(c), format, timeZone);
    }

    public static void format(Calendar c, String format, TimeZone timeZone, Writer writer) {
        if (format == null && timeZone == null) {
            N.fastDateFormat(c.getTimeInMillis(), false, writer);
        } else {
            N.format(N.asJUDate(c), format, timeZone, writer);
        }
    }

    public static String format(XMLGregorianCalendar c) {
        return N.format(c, null, null);
    }

    public static String format(XMLGregorianCalendar c, String format) {
        return N.format(c, format, null);
    }

    public static String format(XMLGregorianCalendar c, String format, TimeZone timeZone) {
        if (format == null && timeZone == null) {
            BufferedWriter cbuff = ObjectFactory.createBufferedWriter();
            N.fastDateFormat(c.toGregorianCalendar().getTimeInMillis(), false, cbuff);
            String st = cbuff.toString();
            ObjectFactory.recycle(cbuff);
            return st;
        }
        return N.format(N.asJUDate(c.toGregorianCalendar()), format, timeZone);
    }

    public static void format(XMLGregorianCalendar c, String format, TimeZone timeZone, Writer writer) {
        if (format == null && timeZone == null) {
            N.fastDateFormat(c.toGregorianCalendar().getTimeInMillis(), false, writer);
        } else {
            N.format(N.asJUDate(c.toGregorianCalendar()), format, timeZone, writer);
        }
    }

    private static void fastDateFormat(long timeInMillis, boolean isTimestamp, Writer writer) {
        Calendar c = utcCalendarPool.poll();
        if (c == null) {
            c = Calendar.getInstance(UTC_TIME_ZONE);
        }
        c.setTimeInMillis(timeInMillis);
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        int minute = c.get(12);
        int second = c.get(13);
        try {
            writer.write(cbufOfSTDInt[4][year]);
            writer.write(45);
            writer.write(cbufOfSTDInt[2][month]);
            writer.write(45);
            writer.write(cbufOfSTDInt[2][day]);
            writer.write(84);
            writer.write(cbufOfSTDInt[2][hour]);
            writer.write(58);
            writer.write(cbufOfSTDInt[2][minute]);
            writer.write(58);
            writer.write(cbufOfSTDInt[2][second]);
            if (isTimestamp) {
                writer.write(46);
                int milliSecond = c.get(14);
                writer.write(cbufOfSTDInt[3][milliSecond]);
            }
            writer.write(90);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            utcCalendarPool.add(c);
        }
    }

    public static String format(String format, double d) {
        DecimalFormat numberFormat = new DecimalFormat(format);
        return numberFormat.format(d);
    }

    public static String formalizeQuotation(String str) {
        if (N.isNullOrEmpty(str)) {
            return str;
        }
        int length = str.length();
        StringBuilder sb = ObjectFactory.createStringBuilder();
        char c = '\u0000';
        for (int i = 0; i < length; ++i) {
            c = str.charAt(i);
            if (c == '\\' && i < length - 1) {
                sb.append(c);
                sb.append(str.charAt(++i));
                continue;
            }
            if (c == '\'' || c == '\"') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        String st = sb.toString();
        ObjectFactory.recycle(sb);
        return st;
    }

    public static boolean isPrimaryType(Class<?> cls) {
        return PRIMARY_TYPE.contains(cls);
    }

    public static Map<String, String> properties2Map(Properties props) {
        Map<String, String> m = N.asMap(new Object[0]);
        for (Object key : props.keySet()) {
            m.put(N.toString(key), N.toString(props.get(key)));
        }
        return m;
    }

    public static boolean isBetween(int value, int min, int max) {
        return value > min && value < max;
    }

    public static <T> T createMask(Class<T> interfaceClass) {
        InvocationHandler h = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        };
        return N.newProxyInstance(interfaceClass, h);
    }

    static int getClazzEnumOrder(Class<?> cls) {
        Integer order = cls.isArray() ? CLASS_ENUM_ORDER.get(cls.getComponentType()) : CLASS_ENUM_ORDER.get(cls);
        return order == null ? 0 : order;
    }

    static ClazzParserType getClazzParserType(Class<?> cls) {
        ClazzParserType clsParserType = clsParserTypePool.get(cls);
        if (clsParserType == null) {
            clsParserType = cls.isArray() ? ClazzParserType.ARRAY : (Collection.class.isAssignableFrom(cls) ? ClazzParserType.COLLECTION : (Map.class.isAssignableFrom(cls) ? ClazzParserType.MAP : (N.getPropGetMethodList(cls).size() > 0 ? ClazzParserType.ENTITY : ClazzParserType.SINGLE_VALUE)));
            clsParserTypePool.put(cls, clsParserType);
        }
        return clsParserType;
    }

    static final void dummyMethod() {
    }

    static {
        Object temp = "unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            temp = addr.getHostName();
        }
        catch (UnknownHostException e) {
            logger.warning("Failed to get host name due to error: " + e.getMessage());
        }
        HOST_NAME = temp;
        JAVA_HOME = System.getProperty("java.home");
        JAVA_VERSION = System.getProperty("java.version");
        USER_DIR = System.getProperty("user.dir");
        PATH_SEPARATOR = System.getProperty("path.separator");
        FILE_SEPARATOR = File.separator;
        LINE_SEPARATOR = System.getProperty("line.separator");
        UTF_8 = Charset.forName("UTF-8");
        ASCII = Charset.forName("US-ASCII");
        ISO_8859_1 = Charset.forName("ISO-8859-1");
        NULL_CHAR_ARRAY = NULL_STRING.toCharArray();
        TRUE = Boolean.TRUE.toString();
        FALSE = Boolean.FALSE.toString();
        TRUE_CHAR_ARRAY = Boolean.TRUE.toString().toCharArray();
        FALSE_CHAR_ARRAY = Boolean.FALSE.toString().toCharArray();
        numberGenerator = new SecureRandom();
        SDF_POOL = N.asConcurrentHashMap(new Object[0]);
        calendarPool = N.asConcurrentHashMap(new Object[0]);
        utcCalendarPool = N.newArrayBlockingQueue(1000);
        UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
        LOCAL_TIME_ZONE = Calendar.getInstance().getTimeZone();
        temp = null;
        try {
            temp = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            logger.warning("Failed to initialize XMLGregorianCalendarType: " + e.getMessage());
        }
        dataTypeFactory = temp;
        cbufOfSTDInt = new char[5][][];
        int i = 0;
        int j = 1;
        while (i < 5) {
            N.cbufOfSTDInt[i] = new char[j][];
            for (int k = 0; k < j; ++k) {
                if (i == 1) {
                    N.cbufOfSTDInt[i][k] = String.valueOf(k).toCharArray();
                    continue;
                }
                if (i == 2) {
                    if (k < 10) {
                        N.cbufOfSTDInt[i][k] = ("0" + String.valueOf(k)).toCharArray();
                        continue;
                    }
                    N.cbufOfSTDInt[i][k] = String.valueOf(k).toCharArray();
                    continue;
                }
                if (i == 3) {
                    if (k < 10) {
                        N.cbufOfSTDInt[i][k] = ("00" + String.valueOf(k)).toCharArray();
                        continue;
                    }
                    if (k < 100) {
                        N.cbufOfSTDInt[i][k] = ("0" + String.valueOf(k)).toCharArray();
                        continue;
                    }
                    N.cbufOfSTDInt[i][k] = String.valueOf(k).toCharArray();
                    continue;
                }
                if (i != 4) continue;
                N.cbufOfSTDInt[i][k] = k < 10 ? ("000" + String.valueOf(k)).toCharArray() : (k < 100 ? ("00" + String.valueOf(k)).toCharArray() : (k < 1000 ? ("0" + String.valueOf(k)).toCharArray() : String.valueOf(k).toCharArray()));
            }
            ++i;
            j *= 10;
        }
        PRIMARY_TYPE = N.asSet(new Object[0]);
        PRIMARY_TYPE.add(Boolean.TYPE);
        PRIMARY_TYPE.add(Character.TYPE);
        PRIMARY_TYPE.add(Byte.TYPE);
        PRIMARY_TYPE.add(Short.TYPE);
        PRIMARY_TYPE.add(Integer.TYPE);
        PRIMARY_TYPE.add(Long.TYPE);
        PRIMARY_TYPE.add(Float.TYPE);
        PRIMARY_TYPE.add(Double.TYPE);
        PRIMARY_TYPE.add(Boolean.class);
        PRIMARY_TYPE.add(Character.class);
        PRIMARY_TYPE.add(Byte.class);
        PRIMARY_TYPE.add(Short.class);
        PRIMARY_TYPE.add(Integer.class);
        PRIMARY_TYPE.add(Long.class);
        PRIMARY_TYPE.add(Float.class);
        PRIMARY_TYPE.add(Double.class);
        DEFAULT_VALUE_FOR_PRIMARY_TYPE = N.asMap(new Object[0]);
        DEFAULT_VALUE_FOR_PRIMARY_TYPE.put(Boolean.TYPE, false);
        DEFAULT_VALUE_FOR_PRIMARY_TYPE.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULT_VALUE_FOR_PRIMARY_TYPE.put(Byte.TYPE, (byte)0);
        DEFAULT_VALUE_FOR_PRIMARY_TYPE.put(Short.TYPE, (short)0);
        DEFAULT_VALUE_FOR_PRIMARY_TYPE.put(Integer.TYPE, 0);
        DEFAULT_VALUE_FOR_PRIMARY_TYPE.put(Long.TYPE, 0L);
        DEFAULT_VALUE_FOR_PRIMARY_TYPE.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_VALUE_FOR_PRIMARY_TYPE.put(Double.TYPE, 0.0);
        CLASS_ENUM_ORDER = N.asMap(new Object[0]);
        CLASS_ENUM_ORDER.put(Boolean.TYPE, 1);
        CLASS_ENUM_ORDER.put(Character.TYPE, 2);
        CLASS_ENUM_ORDER.put(Byte.TYPE, 3);
        CLASS_ENUM_ORDER.put(Short.TYPE, 4);
        CLASS_ENUM_ORDER.put(Integer.TYPE, 5);
        CLASS_ENUM_ORDER.put(Long.TYPE, 6);
        CLASS_ENUM_ORDER.put(Float.TYPE, 7);
        CLASS_ENUM_ORDER.put(Double.TYPE, 8);
        CLASS_ENUM_ORDER.put(Boolean.class, 9);
        CLASS_ENUM_ORDER.put(Character.class, 10);
        CLASS_ENUM_ORDER.put(Byte.class, 11);
        CLASS_ENUM_ORDER.put(Short.class, 12);
        CLASS_ENUM_ORDER.put(Integer.class, 13);
        CLASS_ENUM_ORDER.put(Long.class, 14);
        CLASS_ENUM_ORDER.put(Float.class, 15);
        CLASS_ENUM_ORDER.put(Double.class, 16);
        CLASS_ENUM_ORDER.put(BigInteger.class, 17);
        CLASS_ENUM_ORDER.put(BigDecimal.class, 18);
        CLASS_ENUM_ORDER.put(Date.class, 19);
        CLASS_ENUM_ORDER.put(java.sql.Date.class, 20);
        CLASS_ENUM_ORDER.put(Time.class, 21);
        CLASS_ENUM_ORDER.put(Timestamp.class, 22);
        CLASS_ENUM_ORDER.put(Calendar.class, 23);
        CLASS_ENUM_ORDER.put(GregorianCalendar.class, 24);
        CLASS_ENUM_ORDER.put(XMLGregorianCalendar.class, 25);
        abstractPropClass = N.asSet(new Object[0]);
        abstractPropClass.add(Collection.class);
        abstractPropClass.add(List.class);
        abstractPropClass.add(Set.class);
        abstractPropClass.add(Queue.class);
        abstractPropClass.add(Map.class);
        registeredXMLBindingClassList = N.newConcurrentHashMap(1000);
        entityDeclaredPropGetMethodList = N.newConcurrentHashMap(1000);
        entityDeclaredPropSetMethodList = N.newConcurrentHashMap(1000);
        entityPropGetMethodPool = N.newConcurrentHashMap(1000);
        entityPropSetMethodPool = N.newConcurrentHashMap(1000);
        methodPropNamePool = N.newConcurrentHashMap(3000);
        methodTypeArgumentsPool = N.newConcurrentHashMap(3000);
        DUMMY_METHOD = N.getDeclaredMethod(N.class, "dummyMethod", new Class[0]);
        DUMMY_CLASS = DummyClass.class;
        DUMMY_CLASSES = new Class[]{DUMMY_CLASS};
        keyWords = N.newHashMap(100);
        keyWords.put("class", "clazz");
        formalizedPropNamePool = N.newConcurrentHashMap(3000);
        BUILT_IN_TYPE = N.newConcurrentHashMap(1000);
        BUILT_IN_TYPE.put(Boolean.TYPE.getCanonicalName(), Boolean.TYPE);
        BUILT_IN_TYPE.put(Character.TYPE.getCanonicalName(), Character.TYPE);
        BUILT_IN_TYPE.put(Byte.TYPE.getCanonicalName(), Byte.TYPE);
        BUILT_IN_TYPE.put(Short.TYPE.getCanonicalName(), Short.TYPE);
        BUILT_IN_TYPE.put(Integer.TYPE.getCanonicalName(), Integer.TYPE);
        BUILT_IN_TYPE.put(Long.TYPE.getCanonicalName(), Long.TYPE);
        BUILT_IN_TYPE.put(Float.TYPE.getCanonicalName(), Float.TYPE);
        BUILT_IN_TYPE.put(Double.TYPE.getCanonicalName(), Double.TYPE);
        BUILT_IN_TYPE.put(Boolean.TYPE.getSimpleName(), Boolean.TYPE);
        BUILT_IN_TYPE.put(Character.TYPE.getSimpleName(), Character.TYPE);
        BUILT_IN_TYPE.put(Byte.TYPE.getSimpleName(), Byte.TYPE);
        BUILT_IN_TYPE.put(Short.TYPE.getSimpleName(), Short.TYPE);
        BUILT_IN_TYPE.put(Integer.TYPE.getSimpleName(), Integer.TYPE);
        BUILT_IN_TYPE.put(Long.TYPE.getSimpleName(), Long.TYPE);
        BUILT_IN_TYPE.put(Float.TYPE.getSimpleName(), Float.TYPE);
        BUILT_IN_TYPE.put(Double.TYPE.getSimpleName(), Double.TYPE);
        BUILT_IN_TYPE.put(Boolean.class.getCanonicalName(), Boolean.class);
        BUILT_IN_TYPE.put(Character.class.getCanonicalName(), Character.class);
        BUILT_IN_TYPE.put(Byte.class.getCanonicalName(), Byte.class);
        BUILT_IN_TYPE.put(Short.class.getCanonicalName(), Short.class);
        BUILT_IN_TYPE.put(Integer.class.getCanonicalName(), Integer.class);
        BUILT_IN_TYPE.put(Long.class.getCanonicalName(), Long.class);
        BUILT_IN_TYPE.put(Float.class.getCanonicalName(), Float.class);
        BUILT_IN_TYPE.put(Double.class.getCanonicalName(), Double.class);
        BUILT_IN_TYPE.put(Boolean.class.getSimpleName(), Boolean.class);
        BUILT_IN_TYPE.put(Character.class.getSimpleName(), Character.class);
        BUILT_IN_TYPE.put(Byte.class.getSimpleName(), Byte.class);
        BUILT_IN_TYPE.put(Short.class.getSimpleName(), Short.class);
        BUILT_IN_TYPE.put(Integer.class.getSimpleName(), Integer.class);
        BUILT_IN_TYPE.put(Long.class.getSimpleName(), Long.class);
        BUILT_IN_TYPE.put(Float.class.getSimpleName(), Float.class);
        BUILT_IN_TYPE.put(Double.class.getSimpleName(), Double.class);
        BUILT_IN_TYPE.put(String.class.getCanonicalName(), String.class);
        BUILT_IN_TYPE.put(Object.class.getCanonicalName(), Object.class);
        BUILT_IN_TYPE.put(Class.class.getCanonicalName(), Class.class);
        BUILT_IN_TYPE.put(Enum.class.getCanonicalName(), Enum.class);
        BUILT_IN_TYPE.put(String.class.getSimpleName(), String.class);
        BUILT_IN_TYPE.put(Object.class.getSimpleName(), Object.class);
        BUILT_IN_TYPE.put(Class.class.getSimpleName(), Class.class);
        BUILT_IN_TYPE.put(Enum.class.getSimpleName(), Enum.class);
        BUILT_IN_TYPE.put(Date.class.getCanonicalName(), Date.class);
        BUILT_IN_TYPE.put(Calendar.class.getCanonicalName(), Calendar.class);
        BUILT_IN_TYPE.put(GregorianCalendar.class.getCanonicalName(), GregorianCalendar.class);
        BUILT_IN_TYPE.put(Collection.class.getCanonicalName(), Collection.class);
        BUILT_IN_TYPE.put(List.class.getCanonicalName(), List.class);
        BUILT_IN_TYPE.put(ArrayList.class.getCanonicalName(), ArrayList.class);
        BUILT_IN_TYPE.put(LinkedList.class.getCanonicalName(), LinkedList.class);
        BUILT_IN_TYPE.put(Set.class.getCanonicalName(), Set.class);
        BUILT_IN_TYPE.put(HashSet.class.getCanonicalName(), HashSet.class);
        BUILT_IN_TYPE.put(Map.class.getCanonicalName(), Map.class);
        BUILT_IN_TYPE.put(HashMap.class.getCanonicalName(), HashMap.class);
        BUILT_IN_TYPE.put(java.sql.Date.class.getCanonicalName(), java.sql.Date.class);
        BUILT_IN_TYPE.put(Time.class.getCanonicalName(), Time.class);
        BUILT_IN_TYPE.put(Timestamp.class.getCanonicalName(), Timestamp.class);
        BUILT_IN_TYPE.put(boolean[].class.getCanonicalName(), boolean[].class);
        BUILT_IN_TYPE.put(char[].class.getCanonicalName(), char[].class);
        BUILT_IN_TYPE.put(byte[].class.getCanonicalName(), byte[].class);
        BUILT_IN_TYPE.put(short[].class.getCanonicalName(), short[].class);
        BUILT_IN_TYPE.put(int[].class.getCanonicalName(), int[].class);
        BUILT_IN_TYPE.put(long[].class.getCanonicalName(), long[].class);
        BUILT_IN_TYPE.put(float[].class.getCanonicalName(), float[].class);
        BUILT_IN_TYPE.put(double[].class.getCanonicalName(), double[].class);
        BUILT_IN_TYPE.put(Boolean[].class.getCanonicalName(), Boolean[].class);
        BUILT_IN_TYPE.put(Character[].class.getCanonicalName(), Character[].class);
        BUILT_IN_TYPE.put(Byte[].class.getCanonicalName(), Byte[].class);
        BUILT_IN_TYPE.put(Short[].class.getCanonicalName(), Short[].class);
        BUILT_IN_TYPE.put(Integer[].class.getCanonicalName(), Integer[].class);
        BUILT_IN_TYPE.put(Long[].class.getCanonicalName(), Long[].class);
        BUILT_IN_TYPE.put(Float[].class.getCanonicalName(), Float[].class);
        BUILT_IN_TYPE.put(Double[].class.getCanonicalName(), Double[].class);
        BUILT_IN_TYPE.put(String[].class.getCanonicalName(), String[].class);
        BUILT_IN_TYPE.put(Object[].class.getCanonicalName(), Object[].class);
        BUILT_IN_TYPE.put(Class[].class.getCanonicalName(), Class[].class);
        BUILT_IN_TYPE.put(Enum[].class.getCanonicalName(), Enum[].class);
        BUILT_IN_TYPE.put(Date[].class.getCanonicalName(), Date[].class);
        BUILT_IN_TYPE.put(Calendar[].class.getCanonicalName(), Calendar[].class);
        BUILT_IN_TYPE.put(GregorianCalendar[].class.getCanonicalName(), GregorianCalendar[].class);
        BUILT_IN_TYPE.put(Collection[].class.getCanonicalName(), Collection[].class);
        BUILT_IN_TYPE.put(List[].class.getCanonicalName(), List[].class);
        BUILT_IN_TYPE.put(ArrayList[].class.getCanonicalName(), ArrayList[].class);
        BUILT_IN_TYPE.put(LinkedList[].class.getCanonicalName(), LinkedList[].class);
        BUILT_IN_TYPE.put(Set[].class.getCanonicalName(), Set[].class);
        BUILT_IN_TYPE.put(HashSet[].class.getCanonicalName(), HashSet[].class);
        BUILT_IN_TYPE.put(Map[].class.getCanonicalName(), Map[].class);
        BUILT_IN_TYPE.put(HashMap[].class.getCanonicalName(), HashMap[].class);
        BUILT_IN_TYPE.put(java.sql.Date[].class.getCanonicalName(), java.sql.Date[].class);
        BUILT_IN_TYPE.put(Time[].class.getCanonicalName(), Time[].class);
        BUILT_IN_TYPE.put(Timestamp[].class.getCanonicalName(), Timestamp[].class);
        BUILT_IN_TYPE.put(boolean[][].class.getCanonicalName(), boolean[][].class);
        BUILT_IN_TYPE.put(char[][].class.getCanonicalName(), char[][].class);
        BUILT_IN_TYPE.put(byte[][].class.getCanonicalName(), byte[][].class);
        BUILT_IN_TYPE.put(short[][].class.getCanonicalName(), short[][].class);
        BUILT_IN_TYPE.put(int[][].class.getCanonicalName(), int[][].class);
        BUILT_IN_TYPE.put(long[][].class.getCanonicalName(), long[][].class);
        BUILT_IN_TYPE.put(float[][].class.getCanonicalName(), float[][].class);
        BUILT_IN_TYPE.put(double[][].class.getCanonicalName(), double[][].class);
        BUILT_IN_TYPE.put(Boolean[][].class.getCanonicalName(), Boolean[][].class);
        BUILT_IN_TYPE.put(Character[][].class.getCanonicalName(), Character[][].class);
        BUILT_IN_TYPE.put(Byte[][].class.getCanonicalName(), Byte[][].class);
        BUILT_IN_TYPE.put(Short[][].class.getCanonicalName(), Short[][].class);
        BUILT_IN_TYPE.put(Integer[][].class.getCanonicalName(), Integer[][].class);
        BUILT_IN_TYPE.put(Long[][].class.getCanonicalName(), Long[][].class);
        BUILT_IN_TYPE.put(Float[][].class.getCanonicalName(), Float[][].class);
        BUILT_IN_TYPE.put(Double[][].class.getCanonicalName(), Double[][].class);
        BUILT_IN_TYPE.put(String[][].class.getCanonicalName(), String[][].class);
        BUILT_IN_TYPE.put(Object[][].class.getCanonicalName(), Object[][].class);
        BUILT_IN_TYPE.put(Class[][].class.getCanonicalName(), Class[][].class);
        BUILT_IN_TYPE.put(Enum[][].class.getCanonicalName(), Enum[][].class);
        BUILT_IN_TYPE.put(Date[][].class.getCanonicalName(), Date[][].class);
        BUILT_IN_TYPE.put(Calendar[][].class.getCanonicalName(), Calendar[][].class);
        BUILT_IN_TYPE.put(GregorianCalendar[][].class.getCanonicalName(), GregorianCalendar[][].class);
        BUILT_IN_TYPE.put(Collection[][].class.getCanonicalName(), Collection[][].class);
        BUILT_IN_TYPE.put(List[][].class.getCanonicalName(), List[][].class);
        BUILT_IN_TYPE.put(ArrayList[][].class.getCanonicalName(), ArrayList[][].class);
        BUILT_IN_TYPE.put(LinkedList[][].class.getCanonicalName(), LinkedList[][].class);
        BUILT_IN_TYPE.put(Set[][].class.getCanonicalName(), Set[][].class);
        BUILT_IN_TYPE.put(HashSet[][].class.getCanonicalName(), HashSet[][].class);
        BUILT_IN_TYPE.put(Map[][].class.getCanonicalName(), Map[][].class);
        BUILT_IN_TYPE.put(HashMap[][].class.getCanonicalName(), HashMap[][].class);
        BUILT_IN_TYPE.put(java.sql.Date[][].class.getCanonicalName(), java.sql.Date[][].class);
        BUILT_IN_TYPE.put(Time[][].class.getCanonicalName(), Time[][].class);
        BUILT_IN_TYPE.put(Timestamp[][].class.getCanonicalName(), Timestamp[][].class);
        SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME = N.asMap(new Object[0]);
        SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.put(Boolean.TYPE.getName(), "Z");
        SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.put(Character.TYPE.getName(), "C");
        SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.put(Byte.TYPE.getName(), "B");
        SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.put(Short.TYPE.getName(), "S");
        SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.put(Integer.TYPE.getName(), "I");
        SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.put(Long.TYPE.getName(), "J");
        SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.put(Float.TYPE.getName(), "F");
        SYMBOL_OF_PRIMARY_ARRAY_CLASS_NAME.put(Double.TYPE.getName(), "D");
        clsParserTypePool = N.newConcurrentHashMap(3000);
        clsNamePool = N.newConcurrentHashMap(3000);
        simpleNameClassPool = N.newConcurrentHashMap(3000);
        nameClassPool = N.newConcurrentHashMap(3000);
        canonicalNameClassPool = N.newConcurrentHashMap(3000);
        enclosingClassPool = N.newConcurrentHashMap(3000);
        executorService = Executors.newFixedThreadPool(64);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                executorService.shutdown();
                try {
                    executorService.awaitTermination(180L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    logger.warning("failed to commit task in the queue in N.class due to error: " + e.getMessage());
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ClazzParserType {
        ARRAY,
        COLLECTION,
        MAP,
        ENTITY,
        SINGLE_VALUE;

    }

    private static final class DummyClass {
        private DummyClass() {
        }
    }
}

