/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.util;

import com.google.gson.util.BufferedReader;
import com.google.gson.util.BufferedWriter;
import com.google.gson.util.N;
import com.google.gson.util.ObjectFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOUtil {
    private static final String ZIP = ".zip";
    private static final String GZ = ".gz";
    private static final int BUFFER_SIZE = 1024;
    static final char[] _2147483648_CHAR_ARRAY = "-2147483648".toCharArray();
    static final char[] _9223372036854775808_CHAR_ARRAY = "-9223372036854775808".toCharArray();
    static final int maxCBufIntValue;
    static final char[][] cbufOfInt;

    private IOUtil() {
    }

    public static String readString(File file) {
        String string;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            string = IOUtil.readString(reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close(reader);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(InputStream is) {
        InputStreamReader reader = null;
        reader = new InputStreamReader(is);
        String string = IOUtil.readString(reader);
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readString(Reader reader) {
        String string;
        char[] cbuf;
        StringBuilder sb;
        block11: {
            String string2;
            block10: {
                sb = null;
                cbuf = ObjectFactory.createCharArrayBuffer();
                int len = cbuf.length;
                try {
                    int count = reader.read(cbuf);
                    if (count == -1 || count == 0) {
                        String string3 = "";
                        return string3;
                    }
                    if (count < len) {
                        string2 = String.valueOf(cbuf, 0, count);
                        ObjectFactory.recycle(cbuf);
                        break block10;
                    }
                    sb = ObjectFactory.createStringBuilder(16384);
                    sb.append(cbuf);
                    while ((count = reader.read(cbuf)) > 0) {
                        sb.append(cbuf, 0, count);
                        if (count >= len) continue;
                    }
                    string = sb.toString();
                    ObjectFactory.recycle(cbuf);
                    break block11;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ObjectFactory.recycle(sb);
            return string2;
        }
        ObjectFactory.recycle(sb);
        return string;
        finally {
            ObjectFactory.recycle(cbuf);
            ObjectFactory.recycle(sb);
        }
    }

    public static char[] readChars(File file) {
        char[] cArray;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            cArray = IOUtil.readChars(reader);
        }
        catch (FileNotFoundException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close(reader);
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readChars(InputStream is) {
        InputStreamReader reader = null;
        reader = new InputStreamReader(is);
        char[] cArray = IOUtil.readChars(reader);
        return cArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] readChars(Reader reader) {
        char[] cArray;
        char[] cbuf;
        StringBuilder sb;
        block11: {
            char[] cArray2;
            block10: {
                sb = null;
                cbuf = ObjectFactory.createCharArrayBuffer();
                int len = cbuf.length;
                try {
                    int count = reader.read(cbuf);
                    if (count == -1 || count == 0) {
                        char[] cArray3 = new char[]{};
                        return cArray3;
                    }
                    if (count < len) {
                        cArray2 = Arrays.copyOf(cbuf, count);
                        ObjectFactory.recycle(cbuf);
                        break block10;
                    }
                    sb = ObjectFactory.createStringBuilder(16384);
                    sb.append(cbuf);
                    while ((count = reader.read(cbuf)) > 0) {
                        sb.append(cbuf, 0, count);
                        if (count >= len) continue;
                    }
                    char[] chars = new char[sb.length()];
                    sb.getChars(0, sb.length(), chars, 0);
                    cArray = chars;
                    ObjectFactory.recycle(cbuf);
                    break block11;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ObjectFactory.recycle(sb);
            return cArray2;
        }
        ObjectFactory.recycle(sb);
        return cArray;
        finally {
            ObjectFactory.recycle(cbuf);
            ObjectFactory.recycle(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file) {
        InputStream is = IOUtil.createInputStream(file);
        try {
            List<String> list = IOUtil.readLines(is);
            return list;
        }
        finally {
            IOUtil.close(is);
        }
    }

    public static List<String> readLines(InputStream is) {
        return IOUtil.readLines(new InputStreamReader(is));
    }

    public static List<String> readLines(Reader reader) {
        List<Object> lines = N.asList(new Object[0]);
        BufferedReader br = ObjectFactory.createBufferedReader(reader);
        try {
            String line = br.readLine();
            while (line != null) {
                lines.add(line);
                line = br.readLine();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            ObjectFactory.recycle(br);
        }
        return lines;
    }

    public static byte[] readBytes(File file) {
        byte[] bytes = new byte[(int)file.length()];
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            ((InputStream)is).read(bytes);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
        }
        IOUtil.close(is);
        return bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(InputStream is) {
        byte[] byArray;
        byte[] bytes;
        ByteArrayOutputStream os;
        block11: {
            byte[] byArray2;
            block10: {
                os = null;
                bytes = ObjectFactory.createByteArrayBuffer();
                int len = bytes.length;
                try {
                    int count = is.read(bytes);
                    if (count == -1) {
                        byte[] byArray3 = new byte[]{};
                        return byArray3;
                    }
                    if (count < len) {
                        byArray2 = Arrays.copyOf(bytes, count);
                        ObjectFactory.recycle(bytes);
                        break block10;
                    }
                    os = ObjectFactory.createByteArrayOutputStream(16384);
                    os.write(bytes);
                    while ((count = is.read(bytes)) > 0) {
                        os.write(bytes, 0, count);
                        if (count >= len) continue;
                    }
                    byArray = os.toByteArray();
                    ObjectFactory.recycle(bytes);
                    break block11;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ObjectFactory.recycle(os);
            return byArray2;
        }
        ObjectFactory.recycle(os);
        return byArray;
        finally {
            ObjectFactory.recycle(bytes);
            ObjectFactory.recycle(os);
        }
    }

    public static void writeInt(Writer writer, int i) throws IOException {
        if (i < maxCBufIntValue) {
            if (i < 0) {
                if (i == Integer.MIN_VALUE) {
                    writer.write(_2147483648_CHAR_ARRAY);
                    return;
                }
                if (-i < maxCBufIntValue) {
                    writer.write(45);
                    writer.write(cbufOfInt[-i]);
                    return;
                }
            } else {
                writer.write(cbufOfInt[i]);
                return;
            }
        }
        writer.write(String.valueOf(i));
    }

    public static void writeLong(Writer writer, long l) throws IOException {
        if (l < (long)maxCBufIntValue) {
            if (l < 0L) {
                if (l == Long.MIN_VALUE) {
                    writer.write(_9223372036854775808_CHAR_ARRAY);
                    return;
                }
                if (-l < (long)maxCBufIntValue) {
                    writer.write(45);
                    writer.write(cbufOfInt[(int)(-l)]);
                    return;
                }
            } else {
                writer.write(cbufOfInt[(int)l]);
                return;
            }
        }
        writer.write(String.valueOf(l));
    }

    public static void writeString(String st, File out) {
        IOUtil.writeChars(st.toCharArray(), out);
    }

    public static void writeString(String st, OutputStream out) {
        IOUtil.writeChars(st.toCharArray(), out);
    }

    public static void writeString(String st, Writer out) {
        IOUtil.writeChars(st.toCharArray(), out);
    }

    public static void writeChars(char[] chars, File out) {
        FileWriter writer = null;
        try {
            if (out.exists()) {
                out.createNewFile();
            }
            writer = new FileWriter(out);
            IOUtil.writeChars(chars, writer);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeChars(char[] chars, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        IOUtil.writeChars(chars, writer);
    }

    public static void writeChars(char[] chars, Writer out) {
        try {
            out.write(chars);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBytes(byte[] bytes, File out) {
        OutputStream os = null;
        try {
            if (out.exists()) {
                out.createNewFile();
            }
            IOUtil.writeBytes(bytes, os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.close(os);
        }
    }

    public static void writeBytes(byte[] bytes, OutputStream out) {
        try {
            out.write(bytes);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream createInputStream(File file) {
        InputStream is = null;
        try {
            is = new FileInputStream(file);
            if (file.getName().endsWith(GZ)) {
                is = new GZIPInputStream(is);
            } else if (file.getName().endsWith(ZIP)) {
                ZipFile zf = new ZipFile(file);
                ZipEntry ze = zf.entries().nextElement();
                is = zf.getInputStream(ze);
            }
        }
        catch (IOException e) {
            IOUtil.close(is);
            throw new RuntimeException(e);
        }
        return is;
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void close(Writer write) {
        if (write != null) {
            try {
                write.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void close(ZipFile zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void zip(File sourceFile, File targetFile, boolean deleteTargetFileIfExists) {
        if (targetFile.exists() && deleteTargetFileIfExists) {
            targetFile.delete();
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(targetFile));
            IOUtil.zipDir(sourceFile, zos, targetFile);
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(zos);
                throw throwable;
            }
        }
        IOUtil.close(zos);
    }

    public static void unzip(File sourceZipFile, File targetFile) {
        ZipFile zip = null;
        ZipEntry ze = null;
        BufferedOutputStream os = null;
        BufferedInputStream is = null;
        try {
            zip = new ZipFile(sourceZipFile);
            byte[] buf = new byte[1024];
            Enumeration<? extends ZipEntry> entryEnum = zip.entries();
            while (entryEnum.hasMoreElements()) {
                ze = entryEnum.nextElement();
                if (ze.isDirectory()) continue;
                os = new BufferedOutputStream(new FileOutputStream(IOUtil.getAbsolutePath(targetFile, ze.getName())));
                is = new BufferedInputStream(zip.getInputStream(ze));
                int readLen = ((InputStream)is).read(buf, 0, 1024);
                while (readLen != -1) {
                    ((OutputStream)os).write(buf, 0, readLen);
                    readLen = ((InputStream)is).read(buf, 0, 1024);
                }
                IOUtil.close(is);
                is = null;
                IOUtil.close(os);
                os = null;
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtil.close(zip);
                IOUtil.close(is);
                IOUtil.close(os);
                throw throwable;
            }
        }
        IOUtil.close(zip);
        IOUtil.close(is);
        IOUtil.close(os);
    }

    public static void deleteDir(File file) {
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                IOUtil.deleteDir(new File(file, children[i]));
            }
        }
        file.delete();
    }

    public static void splitFile(File file, int lineNum) {
        InputStream is = IOUtil.createInputStream(file);
        BufferedReader br = ObjectFactory.createBufferedReader(is);
        BufferedWriter bw = null;
        int lineCounter = 0;
        String line = null;
        try {
            line = br.readLine();
            while (line != null) {
                if (lineCounter % lineNum == 0) {
                    if (bw != null) {
                        bw.flush();
                        bw.close();
                        ObjectFactory.recycle(bw);
                        bw = null;
                    }
                    bw = ObjectFactory.createBufferedWriter(new FileWriter(new File(file.getAbsolutePath() + "_" + lineCounter / lineNum + ".txt")));
                }
                bw.write(line);
                bw.write((byte)13);
                ++lineCounter;
                line = br.readLine();
            }
            if (bw != null) {
                bw.flush();
                bw.close();
                ObjectFactory.recycle(bw);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.close(is);
            ObjectFactory.recycle(br);
        }
    }

    private static void zipDir(File sourceFile, ZipOutputStream zos, File zipFile) throws IOException, FileNotFoundException {
        if (sourceFile.isFile()) {
            IOUtil.zipFile(sourceFile, null, zos, zipFile);
        } else {
            List<File> subFileList = IOUtil.getSubFiles(sourceFile, true);
            for (int i = 0; i < subFileList.size(); ++i) {
                File subFile = subFileList.get(i);
                IOUtil.zipFile(subFile, sourceFile, zos, zipFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(File file, File sourceDir, ZipOutputStream zos, File zipFile) throws IOException, FileNotFoundException {
        if (file.equals(zipFile)) {
            return;
        }
        byte[] buf = new byte[1024];
        ZipEntry ze = null;
        String relativeFileName = null;
        relativeFileName = sourceDir == null ? file.getName() : IOUtil.getRelativePath(sourceDir, file);
        ze = new ZipEntry(relativeFileName);
        ze.setSize(file.length());
        ze.setTime(file.lastModified());
        zos.putNextEntry(ze);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        try {
            int readLen = ((InputStream)is).read(buf, 0, 1024);
            while (readLen != -1) {
                zos.write(buf, 0, readLen);
                readLen = ((InputStream)is).read(buf, 0, 1024);
            }
        }
        finally {
            IOUtil.close(is);
        }
    }

    private static List<File> getSubFiles(File baseDir, boolean isRecersive) {
        ArrayList<File> result = new ArrayList<File>();
        if (baseDir.isFile()) {
            result.add(baseDir);
        } else {
            File[] subFiles = baseDir.listFiles();
            for (int i = 0; i < subFiles.length; ++i) {
                if (subFiles[i].isFile()) {
                    result.add(subFiles[i]);
                }
                if (!subFiles[i].isDirectory()) continue;
                result.addAll(IOUtil.getSubFiles(subFiles[i], isRecersive));
            }
        }
        return result;
    }

    private static String getAbsolutePath(File parentDir, String relativeFilePath) throws IOException {
        String newRelativePath = "";
        for (int i = 0; i < relativeFilePath.length(); ++i) {
            char c = relativeFilePath.charAt(i);
            newRelativePath = c == '\\' || c == '/' ? newRelativePath + File.separator : newRelativePath + c;
        }
        relativeFilePath = newRelativePath;
        String path = parentDir.getAbsolutePath() + File.separator + relativeFilePath;
        File dir = new File(path.substring(0, path.lastIndexOf(File.separator)));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return path;
    }

    private static String getRelativePath(File parentDir, File file) {
        if (file.equals(parentDir)) {
            return file.getName();
        }
        return file.getAbsolutePath().substring(parentDir.getAbsolutePath().length() + 1);
    }

    static {
        int temp = (int)(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() / 1000000000L * 100000L);
        maxCBufIntValue = (temp < 32768 ? 32768 : temp) + 1;
        int len = maxCBufIntValue + 1;
        cbufOfInt = new char[len][];
        for (int i = 0; i < len; ++i) {
            IOUtil.cbufOfInt[i] = String.valueOf(i).toCharArray();
        }
    }
}

