/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CalendarUnit {
    MILLISECOND(14),
    SECOND(13),
    MINUTE(12),
    HOUR(11),
    DAY(5),
    WEEK(3),
    MONTH(2),
    YEAR(1);

    private static Map<Integer, CalendarUnit> m;
    private int intValue;

    private CalendarUnit(int intValue) {
        this.intValue = intValue;
    }

    public static CalendarUnit valueOf(int intValue) {
        CalendarUnit result = m.get(intValue);
        if (result == null) {
            throw new IllegalArgumentException("No defined CalendarUnit mapping to value: " + intValue);
        }
        return result;
    }

    public int intValue() {
        return this.intValue;
    }

    public long toMillis(int amount) {
        switch (this) {
            case MILLISECOND: {
                return amount;
            }
            case SECOND: {
                return (long)amount * 1000L;
            }
            case MINUTE: {
                return (long)amount * 1000L * 60L;
            }
            case HOUR: {
                return (long)amount * 1000L * 60L * 60L;
            }
            case DAY: {
                return (long)amount * 1000L * 60L * 60L * 24L;
            }
            case WEEK: {
                return (long)amount * 1000L * 60L * 60L * 24L * 7L;
            }
        }
        throw new RuntimeException("Unsupported unit: " + (Object)((Object)this));
    }

    static {
        m = new HashMap<Integer, CalendarUnit>();
        for (CalendarUnit value : CalendarUnit.values()) {
            m.put(value.intValue, value);
        }
    }
}

