/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.util;

import com.google.gson.util.IOUtil;
import com.google.gson.util.N;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

public class BufferedWriter
extends Writer {
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final int DEFAULT_ARRAY_SIZE = 8192;
    protected static final List<char[]> bufferPool = N.newArrayList(100);
    protected static final List<char[]> arrayPool = N.newArrayList(100);
    protected char[] cArray;
    protected char[] cbuff;
    protected int nextChar = 0;
    protected Writer out;
    protected StringBuilder sb;
    private boolean isStringBuilderRecycable = false;

    public BufferedWriter(StringBuilder sb) {
        this.out = null;
        this.sb = sb;
        this.lock = sb;
    }

    public BufferedWriter(OutputStream os) {
        this(new OutputStreamWriter(os, N.UTF_8));
    }

    public BufferedWriter(Writer writer) {
        this.sb = null;
        this.out = writer;
        this.lock = writer;
    }

    public void write(char c) throws IOException {
        if (this.nextChar >= 8192) {
            this.flushBuffer();
        }
        if (this.cbuff == null) {
            this.cbuff = this.createBuffer();
        }
        this.cbuff[this.nextChar++] = c;
    }

    public void write(boolean b) throws IOException {
        this.write(b ? N.TRUE_CHAR_ARRAY : N.FALSE_CHAR_ARRAY);
    }

    public void write(byte b) throws IOException {
        if (b < 0) {
            this.write(IOUtil.cbufOfInt[-b]);
        } else {
            this.write(IOUtil.cbufOfInt[b]);
        }
    }

    public void write(short s) throws IOException {
        if (s < 0) {
            this.write(IOUtil.cbufOfInt[-s]);
        } else {
            this.write(IOUtil.cbufOfInt[s]);
        }
    }

    public void write(int ch) throws IOException {
        this.write((char)ch);
    }

    public void writeInt(int i) throws IOException {
        if (i < IOUtil.maxCBufIntValue) {
            if (i < 0) {
                if (i == Integer.MIN_VALUE) {
                    this.write(IOUtil._2147483648_CHAR_ARRAY);
                    return;
                }
                if (-i < IOUtil.maxCBufIntValue) {
                    this.write('-');
                    this.write(IOUtil.cbufOfInt[-i]);
                    return;
                }
            } else {
                this.write(IOUtil.cbufOfInt[i]);
                return;
            }
        }
        this.write(String.valueOf(i));
    }

    public void write(long l) throws IOException {
        if (l < (long)IOUtil.maxCBufIntValue) {
            if (l < 0L) {
                if (l == Long.MIN_VALUE) {
                    this.write(IOUtil._9223372036854775808_CHAR_ARRAY);
                    return;
                }
                if (-l < (long)IOUtil.maxCBufIntValue) {
                    this.write('-');
                    this.write(IOUtil.cbufOfInt[(int)(-l)]);
                    return;
                }
            } else {
                this.write(IOUtil.cbufOfInt[(int)l]);
                return;
            }
        }
        this.write(String.valueOf(l));
    }

    public void write(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public void write(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public void write(Date date) throws IOException {
        N.format(date, null, null, (Writer)this);
    }

    public void write(Calendar c) throws IOException {
        N.format(c, null, null, (Writer)this);
    }

    public void write(XMLGregorianCalendar c) throws IOException {
        N.format(c, null, null, (Writer)this);
    }

    public void write(String st) throws IOException {
        if (st == null) {
            this.write(N.NULL_CHAR_ARRAY);
        } else {
            this.write(st, 0, st.length());
        }
    }

    public void write(String st, int off, int len) throws IOException {
        if (st == null) {
            this.write(N.NULL_CHAR_ARRAY, off, len);
            return;
        }
        if (len > 8192) {
            char[] cbuf = new char[len];
            st.getChars(off, off + len, cbuf, 0);
            this.write(cbuf, 0, len);
        } else {
            if (len > 8192 - this.nextChar) {
                this.flushBuffer();
            }
            if (this.cbuff == null) {
                this.cbuff = this.createBuffer();
            }
            st.getChars(off, off + len, this.cbuff, this.nextChar);
            this.nextChar += len;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 8192 - this.nextChar) {
            if (this.nextChar > 0) {
                this.flushBuffer();
            }
            this.doWrite(cbuf, off, len);
        } else {
            if (this.cbuff == null) {
                this.cbuff = this.createBuffer();
            }
            System.arraycopy(cbuf, off, this.cbuff, this.nextChar, len);
            this.nextChar += len;
        }
    }

    protected void doWrite(char[] cbuf, int off, int len) throws IOException {
        if (this.sb == null) {
            this.out.write(cbuf, off, len);
        } else {
            this.sb.append(cbuf, off, len);
        }
    }

    public void newLine() throws IOException {
        this.write(N.LINE_SEPARATOR);
    }

    public Writer append(CharSequence csq) throws IOException {
        return super.append(csq);
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return super.append(csq, start, end);
    }

    public Writer append(char c) throws IOException {
        return super.append(c);
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.recycleBuffer(this.cbuff);
        this.cbuff = null;
        this.nextChar = 0;
        this.recycleCharArray(this.cArray);
        this.cArray = null;
        if (this.out != null) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.sb != null || this.out != null) {
                this.flushBuffer();
            }
        }
        finally {
            this.recycleBuffer(this.cbuff);
            this.cbuff = null;
            this.nextChar = 0;
            this.recycleCharArray(this.cArray);
            this.cArray = null;
            this.sb = null;
            IOUtil.close(this.out);
        }
    }

    public String toString() {
        if (this.sb == null || this.sb.length() == 0) {
            if (this.out == null) {
                return this.nextChar == 0 ? "" : String.valueOf(this.cbuff, 0, this.nextChar);
            }
            try {
                this.flushBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this.out.toString();
        }
        try {
            this.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.sb.toString();
    }

    boolean isStringBuilderRecycable() {
        return this.isStringBuilderRecycable;
    }

    void setStringBuilderRecycable(boolean isStringBuilderRecycable) {
        this.isStringBuilderRecycable = isStringBuilderRecycable;
    }

    StringBuilder getStringBuilder() {
        return this.sb;
    }

    void setStringBuilder(StringBuilder sb) {
        this.sb = sb;
        this.lock = sb;
    }

    void setWriter(OutputStream os) {
        this.setWriter(new OutputStreamWriter(os));
    }

    void setWriter(Writer writer) {
        this.out = writer;
        this.lock = writer;
    }

    void _reset() {
        this.recycleBuffer(this.cbuff);
        this.cbuff = null;
        this.nextChar = 0;
        this.recycleCharArray(this.cArray);
        this.cArray = null;
        this.sb = null;
        this.out = null;
        this.isStringBuilderRecycable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] createBuffer() {
        List<char[]> list = bufferPool;
        synchronized (list) {
            return bufferPool.size() == 0 ? new char[8192] : bufferPool.remove(bufferPool.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleBuffer(char[] cbuff) {
        if (cbuff != null && cbuff.length == 8192) {
            List<char[]> list = bufferPool;
            synchronized (list) {
                bufferPool.add(cbuff);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] createCharArray() {
        List<char[]> list = arrayPool;
        synchronized (list) {
            return arrayPool.size() == 0 ? new char[8192] : arrayPool.remove(arrayPool.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleCharArray(char[] cArray) {
        if (cArray != null && cArray.length == 8192) {
            List<char[]> list = arrayPool;
            synchronized (list) {
                arrayPool.add(cArray);
            }
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.nextChar == 0) {
            return;
        }
        this.doWrite(this.cbuff, 0, this.nextChar);
        this.nextChar = 0;
    }

    protected void writeHex(int ch) throws IOException {
        this.write("&#x");
        this.write(Integer.toHexString(ch));
        this.write(';');
    }
}

