/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.util;

import com.google.gson.util.N;
import com.google.gson.util.ObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class BufferedReader
extends Reader {
    protected static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final List<char[]> bufferPool = N.newArrayList(100);
    protected char[] cbuff;
    protected int nChars = 0;
    protected int nextChar = 0;
    protected boolean skipLF = false;
    protected Reader in;

    public BufferedReader(String st) {
        this(new StringReader(st));
    }

    public BufferedReader(InputStream is) {
        this(new InputStreamReader(is, N.UTF_8));
    }

    public BufferedReader(Reader reader) {
        this.in = reader;
        this.lock = reader;
    }

    public int read() throws IOException {
        while (true) {
            if (this.nextChar >= this.nChars) {
                this.fill();
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
            if (!this.skipLF) break;
            this.skipLF = false;
            if (this.cbuff[this.nextChar] != '\n') break;
            ++this.nextChar;
        }
        return this.cbuff[this.nextChar++];
    }

    private int read1(char[] cbuf, int off, int len) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (len >= 8192 && !this.skipLF) {
                return this.in.read(cbuf, off, len);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.cbuff[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n = Math.min(len, this.nChars - this.nextChar);
        System.arraycopy(this.cbuff, this.nextChar, cbuf, off, n);
        this.nextChar += n;
        return n;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int n1;
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = this.read1(cbuf, off, len);
        if (n <= 0) {
            return n;
        }
        while (n < len && this.in.ready() && (n1 = this.read1(cbuf, off + n, len - n)) > 0) {
            n += n1;
        }
        return n;
    }

    String readLine(boolean ignoreLF) throws IOException {
        boolean omitLF;
        StringBuilder sb = null;
        boolean bl = omitLF = ignoreLF || this.skipLF;
        while (true) {
            int i;
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                if (sb != null && sb.length() > 0) {
                    return sb.toString();
                }
                return null;
            }
            boolean eol = false;
            char c = '\u0000';
            if (!omitLF || this.cbuff[this.nextChar] == '\n') {
                // empty if block
            }
            this.skipLF = false;
            omitLF = false;
            for (i = ++this.nextChar; i < this.nChars; ++i) {
                c = this.cbuff[i];
                if (c != '\n' && c != '\r') continue;
                eol = true;
                break;
            }
            int startChar = this.nextChar;
            this.nextChar = i;
            if (eol) {
                String str;
                if (sb == null) {
                    str = new String(this.cbuff, startChar, i - startChar);
                } else {
                    sb.append(this.cbuff, startChar, i - startChar);
                    str = sb.toString();
                }
                ++this.nextChar;
                if (c == '\r') {
                    this.skipLF = true;
                }
                ObjectFactory.recycle(sb);
                return str;
            }
            if (sb == null) {
                sb = ObjectFactory.createStringBuilder();
            }
            sb.append(this.cbuff, startChar, i - startChar);
        }
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    public long skip(long n) throws IOException {
        long r;
        long d;
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        for (r = n; r > 0L; r -= d) {
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) break;
            if (this.skipLF) {
                this.skipLF = false;
                if (this.cbuff[this.nextChar] == '\n') {
                    ++this.nextChar;
                }
            }
            if (r <= (d = (long)(this.nChars - this.nextChar))) {
                this.nextChar = (int)((long)this.nextChar + r);
                r = 0L;
                break;
            }
            this.nextChar = this.nChars;
        }
        return n - r;
    }

    public boolean ready() throws IOException {
        if (this.skipLF) {
            if (this.nextChar >= this.nChars && this.in.ready()) {
                this.fill();
            }
            if (this.nextChar < this.nChars) {
                if (this.cbuff[this.nextChar] == '\n') {
                    ++this.nextChar;
                }
                this.skipLF = false;
            }
        }
        return this.nextChar < this.nChars || this.in.ready();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        finally {
            this._reset();
        }
    }

    void setReader(Reader reader) {
        this.in = reader;
        this.lock = reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _reset() {
        Object object = this.lock;
        synchronized (object) {
            this.recycleBuffer(this.cbuff);
            this.cbuff = null;
            this.nextChar = 0;
            this.nChars = 0;
            this.skipLF = false;
            this.in = null;
        }
    }

    protected void fill() throws IOException {
        int len;
        if (this.cbuff == null) {
            this.cbuff = this.createBuffer();
        }
        if ((len = this.nChars - this.nextChar) > 0) {
            System.arraycopy(this.cbuff, this.nextChar, this.cbuff, 0, len);
        }
        this.nextChar = 0;
        this.nChars = len;
        int n = this.in.read(this.cbuff, len, this.cbuff.length - len);
        if (n > 0) {
            this.nChars += n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected char[] createBuffer() {
        List<char[]> list = bufferPool;
        synchronized (list) {
            return bufferPool.size() == 0 ? new char[8192] : bufferPool.remove(bufferPool.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleBuffer(char[] cbuff) {
        if (cbuff != null && cbuff.length == 8192) {
            List<char[]> list = bufferPool;
            synchronized (list) {
                bufferPool.add(cbuff);
            }
        }
    }
}

