/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.util.N;
import java.lang.reflect.Field;
import java.util.Map;

public interface FieldBindingStrategy {
    public static final FieldBindingStrategy GET_METHOD = new FieldBindingStrategy(){

        public boolean matches(Field field) {
            return N.getPropGetMethod(field.getDeclaringClass(), field.getName()) != null;
        }
    };

    public boolean matches(Field var1);

    public static class FieldModifier
    implements FieldBindingStrategy {
        private static final Map<Integer, FieldModifier> pool = N.asConcurrentHashMap(new Object[0]);
        private final int mod;

        public FieldModifier(int mod) {
            this.mod = mod;
        }

        public static FieldModifier valueOf(int mod) {
            FieldModifier result = pool.get(mod);
            if (result == null) {
                result = new FieldModifier(mod);
                pool.put(mod, result);
            }
            return result;
        }

        public boolean matches(Field field) {
            return (this.mod & field.getModifiers()) != 0;
        }
    }
}

