package view;

import java.awt.BorderLayout;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;


public class ProclamaVincitoriFrame extends JFrame {
  private JList listaVincitori;
  private JTable tabellaCiclisti;
  private JTabbedPane tabPnl = new JTabbedPane();

  public ProclamaVincitoriFrame(final Vector<String> vincitori,
      final Vector<Map.Entry<String, Float>> linkPartecipanti) {
    super("Riassunto della gara e vincitori");
    Runnable target = new Runnable() {
      
      @Override
      public void run() {
        listaVincitori = popolaListaVincitori(vincitori);
        tabellaCiclisti = popolaTabellaClassifica(linkPartecipanti);
        getContentPane().add(tabPnl, BorderLayout.CENTER);
        tabPnl.add("Tabella dei ciclisti", new JScrollPane(tabellaCiclisti));
        tabPnl.add("Lista dei vincitori", new JScrollPane(listaVincitori));
        pack();
        setLocationRelativeTo(null);
        setVisible(true);
      }
    };
    SwingUtilities.invokeLater(target);
  }

  private JTable popolaTabellaClassifica(Vector<Map.Entry<String, Float>> linkPartecipanti) {
    String[][] tabella = new String[linkPartecipanti.size()][2];
    int riga = 0;
    for (Map.Entry<String, Float> l : linkPartecipanti) {
      tabella[riga][0] = l.getKey();
      tabella[riga++][1] = l.getValue() + "";
    }
    String[] intestazioni = { "Nome Ciclista", "Km percorsi" };
    return new JTable(tabella, intestazioni);
  }

  private JList popolaListaVincitori(Vector<String> vincitori) {
        return new JList(vincitori);
  }

}
