package view;

import java.awt.*;
import java.util.*;


class Percorso extends DrawPanel {// non pubblica perch� ad uso interno del
                                  // package
  private final int LARGHEZZA = 800; // larghezza in pixel del percorso
  private final int ALTEZZA = 40; // altezza di ciascuna corsia in pixel
  private final int SPESSORE_LINEA = 3;
  private final int MARGINE = 10;
  private final int MARGINE_NOMI = 100;
  private final String SEGNALINO = "O";
  private HashMap<Integer, Text> posizione; // per memorizzare la posizione dei
                                             // ciclisti lungo il percorso
  
  private Map<Integer, String> mapNames;
  private float distanzaGara;
  private int altezzaTotale = 0;

  public Percorso(float distanzaGara, Map<Integer, String> mapNames) {
    this.mapNames = mapNames;
	this.distanzaGara = distanzaGara;
    posizione = new HashMap<Integer, Text>();
    
    // Inizializza la mappa ed i segnalini dei ciclisti
    int i = 1;
    for (Map.Entry<Integer, String> e: mapNames.entrySet()) {
      addFigureBatch(new Text(e.getValue(), new Point(MARGINE,
          MARGINE + SPESSORE_LINEA + ALTEZZA * i - ALTEZZA / 2)));
      Text segnalinoCiclistaCorrente = new Text(SEGNALINO, new Point(MARGINE
          + SPESSORE_LINEA + MARGINE_NOMI, MARGINE + SPESSORE_LINEA + ALTEZZA
          * i - ALTEZZA / 2));
      addFigureBatch(segnalinoCiclistaCorrente);
      posizione.put(e.getKey(), segnalinoCiclistaCorrente);
      i++;
    }

    // disegna la pista

    altezzaTotale = mapNames.size() * ALTEZZA;

    // linee laterali
    Point start = new Point(MARGINE + MARGINE_NOMI, MARGINE);
    Point end = new Point(MARGINE + MARGINE_NOMI, MARGINE + altezzaTotale);
    Line l = new Line(start, end);
    l.setLineSize(SPESSORE_LINEA);
    addFigureBatch(l);

    start = new Point(MARGINE + MARGINE_NOMI + LARGHEZZA, MARGINE);
    end = new Point(MARGINE + MARGINE_NOMI + LARGHEZZA, MARGINE + altezzaTotale);
    l = new Line(start, end);
    l.setLineSize(SPESSORE_LINEA);
    addFigureBatch(l);

    start = new Point(3 * MARGINE + MARGINE_NOMI + LARGHEZZA, MARGINE);
    end = new Point(3 * MARGINE + MARGINE_NOMI + LARGHEZZA, MARGINE
        + altezzaTotale);
    l = new Line(start, end);
    l.setLineSize(SPESSORE_LINEA);
    addFigureBatch(l);

    // corsie
    for (i = 0; i <= mapNames.size(); i++) {
      start = new Point(MARGINE, MARGINE + ALTEZZA * i);
      end = new Point(3 * MARGINE + LARGHEZZA + MARGINE_NOMI, MARGINE + ALTEZZA
          * i);
      l = new Line(start, end);
      l.setLineSize(SPESSORE_LINEA);
      addFigureBatch(l);
    }

    commit();
  }

  public void setPosizioneCiclista(Integer ciclista, float kmPercorsi) {
    // Normalizza la posizione in base alla dimensione del percorso
    int nuovaPosizioneCiclista = (int) ((kmPercorsi / distanzaGara) * LARGHEZZA);
    if (nuovaPosizioneCiclista >= LARGHEZZA) {// arrivato al traguardo
      nuovaPosizioneCiclista = LARGHEZZA;
    }
    // Posiziona il Segnalino in base alla nuova posizione (l'altezza e' la
    // stessa del segnalino precedente)
    Text segnalinoCiclista = new Text(SEGNALINO, new Point(MARGINE
        + SPESSORE_LINEA + MARGINE_NOMI + nuovaPosizioneCiclista, posizione
        .get(ciclista).getPoint().y));
    removeFigure(posizione.get(ciclista));// toglie il ciclista dalla posizione
                                          // corrente...
    addFigureBatch(segnalinoCiclista);// ... lo rimpiazza con quella nuova
    posizione.put(ciclista, segnalinoCiclista); // aggiorna la mappa
    commit();
  }

  @Override
  public Dimension getPreferredSize() {
    /*return (new Dimension(LARGHEZZA + MARGINE_NOMI + 5 * MARGINE, altezzaTotale
        + MARGINE_NOMI + MARGINE));*/
    return (new Dimension(LARGHEZZA + MARGINE_NOMI + 5 * MARGINE, altezzaTotale + 3*MARGINE));
  }
}
