package view;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;

import javax.swing.*;

public class InserisciDatiGara extends JFrame {
  
  class Ascoltatore implements ActionListener {
    public void actionPerformed(ActionEvent arg0) {
      if (nomeTxt.getText() == null || nomeTxt.getText().equals("")) {
        ErrorNotifier.notifyError("Inserire i dati correttamente!");
      }
      else {
        try {
          nomeGara = nomeTxt.getText();
          distanzaGara = Float.parseFloat(distanzaTxt.getText());
          if (distanzaGara > 0) {
            synchronized (getContentPane()) {
              getContentPane().notify();
              dispose();
            }
          }
          else
            ErrorNotifier.notifyError("Inserire i dati correttamente!");
        }
        catch (Exception e) {
          ErrorNotifier.notifyError("Inserire i dati correttamente!");
        }
      }
    }
  }

  private final JLabel nomeLbl = new JLabel("Nome della gara:");
  private final JTextField nomeTxt = new JTextField();
  private final JLabel distanzaLbl = new JLabel("Distanza (km):");
  private final JTextField distanzaTxt = new JTextField();
  private final JPanel centroPnl = new JPanel();
  private final JPanel sudPnl = new JPanel();
  private final JButton okBtn = new JButton("OK");
  private String nomeGara;
  private float distanzaGara;

  public InserisciDatiGara() {
    super("Inserimento Dati Gara");
    Runnable target = new Runnable() {
      @Override
      public void run() {
        inizializza();
      }
    };
    try {
      SwingUtilities.invokeAndWait(target);
    } catch (InterruptedException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    } catch (InvocationTargetException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }
  
  private void inizializza() {
    getContentPane().add(centroPnl, BorderLayout.NORTH);
    getContentPane().add(sudPnl, BorderLayout.SOUTH);
    centroPnl.setLayout(new GridLayout(2, 2));
    centroPnl.add(nomeLbl);
    centroPnl.add(nomeTxt);
    centroPnl.add(distanzaLbl);
    centroPnl.add(distanzaTxt);
    centroPnl.setBorder(BorderFactory.createEmptyBorder(15, 10, 0, 10));
    sudPnl.add(okBtn);
    okBtn.addActionListener(new Ascoltatore());
    setSize(300, 150);
    setLocationRelativeTo(null);
    setVisible(true);
  }

  public String leggiNome() {
    return nomeGara;
  }

  public float leggiDistanza() {
    return distanzaGara;
  }

  public void aspettaOK() {
    synchronized (getContentPane()) {
      try {
        getContentPane().wait();
      } catch (InterruptedException e) {
        e.printStackTrace();
        System.exit(1);
      }
    }
  }
}
