package view;

import javax.swing.*;


import java.awt.*;
import java.lang.reflect.InvocationTargetException;
import java.util.*;

public class GaraView extends JFrame {

  private Container frmContentPane;
  protected Percorso percorso; // rendere accessibile all'attivita' di
                               // aggiornamento
  private String nomeGara;
  private float distanzaGara;
  private Map<Integer, String> mapNames;

  public GaraView(String nomeGara, float distanzaGara, Map<Integer, String> mapNames) {
    super(nomeGara);
    this.nomeGara = nomeGara;
	this.distanzaGara = distanzaGara;
	this.mapNames = mapNames;
    // si registra come observer dell'oggetto di dominio che rappresenta la gara (model)
    Runnable target = new Runnable() {
      
      @Override
      public void run() {
        prepara();
      }
    };
    try {
      SwingUtilities.invokeAndWait(target);
    } catch (InterruptedException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    } catch (InvocationTargetException e) {
      // TODO Auto-generated catch block
      e.printStackTrace();
    }
  }

  private void prepara() {// prepara la finestra per la
                                      // visualizzazione
    frmContentPane = getContentPane();
    percorso = new Percorso(distanzaGara, mapNames);
    frmContentPane.add(percorso, BorderLayout.CENTER);
    JLabel infoGara = new JLabel("Gara: " + nomeGara + " - Km: " + distanzaGara);
    JPanel garaInfo = new JPanel();
    garaInfo.add(infoGara);
    frmContentPane.add(garaInfo, BorderLayout.PAGE_START);
    this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    pack();
    setLocationRelativeTo(null);
    setVisible(true);
  }
  
  public void update(int ciclista, float kmPercorsi) {
    percorso.setPosizioneCiclista(ciclista, kmPercorsi);
  }
}
