package model.dominio;

public class TipoLinkPartecipa {
  private final Gara gara;
  private final Ciclista ciclista;
  private final float kmPercorsi;

  public TipoLinkPartecipa(Gara gara, Ciclista ciclista, float kmPercorsi)
      throws EccezionePrecondizioni {
    if (gara == null || ciclista == null)
      throw new EccezionePrecondizioni("Parametri nulli non ammessi");
    this.ciclista = ciclista;
    this.gara = gara;
    this.kmPercorsi = kmPercorsi;
  }

  public Gara getGara() {
    return gara;
  }

  public Ciclista getCiclista() {
    return ciclista;
  }

  public float getKmPercorsi() {
    return kmPercorsi;
  }

  public int hashCode() {
    return gara.hashCode() + ciclista.hashCode();
  }

  public boolean equals(Object o) {
    if (o == null || (this.getClass() != o.getClass()))
      return false;
    TipoLinkPartecipa l = (TipoLinkPartecipa) o;
    return (gara == l.getGara() && ciclista == l.getCiclista());
  }

}
