package controller;

import model.dominio.Ciclista;
import model.dominio.EccezioneMoltMinMax;
import model.dominio.Gara;
import model.dominio.EccezioneSubset;
import model.dominio.TipoLinkPartecipa;
import view.ProclamaVincitoriFrame;
import view.InserisciDatiGara;
import view.GaraView;
import java.util.*;
import model.attivita.atomiche.SegnaliIO;
import model.dominio.GaraUpdate;
import view.FinestraAltroCiclista;
import view.FinestraDatiCiclista;


public class SegnaliIOImpl implements SegnaliIO, Observer {

	public Gara inserisciDatiGara() {
		InserisciDatiGara frame = new InserisciDatiGara();
		frame.aspettaOK();
		return new Gara(frame.leggiNome(), frame.leggiDistanza());
	}

	public Ciclista inserisciDatiCiclista() {
		return (new Ciclista((new FinestraDatiCiclista()).attendiSelezione()));
	}

	public boolean chiediSeAltroCiclista() {
		return (new FinestraAltroCiclista()).attendiSelezione();
	}

	public void proclamaVincitori(Gara gara) {
		try {
			Vector<Map.Entry<String, Float>> partecipanti = new Vector<Map.Entry<String, Float>>();
			for (TipoLinkPartecipa tlp: gara.getLinkPartecipa()) {
				Map.Entry<String, Float> toAdd = new AbstractMap.SimpleEntry<String,Float> (tlp.getCiclista().getNome(), tlp.getKmPercorsi());
				partecipanti.add(toAdd);
			}
			Vector<String> vincitori = new Vector<String>();
			for (Ciclista c: gara.getLinkVincitori()) {
				vincitori.add(c.getNome());
			}
			new ProclamaVincitoriFrame(vincitori, partecipanti);
		} catch (EccezioneMoltMinMax e) {
			e.printStackTrace();
			System.exit(1);
		} catch (EccezioneSubset e) {
			e.printStackTrace();
			System.exit(1);
		}

	}
	
	private GaraView garaView = null;
	private HashMap<Ciclista, Integer> mapId = null;
	private HashMap<Integer, String> mapNames = null;

	public void visualizzaGara(Gara gara) {
		mapNames = new HashMap<Integer, String>();
		mapId = new HashMap<Ciclista, Integer>();
		int i = 0;
		try {
			for (TipoLinkPartecipa tlp: gara.getLinkPartecipa()) {
				mapId.put(tlp.getCiclista(), i);
				mapNames.put(i, tlp.getCiclista().getNome());
				i++;
			}
		} catch (Exception e) {}
		
		garaView = new GaraView(gara.getNome(), gara.getDistanza(), mapNames);
		gara.addObserver(this);
	}

	@Override
	public void update(Observable o, Object arg) {
		GaraUpdate aggiornamento = (GaraUpdate) arg;
		garaView.update(mapId.get(aggiornamento.getCiclista()), aggiornamento.getKmPercorsi());
	}

}
