package model.attivita.complesse;

import java.util.HashMap;
import model.lega.TipoLinkPartita;
import model.attivita.atomiche.SegnaliIO;
import java.util.Set;

public class AttivitaPrincipale implements Runnable{
	private boolean eseguita = false;
	
	private SegnaliIO segnaliIO;
	private Set<TipoLinkPartita> partite;
	
	public AttivitaPrincipale(SegnaliIO segnaliIO, Set<TipoLinkPartita> partite) {
		this.segnaliIO = segnaliIO;
		this.partite = partite;
	}
	
	public synchronized void run(){
		if (eseguita)
			return;
		eseguita = true;
		
		TipoLinkPartita partitaSelezionata = null;
		
		do{
			partitaSelezionata = segnaliIO.selezionaPartita(partite);
			
			if (partitaSelezionata != null){
				SottoramoSx sottoramoSx = new SottoramoSx(partitaSelezionata, segnaliIO);
				SottoramoDx sottoramoDx = new SottoramoDx(partitaSelezionata);
				Thread t1 = new Thread(sottoramoSx);
				Thread t2 = new Thread(sottoramoDx);
				t1.start();
				t2.start();
				try{
					t1.join();
					t2.join();
				}
				catch (InterruptedException e){
					e.printStackTrace();
				}
				segnaliIO.stampaHTML(sottoramoDx.getVinteCasa(),
						sottoramoDx.getVinteTrasferta(),
						sottoramoSx.getMediaEtaCasa(), 
						sottoramoSx.getMediaEtaTrasferta());
			}			
		}
		while(partitaSelezionata != null);
	}

	synchronized boolean estEseguita(){
		return eseguita;
	}

}
