package controller;

import model.lega.squadra.Squadra;
import model.lega.TipoLinkPartita;
import java.util.*;

import javax.swing.*;
import view.FinestraAltraSquadra;
import view.FinestraQualeSquadra;
import view.FinestraSelezionaPartita;
import view.StampaASchermo;

public class SegnaliIOImpl implements model.attivita.atomiche.SegnaliIO {
	public TipoLinkPartita selezionaPartita(Set<TipoLinkPartita> partite){
		HashMap<Integer, TipoLinkPartita> mappa = new HashMap<Integer, TipoLinkPartita>();
		HashMap<Integer, String> partite_show = new HashMap<Integer, String>();
		int i = 0;
		synchronized(partite) {
			for (TipoLinkPartita tlp: partite) {
				mappa.put(i, tlp);
				partite_show.put(i, tlp.getCasa().getNome() + "-" + tlp.getTrasferta().getNome() + " : " + tlp.getGoalCasa() + " - " + tlp.getGoalTrasferta());
				i++;
			}
		}
		// Task LeggiPartita
		FinestraSelezionaPartita f = new FinestraSelezionaPartita(partite_show);
		int risultato = f.attendiSelezione(); // variabile risultato necessaria per chiudere la finestra
		f.dispose();// chiude la finestra
		return mappa.get(risultato);
	}
	
	public Squadra qualeSquadra(Squadra casa, Squadra trasferta){
		FinestraQualeSquadra f = new FinestraQualeSquadra();
		FinestraQualeSquadra.QualeSquadra res = f.attendiSelezione();
		if (res == FinestraQualeSquadra.QualeSquadra.IN_CASA)
			return casa;
		else
			return trasferta;
	}
	
	public boolean altraSquadra(){
		FinestraAltraSquadra f = new FinestraAltraSquadra();
		return f.attendiSelezione();
	}
	
	public void stampaHTML(int vinteCasa, int vinteTrasferta, float mediaEtaCasa, float mediaEtaTrasferta){
		// Task StampaHTML
		StampaASchermo.stampa("La squadra di casa ");
		if(mediaEtaCasa > -1){
			StampaASchermo.stampa("ha un'eta' media di: " + mediaEtaCasa + " anni ed ");
		}
		StampaASchermo.stampaLinea("ha vinto: " + vinteCasa + " partite");
		StampaASchermo.stampa("La squadra in trasferta ");
		if(mediaEtaTrasferta > -1){
			StampaASchermo.stampa("ha un'eta' media di: " + mediaEtaTrasferta + " anni ed ");
		}
		StampaASchermo.stampaLinea("ha vinto: " + vinteTrasferta + " partite");
	}	
}


