// File AppCostruzioni/TipoMattoncini/TipoMattoncini.java
package AppCostruzioni.TipoMattoncini;

import AppCostruzioni.*;

import java.util.*;

public class TipoMattoncini {
  private final String dimensioni;
  private final String colore;
  private HashSet<TipoLinkRichiede> richiede;

  public TipoMattoncini(String dimensioni, String colore) {
    this.dimensioni = dimensioni;
    this.colore = colore;
    richiede = new HashSet<TipoLinkRichiede>();
  }

  public String getDimensioni() {
    return dimensioni;
  }

  public String getColore() {
    return colore;
  }

  public void inserisciLinkRichiede(TipoLinkRichiede a) {
    if (a != null && a.getTipoMattoncini() == this)
      ManagerRichiede.inserisci(a);
  }

  public void eliminaLinkRichiede(TipoLinkRichiede a) {
    if (a != null && a.getTipoMattoncini() == this)
      ManagerRichiede.elimina(a);
  }

  public Set<TipoLinkRichiede> getLinkRichiede() {
    return (HashSet<TipoLinkRichiede>) richiede.clone();
  }

  public void inserisciPerManagerRichiede(ManagerRichiede a) {
    if (a != null)
      richiede.add(a.getLink());
  }

  public void eliminaPerManagerRichiede(ManagerRichiede a) {
    if (a != null)
      richiede.remove(a.getLink());
  }
}
