// File AppCostruzioni/TipoLinkRichiede.java
package AppCostruzioni;

import AppCostruzioni.TipoMattoncini.*;
import AppCostruzioni.Costruzione.*;

public class TipoLinkRichiede {
  private final Costruzione laCostruzione;
  private final TipoMattoncini ilTipoMattoncini;
  private final int quantita;

  public TipoLinkRichiede(Costruzione c, TipoMattoncini m, int quantita)
      throws EccezionePrecondizioni {
    if (c == null || m == null) { // CONTROLLO PRECONDIZIONI
      throw new EccezionePrecondizioni(
          "Gli oggetti devono essere inizializzati");
    }
    laCostruzione = c;
    ilTipoMattoncini = m;
    this.quantita = quantita;
  }

  public boolean equals(Object o) {
    if (o != null && getClass().equals(o.getClass())) {
      TipoLinkRichiede l = (TipoLinkRichiede) o;
      return l.laCostruzione == laCostruzione
          && l.ilTipoMattoncini == ilTipoMattoncini;
    } else
      return false;
  }

  public int hashCode() {
    return laCostruzione.hashCode() + ilTipoMattoncini.hashCode();
  }

  public Costruzione getCostruzione() {
    return laCostruzione;
  }

  public TipoMattoncini getTipoMattoncini() {
    return ilTipoMattoncini;
  }

  public int getQuantita() {
    return quantita;
  }

  public String toString() {
    return "<" + laCostruzione + ", " + ilTipoMattoncini + ">";
  }
}
