// File AppCostruzioni/TipoLinkContieneSpeciale.java
package AppCostruzioni;

import AppCostruzioni.ScatolaSpeciale.*;
import AppCostruzioni.TipoMattonciniElettrificati.*;

public class TipoLinkContieneSpeciale {
  private final ScatolaSpeciale laScatolaSpeciale;
  private final TipoMattonciniElettrificati ilTipoMattonciniElettrificati;

  public TipoLinkContieneSpeciale(ScatolaSpeciale c,
      TipoMattonciniElettrificati m) throws EccezionePrecondizioni {
    if (c == null || m == null) { // CONTROLLO PRECONDIZIONI
      throw new EccezionePrecondizioni(
          "Gli oggetti devono essere inizializzati");
    }
    laScatolaSpeciale = c;
    ilTipoMattonciniElettrificati = m;
  }

  public boolean equals(Object o) {
    if (o != null && getClass().equals(o.getClass())) {
      TipoLinkContieneSpeciale l = (TipoLinkContieneSpeciale) o;
      return (l.laScatolaSpeciale == laScatolaSpeciale && 
          l.ilTipoMattonciniElettrificati == ilTipoMattonciniElettrificati);
    } else
      return false;
  }

  public int hashCode() {
    return laScatolaSpeciale.hashCode()
        + ilTipoMattonciniElettrificati.hashCode();
  }

  public ScatolaSpeciale getScatolaSpeciale() {
    return laScatolaSpeciale;
  }

  public TipoMattonciniElettrificati getTipoMattonciniElettrificati() {
    return ilTipoMattonciniElettrificati;
  }

  public String toString() {
    return "<" + laScatolaSpeciale + ", " + ilTipoMattonciniElettrificati + ">";
  }
}
