// File AppCostruzioni/TipoLinkContiene.java
package AppCostruzioni;

import AppCostruzioni.ScatolaMontaggio.*;
import AppCostruzioni.TipoMattoncini.*;

public class TipoLinkContiene {
  private final ScatolaMontaggio laScatolaMontaggio;
  private final TipoMattoncini ilTipoMattoncini;
  private final int quantita;

  public TipoLinkContiene(ScatolaMontaggio c, TipoMattoncini m, int quantita)
      throws EccezionePrecondizioni {
    if (c == null || m == null) { // CONTROLLO PRECONDIZIONI
      throw new EccezionePrecondizioni(
          "Gli oggetti devono essere inizializzati");
    }
    laScatolaMontaggio = c;
    ilTipoMattoncini = m;
    this.quantita = quantita;
  }

  public boolean equals(Object o) {
    if (o != null && getClass().equals(o.getClass())) {
      TipoLinkContiene l = (TipoLinkContiene) o;
      return l.laScatolaMontaggio == laScatolaMontaggio
          && l.ilTipoMattoncini == ilTipoMattoncini;
    } else
      return false;
  }

  public int hashCode() {
    return laScatolaMontaggio.hashCode() + ilTipoMattoncini.hashCode();
  }

  public ScatolaMontaggio getScatolaMontaggio() {
    return laScatolaMontaggio;
  }

  public TipoMattoncini getTipoMattoncini() {
    return ilTipoMattoncini;
  }

  public int getQuantita() {
    return quantita;
  }

  public String toString() {
    return "<" + laScatolaMontaggio + ", " + ilTipoMattoncini + ">";
  }
}
