// File AppCostruzioni/ScatolaSpeciale/ScatolaSpeciale.java
package AppCostruzioni.ScatolaSpeciale;

import AppCostruzioni.*;
import AppCostruzioni.ScatolaMontaggio.*;
import AppCostruzioni.TipoMattoncini.*;

import java.util.*;

public final class ScatolaSpeciale extends ScatolaMontaggio {
  private final int MOLT_MIN = 1;
  private final int difficolta;
  private HashSet<TipoLinkContieneSpeciale> contieneSpeciale;

  public ScatolaSpeciale(String descrizione, int difficolta) {
    super(descrizione);
    this.difficolta = difficolta;
    contieneSpeciale = new HashSet<TipoLinkContieneSpeciale>();
  }

  public int getDifficolta() {
    return difficolta;
  }

  public void inserisciLinkContieneSpeciale(TipoLinkContieneSpeciale c) {
    if (c != null && c.getScatolaSpeciale() == this)
      contieneSpeciale.add(c);
  }

  public void eliminaLinkContieneSpeciale(TipoLinkContieneSpeciale c) {
    if (c != null && c.getScatolaSpeciale() == this)
      contieneSpeciale.remove(c);
  }

  public Set<TipoLinkContieneSpeciale> getLinkContieneSpeciale()
      throws EccezioneMolteplicita, EccezioneSubset {
    if (getLinkContiene().size() < MOLT_MIN) {
      throw new EccezioneMolteplicita("Molteplicita' minima violata");
    }
    Set<TipoLinkContiene> c = getLinkContiene();
    // bisogna verificare il contenimento per TUTTI gli elementi!
    Iterator<TipoLinkContieneSpeciale> it = contieneSpeciale.iterator();
    while (it.hasNext()) {
      TipoMattoncini m = (TipoMattoncini) it.next()
          .getTipoMattonciniElettrificati();
      if (!c.contains(new TipoLinkContiene(this, m, 0))) // Nota: la
        // quantita'
        // (terzo
        // parametro)
        // non e' significativa

        throw new EccezioneSubset("Vincolo di subset violato");
    }
    return (HashSet<TipoLinkContieneSpeciale>) contieneSpeciale.clone();
  }
}
