// File AppCostruzioni/ScatolaMontaggio/ScatolaMontaggio.java
package AppCostruzioni.ScatolaMontaggio;

import AppCostruzioni.*;

import java.util.*;

public class ScatolaMontaggio {
  private final int MOLT_MIN = 1;

  private final String descrizione;
  private HashSet<TipoLinkContiene> contiene;

  public ScatolaMontaggio(String descrizione) {
    this.descrizione = descrizione;
    contiene = new HashSet<TipoLinkContiene>();
  }

  public String getDescrizione() {
    return descrizione;
  }

  public void inserisciLinkContiene(TipoLinkContiene c) {
    if (c != null && c.getScatolaMontaggio() == this)
      contiene.add(c);
  }

  public void eliminaLinkContiene(TipoLinkContiene c) {
    if (c != null && c.getScatolaMontaggio() == this)
      contiene.remove(c);
  }

  public Set<TipoLinkContiene> getLinkContiene() throws EccezioneMolteplicita {
    if (contiene.size() < MOLT_MIN) {
      throw new EccezioneMolteplicita("Molteplicita' minima violata");
    }
    return (HashSet<TipoLinkContiene>) contiene.clone();
  }
}
