// File AppCostruzioni/CostruzioneSpeciale/CostruzioneSpeciale.java
package AppCostruzioni.CostruzioneSpeciale;

import AppCostruzioni.*;
import AppCostruzioni.Costruzione.*;
import AppCostruzioni.TipoMattonciniElettrificati.*;

public final class CostruzioneSpeciale extends Costruzione {
  private final String fenomeno;
  private TipoMattonciniElettrificati richiedeSpeciale;

  public CostruzioneSpeciale(String istruzioni, String fenomeno) {
    super(istruzioni);
    this.fenomeno = fenomeno;
    richiedeSpeciale = null;
  }

  public String getFenomeno() {
    return fenomeno;
  }

  public void inserisciTipoMattonciniElettrificati(
      TipoMattonciniElettrificati me) {
    if (me != null)
      richiedeSpeciale = me;
  }

  public void eliminaTipoMattonciniElettrificati() {
    richiedeSpeciale = null;
  }

  public TipoMattonciniElettrificati getTipoMattonciniElettrificati()
      throws EccezioneSubset, EccezioneMolteplicita {
    if (richiedeSpeciale == null)
      throw new EccezioneMolteplicita("Molteplicita' min/max violate");
    if (!getLinkRichiede().contains(
        new TipoLinkRichiede(this, richiedeSpeciale, 0 /*
                                                        * non significativo
                                                        */))) {
      throw new EccezioneSubset("Vincolo di subset violato");
    }
    return richiedeSpeciale;
  }
}
