// File AppCostruzioni/Costruzione/Costruzione.java
package AppCostruzioni.Costruzione;

import AppCostruzioni.*;
import java.util.*;

public class Costruzione {
  private final int MOLT_MIN = 1;
  private final String istruzioni;
  private HashSet<TipoLinkRichiede> richiede;

  public Costruzione(String istruzioni) {
    this.istruzioni = istruzioni;
    richiede = new HashSet<TipoLinkRichiede>();
  }

  public String getIstruzioni() {
    return istruzioni;
  }

  public void inserisciLinkRichiede(TipoLinkRichiede a) {
    if (a != null && a.getCostruzione() == this)
      ManagerRichiede.inserisci(a);
  }

  public void eliminaLinkRichiede(TipoLinkRichiede a) {
    if (a != null && a.getCostruzione() == this)
      ManagerRichiede.elimina(a);
  }

  public Set<TipoLinkRichiede> getLinkRichiede() throws EccezioneMolteplicita {
    if (richiede.size() < MOLT_MIN) {
      throw new EccezioneMolteplicita("Molteplicita minima violata");
    }
    return (HashSet<TipoLinkRichiede>) richiede.clone();
  }

  public void inserisciPerManagerRichiede(ManagerRichiede a) {
    if (a != null)
      richiede.add(a.getLink());
  }

  public void eliminaPerManagerRichiede(ManagerRichiede a) {
    if (a != null)
      richiede.remove(a.getLink());
  }
}
