// File AppCostruzioni/ClienteMattoncini.java
package AppCostruzioni;

import AppCostruzioni.Costruzione.*;
import AppCostruzioni.ScatolaMontaggio.*;
import AppCostruzioni.TipoMattonciniElettrificati.*;

import java.util.*;

public final class ClienteMattoncini {
  public static boolean mattonciniSufficienti(ScatolaMontaggio s, Costruzione c)
      throws EccezioneMolteplicita {

    /*
     * ALGORITMO: per ogni tipo di mattoncino richiesto per la costruzione si
     * verifica se il tipo di mattoncino e' contenuto nella scatola e se la
     * quantita' richiesta e' minore o uguale alla quantita' contenuta nella
     * scatola
     */

    Iterator<TipoLinkRichiede> itr = c.getLinkRichiede().iterator(); // puo'
    // lanciare
    // EccezioneMolteplicita
    while (itr.hasNext()) {
      TipoLinkRichiede richiede = itr.next();
      Iterator<TipoLinkContiene> itc = s.getLinkContiene().iterator(); // puo'
      // lanciare
      // EccezioneMolteplicita
      boolean found = false;
      while (itc.hasNext() && !found) {
        TipoLinkContiene contiene = itc.next();
        if ((richiede.getTipoMattoncini() == contiene.getTipoMattoncini())
            && (richiede.getQuantita() <= contiene.getQuantita()))
          found = true;
      }// fine while(itc.hasNext())
      if (!found)
        return false;
    }// fine while (itr.hasNext())
    return true;
  }

  public static Set<Costruzione> costruzioniCheUsano(
      TipoMattonciniElettrificati me) {
    HashSet<Costruzione> result = new HashSet<Costruzione>();
    Iterator<TipoLinkRichiede> itr = me.getLinkRichiede().iterator();
    while (itr.hasNext()) {
      result.add(itr.next().getCostruzione());
    }
    return result;
  }
}
