package pila.sideEffect;

class Nodo<T> {

    public T info;
    public Nodo<T> next;
}

public class Pila<T> {

	// rappresentazione degli oggetti
    private Nodo<T> nodoinit;

	// realizzazione delle funzioni del tipo astratto
    public Pila() { // realizza pilaVuota
        nodoinit = null;
    }

    public boolean estVuota() {
        return nodoinit == null;
    }

    public void push(T o) {
        Nodo<T> aux = new Nodo<T>();
        aux.info = o;
        aux.next = nodoinit;
        nodoinit = aux;
    }

    public void pop() {
        if (estVuota()) {
            throw new RuntimeException("Pila: pop applicato ad una pila vuota");
        } else {
            nodoinit = nodoinit.next;
        }
    }

    public Object top() {
        if (estVuota()) {
            throw new RuntimeException("Pila: top applicato ad una pila vuota");
        } else {
            return nodoinit.info;
        }
    }

	//uguaglianza
    @Override
    public boolean equals(Object o) {
        if (o == null || !getClass().equals(o.getClass())) {
            return false;
        }
        Pila<T> p = (Pila<T>) o;
        Nodo<T> n1 = nodoinit;
        Nodo<T> n2 = p.nodoinit;
        while (n1 != null && n2 != null) {
            if (!n1.info.equals(n2.info)) {
                return false;
            }
            n1 = n1.next;
            n2 = n2.next;
        }
        return (n1 == null && n2 == null);
    }

    @Override
    public int hashCode() {
        if (nodoinit != null || nodoinit.info != null) {
            return (nodoinit.info.hashCode());
        } else {
            return (0);
        }
    }

    @Override
    public Object clone() {
        if (estVuota()) {
            return (new Pila<T>());
        } else {

            Nodo<T> iterator = nodoinit;
            Nodo<T> nodoClone = new Nodo<T>();
            Pila<T> pilaClonata = new Pila<T>();
            pilaClonata.nodoinit = nodoClone;
            while (iterator != null) {
                nodoClone.info = iterator.info;
                iterator = iterator.next;
                if (iterator != null) {
                    nodoClone.next = new Nodo<T>();
                    nodoClone = nodoClone.next;
                } else {
                    nodoClone.next = null;
                }
            }
            return (pilaClonata);
        }
    }
}
