
import java.util.*;
import java.util.logging.Logger;

import javax.jws.WebService;

@WebService (
		name = "ElencoUtentiAttiviEndpoint",
		serviceName = "ElencoUtentiAttivi",
		targetNamespace = "http://www.dis.uniroma1.it/pseudoinfostud/ElencoUtentiAttivi",
		endpointInterface = "ElencoUtentiAttiviService"
)

public class ElencoUtentiAttiviEndpoint implements ElencoUtentiAttiviService {

	@Override
	/**
	 * @author Cdc
	 */
	public String[] getElencoUtentiAttivi() {
		
		// Naive implementation for demonstration purposes
		List<String> utentiAttivi = new ArrayList<String>();
		utentiAttivi.add("Massimo Mecella");
		utentiAttivi.add("Roberto Baldoni");
		utentiAttivi.add("Roberto Beraldi");
		utentiAttivi.add("Davide Lamanna");
		
		// Logging...
		Logger
		.getLogger("ActiveUsersWebServiceSample")
		.info(	"\n" +
				"\t" + "Request for \"getElencoUtentiAttivi() : {String}*\" received." + "\n" +
				"\t" + "Returning " + utentiAttivi.size() + " results...");
		
		// RIGHT cast: take advantage of
		// 		public <T> T[] toArray(T[] array)
		// defined in ArrayList<T>
		return utentiAttivi.toArray(new String[utentiAttivi.size()]);
		// WRONG code for cast (commented):
		// return (String[])utentiAttivi.toArray();
	}

}