/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;

public class EmittedLayout {
    static int count = 0;
    public Dimension screenSize = new Dimension();
    public Map visVertexMap = new HashMap();
    public Map visEdgeMap = new HashMap();

    public VisVertex getVisVertex(Vertex v) {
        return (VisVertex)this.visVertexMap.get(v);
    }

    public VisEdge getVisEdge(Edge e) {
        return (VisEdge)this.visEdgeMap.get(e);
    }

    public Dimension getDimension() {
        return this.screenSize;
    }

    public Vertex getNearestVertex(double x, double y) {
        Vertex closest = null;
        double minDistance = Double.MAX_VALUE;
        Iterator iter = this.visVertexMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            VisVertex vc = (VisVertex)me.getValue();
            double dist = vc.getSquareDistance(x, y);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            closest = (Vertex)me.getKey();
        }
        return closest;
    }

    public Edge getNearestEdge(double x, double y) {
        double minDistance = Double.MAX_VALUE;
        Edge closest = null;
        Iterator iter = this.visEdgeMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            VisEdge ec = (VisEdge)me.getValue();
            double distance2 = ec.getSquareDistance(x, y);
            if (!(distance2 < minDistance)) continue;
            minDistance = distance2;
            closest = (Edge)me.getKey();
        }
        return closest;
    }

    public Dimension getScreenSize() {
        return this.screenSize;
    }
}

