/*
 * Decompiled with CFR 0.152.
 */
package simulator.plus;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import service.ComposedState;
import service.ComposedTransition;
import service.ServiceFactory;
import service.SimpleState;
import service.SimpleTransition;
import service.State;
import service.TransitionSystem;
import simulator.Simulation;
import simulator.plus.ResultPrunedAsyncProduct;
import simulator.plus.SimilarState;

public class SimulationPlusImpl
extends Simulation {
    private TransitionSystem<SimpleState, SimpleTransition> target;
    private TransitionSystem<ComposedState, ComposedTransition> composition;
    private TransitionSystem<ComposedState, ComposedTransition> asyncProd;
    private HashSet<SimilarState> relation;

    private SimulationPlusImpl() {
    }

    @Override
    public TransitionSystem<ComposedState, ComposedTransition> getCompositionTs() {
        return this.composition;
    }

    @Override
    public TransitionSystem<SimpleState, SimpleTransition> getTargetTs() {
        return this.target;
    }

    public static SimulationPlusImpl generate(TransitionSystem<SimpleState, SimpleTransition> target, TransitionSystem<SimpleState, SimpleTransition>[] availableServices, ServiceFactory serviceFactory) throws Exception {
        ResultPrunedAsyncProduct resultAsyncPrunedProd = SimulationPlusImpl.asynchronousProductPruned(target, availableServices, serviceFactory);
        HashSet<SimilarState> r = resultAsyncPrunedProd.getCandidatesForSimulation();
        TransitionSystem<ComposedState, ComposedTransition> asyncPrunedProd = resultAsyncPrunedProd.getPrunedAsyncProd();
        boolean rModified = true;
        while (!r.isEmpty() && rModified) {
            HashSet<SimilarState> coupleToRemove = new HashSet<SimilarState>();
            rModified = false;
            for (SimilarState currentSimilarCouple : r) {
                Iterator<SimpleTransition> itTargetActions = target.getActionsOf(currentSimilarCouple.getTargetState()).iterator();
                boolean existSimulation = true;
                while (itTargetActions.hasNext() && existSimulation) {
                    existSimulation = false;
                    SimpleTransition currentTargetAction = itTargetActions.next();
                    for (ComposedTransition currentActionComposedState : asyncPrunedProd.getActionsOfStateWithName(currentSimilarCouple.getAvalableServiceState(), currentTargetAction.getName())) {
                        SimilarState temp = new SimilarState((SimpleState)currentTargetAction.getStateTo(), currentActionComposedState.getStateTo());
                        if (!r.contains(temp)) continue;
                        existSimulation = true;
                    }
                }
                if (existSimulation) continue;
                coupleToRemove.add(currentSimilarCouple);
            }
            if (coupleToRemove.size() <= 0) continue;
            rModified = true;
        }
        TransitionSystem<ComposedState, ComposedTransition> resultPrunedWithSimulation = serviceFactory.createComposedTransitionSystem();
        Iterator<SimilarState> itR = r.iterator();
        while (itR.hasNext()) {
            ComposedState currentState = itR.next().getAvalableServiceState();
            try {
                resultPrunedWithSimulation.addState(currentState);
            }
            catch (Exception itTargetActions) {
                // empty catch block
            }
        }
        for (SimilarState simulationCouple : r) {
            SimpleState currentSimpleState = simulationCouple.getTargetState();
            for (SimpleTransition currentSimpleAction : target.getActionsOf(currentSimpleState)) {
                ComposedState composedState = simulationCouple.getAvalableServiceState();
                for (ComposedTransition currentComposedAction : resultAsyncPrunedProd.getPrunedAsyncProd().getActionsOfStateWithName(composedState, currentSimpleAction.getName())) {
                    SimilarState candidatesForSimulation = new SimilarState((SimpleState)currentSimpleAction.getStateTo(), currentComposedAction.getStateTo());
                    if (!r.contains(candidatesForSimulation)) continue;
                    Set<ComposedTransition> composedActionOther = SimulationPlusImpl.getActionsOfStateWithNameAndTSandStateFrom(resultAsyncPrunedProd.getPrunedAsyncProd(), currentComposedAction);
                    if (composedActionOther.size() == 1) {
                        resultPrunedWithSimulation.addAction(currentComposedAction.getStateFrom(), currentComposedAction.getStateTo(), currentComposedAction);
                        continue;
                    }
                    boolean toAdd = true;
                    for (ComposedTransition otherComposedAction : composedActionOther) {
                        SimilarState otherCandidateForSimulation = new SimilarState((SimpleState)currentSimpleAction.getStateTo(), otherComposedAction.getStateTo());
                        if (r.contains(otherCandidateForSimulation)) continue;
                        toAdd = false;
                    }
                    if (!toAdd) continue;
                    resultPrunedWithSimulation.addAction(currentComposedAction.getStateFrom(), currentComposedAction.getStateTo(), currentComposedAction);
                }
            }
        }
        SimulationPlusImpl result = new SimulationPlusImpl();
        result.target = target;
        result.composition = resultPrunedWithSimulation;
        result.asyncProd = resultAsyncPrunedProd.getPrunedAsyncProd();
        result.relation = r;
        return result;
    }

    private static Set<ComposedTransition> getActionsOfStateWithNameAndTSandStateFrom(TransitionSystem<ComposedState, ComposedTransition> ts, ComposedTransition action) throws Exception {
        Set<ComposedTransition> partialResult = ts.getActionsOfStateWithName(action.getStateFrom(), action.getName());
        Iterator<ComposedTransition> it = partialResult.iterator();
        HashSet<ComposedTransition> result = new HashSet<ComposedTransition>();
        while (it.hasNext()) {
            ComposedTransition currentAction = it.next();
            if (!action.getService().getName().equals(currentAction.getService().getName())) continue;
            result.add(currentAction);
        }
        return result;
    }

    public static ResultPrunedAsyncProduct asynchronousProductPruned(TransitionSystem<SimpleState, SimpleTransition> target, TransitionSystem<SimpleState, SimpleTransition>[] availableServices, ServiceFactory serviceFactory) throws Exception {
        State[] initialStates = new SimpleState[availableServices.length];
        int i = 0;
        while (i < availableServices.length) {
            initialStates[i] = availableServices[i].getInitial();
            ++i;
        }
        ComposedState initialState = serviceFactory.createComposedState(initialStates);
        SimpleState initialStateTarget = target.getInitial();
        HashSet<SimilarState> setStateNotExpanded = new HashSet<SimilarState>();
        HashSet<SimilarState> setStateExpanded = new HashSet<SimilarState>();
        HashSet<ComposedTransition> setStateExpandedAction = new HashSet<ComposedTransition>();
        setStateNotExpanded.add(new SimilarState(initialStateTarget, initialState));
        while (!setStateNotExpanded.isEmpty()) {
            SimilarState currentSimilar = (SimilarState)setStateNotExpanded.iterator().next();
            setStateNotExpanded.remove(currentSimilar);
            if (currentSimilar.getTargetState().isFinal() && !currentSimilar.getAvalableServiceState().isFinal()) continue;
            boolean allActionSimulated = true;
            if (setStateExpanded.contains(currentSimilar)) continue;
            setStateExpanded.add(currentSimilar);
            HashSet<SimilarState> candidatesForSimilar = new HashSet<SimilarState>();
            HashSet<ComposedTransition> candidatesForSimilarActions = new HashSet<ComposedTransition>();
            SimpleState currentTargetState = currentSimilar.getTargetState();
            ComposedState currentComposedState = currentSimilar.getAvalableServiceState();
            Iterator<SimpleTransition> itTargetStateAction = target.getActionsOf(currentTargetState).iterator();
            while (itTargetStateAction.hasNext() && allActionSimulated) {
                boolean thisActionSimulated = false;
                SimpleTransition currentTargetAction = itTargetStateAction.next();
                int i2 = 0;
                while (i2 < currentComposedState.getStates().length && allActionSimulated) {
                    for (SimpleTransition currentAction : availableServices[i2].getActionsOf((SimpleState)currentComposedState.getServicesState(i2))) {
                        if (!currentAction.getName().equals(currentTargetAction.getName())) continue;
                        State[] newStates = (State[])currentComposedState.getStates().clone();
                        newStates[i2] = currentAction.getStateTo();
                        SimpleState nextTargetState = (SimpleState)currentTargetAction.getStateTo();
                        ComposedState nextComposedState = serviceFactory.createComposedState(newStates);
                        SimilarState newCandidate = new SimilarState(nextTargetState, nextComposedState);
                        candidatesForSimilar.add(newCandidate);
                        ComposedTransition candidateAction = serviceFactory.createComposedAction(currentTargetAction.getName(), availableServices[i2], currentComposedState, nextComposedState);
                        candidatesForSimilarActions.add(candidateAction);
                        thisActionSimulated = true;
                    }
                    ++i2;
                }
                if (thisActionSimulated) continue;
                allActionSimulated = false;
            }
            if (!allActionSimulated) continue;
            for (SimilarState currentSimilarState : candidatesForSimilar) {
                if (setStateExpanded.contains(currentSimilarState)) continue;
                setStateNotExpanded.add(currentSimilarState);
            }
            for (ComposedTransition currentCandidateSimilarAction : candidatesForSimilarActions) {
                setStateExpandedAction.add(currentCandidateSimilarAction);
            }
        }
        TransitionSystem<ComposedState, ComposedTransition> result = serviceFactory.createComposedTransitionSystem();
        Iterator itSimilarState = setStateExpanded.iterator();
        while (itSimilarState.hasNext()) {
            try {
                result.addState(((SimilarState)itSimilarState.next()).getAvalableServiceState());
            }
            catch (Exception candidatesForSimilar) {
                // empty catch block
            }
        }
        for (ComposedTransition currentAction : setStateExpandedAction) {
            result.addAction(currentAction.getStateFrom(), currentAction.getStateTo(), currentAction);
        }
        return new ResultPrunedAsyncProduct(result, setStateExpanded);
    }

    @Override
    public Set<State[]> getAllSimilarState() {
        HashSet<State[]> result = new HashSet<State[]>();
        if (this.relation == null) {
            return null;
        }
        for (SimilarState currentSimilarState : this.relation) {
            result.add(new State[]{currentSimilarState.getTargetState(), currentSimilarState.getAvalableServiceState()});
        }
        return result;
    }

    @Override
    public Set<ComposedState> getSimilarStates(State targetState) {
        HashSet<ComposedState> result = new HashSet<ComposedState>();
        for (SimilarState currentSimilarState : this.relation) {
            if (!currentSimilarState.getTargetState().getName().equals(targetState.getName())) continue;
            result.add(currentSimilarState.getAvalableServiceState());
        }
        return result;
    }

    @Override
    public TransitionSystem<ComposedState, ComposedTransition> getAsyncProduct() {
        return this.asyncProd;
    }

    public Set<SimilarState> getAllSimilarState1() {
        if (this.relation == null) {
            return null;
        }
        return new HashSet<SimilarState>(this.relation);
    }
}

