/*
 * Decompiled with CFR 0.152.
 */
package simulator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import service.ComposedState;
import service.ComposedTransition;
import service.DuplicateStateException;
import service.ServiceFactoryImpl;
import service.SimpleState;
import service.SimpleTransition;
import service.State;
import service.Transition;
import service.TransitionSystem;
import service.TransitionSystemImpl;
import simulator.Simulation;

public class SimulationStandardImpl
extends Simulation {
    private TransitionSystem<SimpleState, SimpleTransition> target;
    private TransitionSystem<ComposedState, ComposedTransition> composition;
    private HashSet<Similar<SimpleState, ComposedState>> relation;
    private TransitionSystem<ComposedState, ComposedTransition> async;

    private SimulationStandardImpl() {
    }

    @Override
    public TransitionSystem<ComposedState, ComposedTransition> getCompositionTs() {
        return this.composition;
    }

    @Override
    public Set<ComposedState> getSimilarStates(State targetState) {
        Similar<SimpleState, ComposedState> currentSimilar = null;
        Iterator<Similar<SimpleState, ComposedState>> ior = this.relation.iterator();
        boolean found = false;
        while (ior.hasNext()) {
            currentSimilar = ior.next();
            if (!((SimpleState)currentSimilar.target).equals(targetState)) continue;
            found = true;
            break;
        }
        if (found) {
            return currentSimilar.services;
        }
        return new HashSet<ComposedState>();
    }

    @Override
    public Set<State[]> getAllSimilarState() {
        if (this.relation == null) {
            return null;
        }
        HashSet<State[]> result = new HashSet<State[]>();
        for (Similar<SimpleState, ComposedState> currentSimilar : this.relation) {
            SimpleState currentSimilarSimpleState = (SimpleState)currentSimilar.target;
            Iterator currentSimilarComposedStateIterator = currentSimilar.services.iterator();
            while (currentSimilarComposedStateIterator.hasNext()) {
                result.add(new State[]{currentSimilarSimpleState, (State)currentSimilarComposedStateIterator.next()});
            }
        }
        return result;
    }

    @Override
    public TransitionSystem<SimpleState, SimpleTransition> getTargetTs() {
        return this.target;
    }

    public static Simulation generate(TransitionSystem<SimpleState, SimpleTransition> target, TransitionSystem<SimpleState, SimpleTransition>[] availableServices) throws Exception {
        ComposedState currentComposed;
        Iterator<ComposedState> ioss;
        Similar<Object, Object> similars;
        TransitionSystem<ComposedState, ComposedTransition> async = SimulationStandardImpl.asynchronousProduct(availableServices);
        Iterator<SimpleState> iots = target.getAllStates().iterator();
        SimulationStandardImpl result = new SimulationStandardImpl();
        result.relation = new HashSet();
        while (iots.hasNext()) {
            SimpleState tss = iots.next();
            HashSet<ComposedState> similarStates = new HashSet<ComposedState>();
            for (ComposedState ass : async.getAllStates()) {
                if (tss.isFinal() && !ass.isFinal()) continue;
                similarStates.add(ass);
            }
            SimulationStandardImpl simulationStandardImpl = result;
            simulationStandardImpl.getClass();
            similars = simulationStandardImpl.new Similar();
            similars.target = tss;
            similars.services = similarStates;
            result.relation.add(similars);
        }
        Iterator<Similar<SimpleState, ComposedState>> ior = result.relation.iterator();
        ComposedTransition simAction22 = null;
        boolean modified = true;
        boolean stateSimulated = true;
        boolean actionSimulated = false;
        while (modified) {
            modified = false;
            if (!ior.hasNext()) {
                ior = result.relation.iterator();
            }
            while (ior.hasNext()) {
                similars = ior.next();
                HashSet<ComposedState> nextSimilars = new HashSet<ComposedState>();
                HashSet<ComposedState> currentRemovedSimilars = new HashSet<ComposedState>();
                ioss = similars.services.iterator();
                while (ioss.hasNext()) {
                    stateSimulated = true;
                    currentComposed = ioss.next();
                    for (Transition transition : target.getActionsOf((SimpleState)similars.target)) {
                        actionSimulated = false;
                        for (ComposedTransition simAction22 : async.getActionsOf(currentComposed)) {
                            if (!transition.actionSimulates(simAction22)) continue;
                            if (!result.isSimulatedBy(transition.getStateTo(), simAction22.getStateTo())) {
                                actionSimulated = false;
                                continue;
                            }
                            boolean selfEnding = simAction22.getStateFrom().equals(simAction22.getStateTo());
                            if (selfEnding && currentRemovedSimilars.contains(simAction22.getStateTo())) {
                                actionSimulated = false;
                                continue;
                            }
                            actionSimulated = true;
                            break;
                        }
                        if (actionSimulated) continue;
                        stateSimulated = false;
                        currentRemovedSimilars.add(currentComposed);
                        break;
                    }
                    if (stateSimulated) {
                        nextSimilars.add(currentComposed);
                        continue;
                    }
                    modified = true;
                }
                if (nextSimilars.isEmpty()) {
                    throw new Exception("Unable to simulate service");
                }
                similars.services = nextSimilars;
            }
        }
        result.target = target;
        result.composition = new TransitionSystemImpl<ComposedState, ComposedTransition>();
        ior = result.relation.iterator();
        while (ior.hasNext()) {
            ioss = ior.next().services.iterator();
            while (ioss.hasNext()) {
                try {
                    result.composition.addState(ioss.next());
                }
                catch (DuplicateStateException selfEnding) {
                    // empty catch block
                }
            }
        }
        ioss = result.composition.getAllStates().iterator();
        Iterator<ComposedState> ioss2 = result.composition.getAllStates().iterator();
        while (ioss.hasNext()) {
            currentComposed = ioss.next();
            ioss2 = result.composition.getAllStates().iterator();
            while (ioss2.hasNext()) {
                for (Transition transition : async.getActions(currentComposed, ioss2.next())) {
                    result.composition.addAction((ComposedState)transition.getStateFrom(), (ComposedState)transition.getStateTo(), (ComposedTransition)transition);
                }
            }
        }
        result.async = async;
        return result;
    }

    private static TransitionSystem<ComposedState, ComposedTransition> asynchronousProduct(TransitionSystem<SimpleState, SimpleTransition>[] availableServices) throws Exception {
        HashSet<StateCapsule<SimpleState>> capsules = SimulationStandardImpl.asynchronousProduct(availableServices, 0);
        HashSet<ComposedState> states = new HashSet<ComposedState>();
        Iterator<StateCapsule<SimpleState>> it = capsules.iterator();
        State[] resultingStates = new State[availableServices.length];
        ServiceFactoryImpl sf = new ServiceFactoryImpl();
        while (it.hasNext()) {
            StateCapsule<SimpleState> currentCapsule = it.next();
            String composedStateName = "";
            int i = 0;
            while (i < resultingStates.length) {
                if (currentCapsule == null) {
                    throw new RuntimeException("Class: SimulationImpl Method: asynchronousProduct Exception: Problems during cartesian product have occurred");
                }
                resultingStates[i] = currentCapsule.state;
                composedStateName = String.valueOf(composedStateName) + ((State)currentCapsule.state).getName();
                currentCapsule = currentCapsule.sc;
                ++i;
            }
            states.add(sf.createComposedState(composedStateName, resultingStates));
        }
        Iterator it1 = states.iterator();
        HashSet<ComposedTransition> actions = new HashSet<ComposedTransition>();
        while (it1.hasNext()) {
            ComposedState fixed = (ComposedState)it1.next();
            for (ComposedState compared : states) {
                int difference = fixed.compareNumberDifferentStates(compared);
                if (difference > 1) continue;
                if (difference == -1) {
                    throw new Exception("Errors during the asynchronous product");
                }
                int i = 0;
                while (i < availableServices.length) {
                    SimpleState end;
                    SimpleState source = (SimpleState)fixed.getServicesState(i);
                    if (!source.equals(end = (SimpleState)compared.getServicesState(i)) || difference == 0) {
                        Set<SimpleTransition> currentActions = availableServices[i].getActions(source, end);
                        for (Transition transition : currentActions) {
                            actions.add(sf.createComposedAction(transition.getName(), availableServices[i], fixed, compared));
                        }
                    }
                    ++i;
                }
            }
        }
        Iterator ics = states.iterator();
        Iterator ica = actions.iterator();
        TransitionSystem<ComposedState, ComposedTransition> async = sf.createComposedTransitionSystem();
        while (ics.hasNext()) {
            async.addState((ComposedState)ics.next());
        }
        while (ica.hasNext()) {
            Transition transition = (Transition)ica.next();
            async.addAction(((ComposedTransition)transition).getStateFrom(), ((ComposedTransition)transition).getStateTo(), (ComposedTransition)transition);
        }
        return async;
    }

    private static HashSet<StateCapsule<SimpleState>> asynchronousProduct(TransitionSystem<SimpleState, SimpleTransition>[] availableServices, int ignore) {
        if (ignore >= availableServices.length - 1) {
            HashSet<StateCapsule<SimpleState>> capsulesContainer = new HashSet<StateCapsule<SimpleState>>();
            Iterator<SimpleState> iss = availableServices[availableServices.length - 1].getAllStates().iterator();
            SimulationStandardImpl simpl = new SimulationStandardImpl();
            while (iss.hasNext()) {
                SimpleState current = iss.next();
                SimulationStandardImpl simulationStandardImpl = simpl;
                simulationStandardImpl.getClass();
                StateCapsule newCapsule = simulationStandardImpl.new StateCapsule();
                newCapsule.state = current;
                newCapsule.sc = null;
                capsulesContainer.add(newCapsule);
            }
            return capsulesContainer;
        }
        HashSet<StateCapsule<SimpleState>> oldCapsules = SimulationStandardImpl.asynchronousProduct(availableServices, ignore + 1);
        HashSet<StateCapsule<SimpleState>> newCapsules = new HashSet<StateCapsule<SimpleState>>();
        Iterator<SimpleState> iogs = availableServices[ignore].getAllStates().iterator();
        SimulationStandardImpl dummy = new SimulationStandardImpl();
        while (iogs.hasNext()) {
            SimpleState currentState = iogs.next();
            for (StateCapsule<SimpleState> currentCapsule : oldCapsules) {
                SimulationStandardImpl simulationStandardImpl = dummy;
                simulationStandardImpl.getClass();
                StateCapsule newCapsule = simulationStandardImpl.new StateCapsule();
                newCapsule.state = currentState;
                newCapsule.sc = currentCapsule;
                newCapsules.add(newCapsule);
            }
        }
        return newCapsules;
    }

    private boolean isSimulatedBy(State state, ComposedState simulator) {
        for (Similar<SimpleState, ComposedState> similars : this.relation) {
            if (!((SimpleState)similars.target).equals(state)) continue;
            return similars.services.contains(simulator);
        }
        return false;
    }

    @Override
    public TransitionSystem<ComposedState, ComposedTransition> getAsyncProduct() {
        return this.async;
    }

    private class Similar<S extends State, T extends State> {
        S target;
        HashSet<T> services;

        private Similar() {
        }
    }

    private class StateCapsule<S extends State> {
        S state;
        StateCapsule<S> sc;

        private StateCapsule() {
        }
    }
}

