/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jgrapht.graph.DirectedMultigraph;
import service.DuplicateStateException;
import service.InvalidArgumentException;
import service.SimpleState;
import service.State;
import service.Transition;
import service.TransitionSystem;

public class TransitionSystemImpl<S extends State, A extends Transition>
extends TransitionSystem<S, A> {
    private DirectedMultigraph<S, Transition> directedGraph = new DirectedMultigraph(Transition.class);
    private String name = "";
    private String errorStr;
    private S initialState = null;
    private int numStates = 0;

    @Override
    public void addAction(S stateFrom, S stateTo, A a) throws Exception {
        if (stateFrom == null) {
            throw new Exception("the argument stateFrom is null");
        }
        if (stateTo == null) {
            throw new Exception("the argument stateTo is null");
        }
        if (a == null) {
            throw new Exception("the argument a is null");
        }
        this.directedGraph.addEdge(stateFrom, stateTo, (Transition)a);
    }

    @Override
    public void addState(S state) throws InvalidArgumentException, DuplicateStateException {
        if (state == null) {
            throw new InvalidArgumentException("the argument state is null");
        }
        if (this.directedGraph.containsVertex(state)) {
            throw new DuplicateStateException("the state with the name \"" + ((State)state).getName() + "\" already exists.");
        }
        if (((State)state).isInitial() && this.initialState != null) {
            throw new InvalidArgumentException("there is already a initial state with the name: " + ((State)state).getName());
        }
        if (((State)state).isInitial()) {
            this.initialState = state;
        }
        this.directedGraph.addVertex(state);
        ++this.numStates;
    }

    @Override
    public Set<A> getActions(S from, S to) throws Exception {
        if (from == null) {
            throw new Exception("the argument from is null");
        }
        if (to == null) {
            throw new Exception("the argument to is null");
        }
        HashSet temp = new HashSet(this.directedGraph.outgoingEdgesOf(from));
        HashSet<Transition> result = new HashSet<Transition>();
        for (Transition a : temp) {
            if (!((State)this.directedGraph.getEdgeTarget(a)).equals(to)) continue;
            result.add(a);
        }
        return result;
    }

    @Override
    public Set<A> getActionsOf(S from) throws Exception {
        if (from == null) {
            throw new Exception("the argument from is null");
        }
        return new HashSet(this.directedGraph.outgoingEdgesOf(from));
    }

    @Override
    public Set<A> getAllActions() {
        return new HashSet(this.directedGraph.edgeSet());
    }

    @Override
    public Set<S> getAllStates() {
        return new HashSet(this.directedGraph.vertexSet());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public S getSourceState(A action) throws Exception {
        if (action == null) {
            throw new Exception("the argument action is null");
        }
        if (this.directedGraph.containsEdge((Transition)action)) {
            return (S)((State)this.directedGraph.getEdgeSource((Transition)action));
        }
        throw new Exception("The action isn't cointained in the graph");
    }

    @Override
    public S getState(String name) {
        Set set = this.directedGraph.vertexSet();
        for (State s : set) {
            if (!s.getName().equals(name)) continue;
            return (S)s;
        }
        return null;
    }

    @Override
    public S getTargetState(A action) throws Exception {
        if (action == null) {
            throw new Exception("the argument action is null");
        }
        if (this.directedGraph.containsEdge((Transition)action)) {
            return (S)((State)this.directedGraph.getEdgeTarget((Transition)action));
        }
        throw new Exception("The action isn't cointained in the graph");
    }

    @Override
    public void setName(String name) throws Exception {
        if (name == null) {
            throw new Exception("the argument name is null");
        }
        this.name = name;
    }

    @Override
    public boolean isValid() {
        if (this.initialState == null) {
            this.errorStr = "There isn't a initial state";
            return false;
        }
        Set<S> states = this.getAllStates();
        Iterator<S> it = states.iterator();
        State state = null;
        boolean tsHasFinal = false;
        while (it.hasNext()) {
            state = (State)it.next();
            if (!state.isFinal()) continue;
            tsHasFinal = true;
            break;
        }
        if (!tsHasFinal) {
            this.errorStr = "There isn't one or more final state";
            return false;
        }
        HashSet<Object> markedState = new HashSet<Object>();
        HashSet<S> notVisitedState = new HashSet<S>();
        try {
            markedState.add(this.initialState);
            Set<A> actionFrom = this.getActionsOf(this.initialState);
            for (Transition action : actionFrom) {
                S targetState = this.getTargetState((A)action);
                if (markedState.contains(targetState)) continue;
                notVisitedState.add(targetState);
            }
            while (!notVisitedState.isEmpty()) {
                State visitedState = (State)notVisitedState.iterator().next();
                notVisitedState.remove(visitedState);
                markedState.add(visitedState);
                actionFrom = this.getActionsOf((S)visitedState);
                for (Transition action : actionFrom) {
                    S targetState = this.getTargetState((A)action);
                    if (markedState.contains(targetState)) continue;
                    notVisitedState.add(targetState);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (markedState.size() != this.numStates) {
            Set<S> states2 = this.getAllStates();
            states2.removeAll(markedState);
            String stateUnreachableStr = "";
            Iterator<S> it2 = states2.iterator();
            while (it2.hasNext()) {
                stateUnreachableStr = String.valueOf(stateUnreachableStr) + ((State)it2.next()).getName() + ",";
            }
            this.errorStr = "Some states are unreachable: " + stateUnreachableStr;
            this.errorStr = String.valueOf(this.errorStr.substring(0, this.errorStr.length() - 1)) + ".";
            return false;
        }
        return true;
    }

    @Override
    public String getError() {
        return this.errorStr;
    }

    @Override
    public S getInitial() {
        return this.initialState;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SimpleState)) {
            return false;
        }
        return ((SimpleState)o).getName().equals(this.name);
    }

    @Override
    public Set<A> getActionsOfStateWithName(S from, String name) throws Exception {
        if (from == null) {
            throw new Exception("the argument from is null");
        }
        Iterator itAction = this.directedGraph.outgoingEdgesOf(from).iterator();
        HashSet<Transition> result = new HashSet<Transition>();
        while (itAction.hasNext()) {
            Transition currentAction = (Transition)itAction.next();
            if (!currentAction.getName().equals(name)) continue;
            result.add(currentAction);
        }
        return result;
    }
}

