/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.io.FileInputStream;
import java.io.InputStream;
import parser.parserTS;
import service.ComposedState;
import service.ComposedStateImpl;
import service.ComposedTransition;
import service.ComposedTransitionImpl;
import service.ServiceFactory;
import service.SimpleState;
import service.SimpleStateImpl;
import service.SimpleTransition;
import service.SimpleTransitionImpl;
import service.State;
import service.Transition;
import service.TransitionSystem;
import service.TransitionSystemImpl;

public class ServiceFactoryImpl
implements ServiceFactory {
    @Override
    public SimpleTransition createSimpleAction(String name, State from, State to) {
        return new SimpleTransitionImpl(name, from, to);
    }

    @Override
    public SimpleState createSimpleState(String name, boolean isInitial, boolean isFinal) {
        return new SimpleStateImpl(name, isInitial, isFinal);
    }

    @Override
    public ComposedTransition createComposedAction(String name, TransitionSystem<? extends State, ? extends Transition> ts, ComposedState from, ComposedState to) {
        return new ComposedTransitionImpl(name, ts, from, to);
    }

    @Override
    public ComposedState createComposedState(String name, State[] states) {
        return new ComposedStateImpl(name, states);
    }

    @Override
    public ComposedState createComposedState(State[] states) {
        return new ComposedStateImpl(states);
    }

    @Override
    public TransitionSystem<ComposedState, ComposedTransition> createComposedTransitionSystem() {
        return new TransitionSystemImpl<ComposedState, ComposedTransition>();
    }

    @Override
    public TransitionSystem<SimpleState, SimpleTransition> createSimpleTransitionSystem() {
        return new TransitionSystemImpl<SimpleState, SimpleTransition>();
    }

    @Override
    public TransitionSystem<SimpleState, SimpleTransition> createSimpleTransitionSystem(String nameFile) throws Exception {
        TransitionSystem<SimpleState, SimpleTransition> TS = null;
        FileInputStream file = new FileInputStream(nameFile);
        ServiceFactoryImpl factory = new ServiceFactoryImpl();
        parserTS pars = new parserTS((InputStream)file, factory);
        TS = pars.createTS();
        if (!TS.isValid()) {
            throw new Exception("TransitionSystem not valid: " + TS.getError());
        }
        file.close();
        return TS;
    }
}

