/*
 * Decompiled with CFR 0.152.
 */
package service;

import java.util.Arrays;
import service.ComposedState;
import service.State;

public class ComposedStateImpl
extends ComposedState {
    State[] states;
    boolean isInitial;
    boolean isFinal;

    public ComposedStateImpl(String name, State[] states) {
        super(name, states);
        this.states = (State[])states.clone();
        this.isInitial = true;
        this.isFinal = true;
        int i = 0;
        while (i < states.length) {
            if (!states[i].isFinal()) {
                this.isFinal = false;
            }
            if (!states[i].isInitial()) {
                this.isInitial = false;
            }
            ++i;
        }
    }

    public ComposedStateImpl(State[] states) {
        super(states);
        this.states = (State[])states.clone();
        String name = "";
        this.isInitial = true;
        this.isFinal = true;
        int i = 0;
        while (i < states.length) {
            if (!states[i].isFinal()) {
                this.isFinal = false;
            }
            if (!states[i].isInitial()) {
                this.isInitial = false;
            }
            name = String.valueOf(name) + states[i].getName();
            ++i;
        }
        this.setName(name);
    }

    @Override
    public State getServicesState(int serviceNumber) throws Exception {
        if (serviceNumber >= this.states.length) {
            throw new Exception("Class: ComposedStateImpl Method: getServiceState Reason: illegalServiceNumber");
        }
        return this.states[serviceNumber];
    }

    @Override
    public State[] getStates() {
        return this.states;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isInitial() {
        return this.isInitial;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.isFinal ? 1231 : 1237);
        result = 31 * result + (this.isInitial ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.states);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComposedStateImpl other = (ComposedStateImpl)obj;
        if (!super.getName().equals(other.getName())) {
            return false;
        }
        if (this.isFinal != other.isFinal) {
            return false;
        }
        if (this.isInitial != other.isInitial) {
            return false;
        }
        return Arrays.equals(this.states, other.states);
    }

    @Override
    public int compareNumberDifferentStates(ComposedState otherState) {
        State[] otherStatesArray = otherState.getStates();
        int result = 0;
        if (otherStatesArray.length != this.states.length) {
            return -1;
        }
        int i = 0;
        while (i < this.states.length) {
            if (!this.states[i].getName().equals(otherStatesArray[i].getName())) {
                ++result;
            }
            ++i;
        }
        return result;
    }
}

