/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayDeque;
import java.util.Deque;
import org.jgrapht.Graph;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.util.TypeUtil;

public class DepthFirstIterator<V, E>
extends CrossComponentIterator<V, E, CrossComponentIterator.VisitColor> {
    private static final Object SENTINEL = new Object();
    private Deque<Object> stack = new ArrayDeque<Object>();
    private transient TypeUtil<V> vertexTypeDecl = null;

    public DepthFirstIterator(Graph<V, E> graph) {
        this(graph, null);
    }

    public DepthFirstIterator(Graph<V, E> graph, V v) {
        super(graph, v);
    }

    @Override
    protected boolean isConnectedComponentExhausted() {
        while (!this.stack.isEmpty()) {
            if (this.stack.getLast() != SENTINEL) {
                return false;
            }
            this.stack.removeLast();
            this.recordFinish();
        }
        return true;
    }

    @Override
    protected void encounterVertex(V v, E e) {
        this.putSeenData(v, CrossComponentIterator.VisitColor.WHITE);
        this.stack.addLast(v);
    }

    @Override
    protected void encounterVertexAgain(V v, E e) {
        CrossComponentIterator.VisitColor visitColor = (CrossComponentIterator.VisitColor)((Object)this.getSeenData(v));
        if (visitColor != CrossComponentIterator.VisitColor.WHITE) {
            return;
        }
        boolean bl = this.stack.removeLastOccurrence(v);
        assert (bl);
        this.stack.addLast(v);
    }

    @Override
    protected V provideNextVertex() {
        Object object;
        while ((object = this.stack.removeLast()) == SENTINEL) {
            this.recordFinish();
        }
        V v = TypeUtil.uncheckedCast(object, this.vertexTypeDecl);
        this.stack.addLast(v);
        this.stack.addLast(SENTINEL);
        this.putSeenData(v, CrossComponentIterator.VisitColor.GRAY);
        return v;
    }

    private void recordFinish() {
        V v = TypeUtil.uncheckedCast(this.stack.removeLast(), this.vertexTypeDecl);
        this.putSeenData(v, CrossComponentIterator.VisitColor.BLACK);
        this.finishVertex(v);
    }
}

